/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.SystemColor;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.GenLabel;
import se.ericsson.cello.support.gui.gengui.MandatoryLabel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public abstract class LabelledField
extends JPanel
implements LocaleChangeListener {
    private GenLabel label = null;
    private boolean mandatory = false;
    private MandatoryLabel mandatoryLabel = null;
    private ComponentLayout layout = null;
    String myBundle = null;
    Locale myLocale;
    private ResourceBundle myResourceBundle = null;
    String toolTipBundle = null;
    String toolTipTag = null;
    String toolTipAddition = "";

    public LabelledField(String translations, String tag) {
        this.setAlignmentX(0.0f);
        this.myBundle = translations;
        this.layout = new ComponentLayout();
        this.label = new GenLabel(translations, tag);
        if (tag.equals("")) {
            this.label.setVisible(false);
        }
        this.setLayout(this.layout);
        this.add(this.label);
        this.putClientProperty("LANGUAGE_CONTROLLED", "NA");
    }

    public LabelledField(String tag) {
        this.setAlignmentX(0.0f);
        this.layout = new ComponentLayout();
        this.label = new GenLabel(tag);
        if (tag.equals("")) {
            this.label.setVisible(false);
        }
        this.setLayout(this.layout);
        this.add(this.label);
    }

    public void updateLocale(Locale locale) {
        this.myLocale = locale;
        this.label.updateLocale(locale);
        this.myResourceBundle = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
    }

    String translateString(String tag) {
        String transTag = "";
        if (tag != null) {
            try {
                transTag = this.myResourceBundle.getString(tag);
            }
            catch (MissingResourceException mre) {
                transTag = tag;
            }
        }
        return transTag;
    }

    public void setMandatory(boolean set) {
        if (!this.mandatory && set) {
            this.mandatoryLabel = new MandatoryLabel();
            this.add(this.mandatoryLabel);
            this.mandatory = true;
        } else if (this.mandatory && !set) {
            this.remove(this.mandatoryLabel);
            this.mandatory = false;
        }
        this.layoutComponent();
    }

    public GenLabel getLabel() {
        Log.trace("getLabel()");
        return this.label;
    }

    public abstract Object getFieldComponent();

    public void setToolTip(String bundle, String tag) {
        Log.trace("setToolTip(" + tag + ")");
        this.toolTipBundle = bundle;
        this.toolTipTag = tag;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String text) {
        Log.trace("setToolTip(" + text + ")");
        JComponent myComp = (JComponent)this.getFieldComponent();
        myComp.setToolTipText(text);
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle ttBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            JComponent comp = (JComponent)this.getFieldComponent();
            if (this.toolTipTag != null) {
                try {
                    comp.setToolTipText(ttBundle.getString(this.toolTipTag) + this.toolTipAddition);
                }
                catch (MissingResourceException mre) {
                    comp.setToolTipText(this.toolTipTag + this.toolTipAddition);
                }
            }
        }
    }

    public void setToolTip(String bundle, String tag, String additionalText) {
        this.toolTipAddition = additionalText;
        if (null == tag) {
            JComponent comp = (JComponent)this.getFieldComponent();
            comp.setToolTipText(this.toolTipAddition);
        } else {
            this.setToolTip(bundle, tag);
        }
    }

    public void setEditable(boolean set) {
        Log.trace("setEditable()");
        JComponent myComp = (JComponent)this.getFieldComponent();
        if (JTextComponent.class.isAssignableFrom(this.getFieldComponent().getClass())) {
            JTextComponent textComp = (JTextComponent)myComp;
            textComp.setEditable(set);
            if (set) {
                try {
                    textComp.setBackground(SystemColor.window);
                    textComp.setBorder(((JTextComponent)this.getFieldComponent().getClass().newInstance()).getBorder());
                }
                catch (InstantiationException e) {
                    Log.logError("Error create text component", e);
                }
                catch (IllegalAccessException i) {
                    Log.logError("Error create text component", i);
                }
            } else {
                textComp.setBackground(SystemColor.text);
                textComp.setDisabledTextColor(SystemColor.textText);
                textComp.setBorder(new EmptyBorder(textComp.getBorder().getBorderInsets(textComp)));
            }
        } else {
            myComp.setEnabled(set);
        }
    }

    public void setEnabled(boolean set) {
        JComponent myComp = (JComponent)this.getFieldComponent();
        myComp.setEnabled(set);
        this.label.setEnabled(set);
    }

    public void setUnderneath(boolean set) {
        this.layout.setUnderneath(set);
        this.layoutComponent();
    }

    public boolean isSetUnderneath() {
        return this.layout.isSetUnderneath();
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    protected void layoutComponent() {
        this.layout.layoutContainer(this);
        this.updateUI();
    }
}

