/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class SlotSelector
extends LabelledField
implements KeyListener,
MouseListener {
    private JCheckBox[] slots;
    private Integer[] mask = new Integer[0];
    private JPanel slotRow = null;
    private int baseValue = 0;
    boolean shiftKeyDown = false;
    int anchorSlot = -1;

    public SlotSelector(String name, int nrOfSlots, int beginValue) {
        super(name);
        this.baseValue = beginValue;
        this.slots = new JCheckBox[nrOfSlots];
        this.buildGui();
        this.selectAllSlots(false);
    }

    public void reinitialize(String newName, int newNrOfSlots, int beginValue) {
        this.getLabel().setText(newName);
        this.baseValue = beginValue;
        if (this.slotRow != null) {
            this.remove(this.slotRow);
        }
        this.slots = new JCheckBox[newNrOfSlots];
        this.buildGui();
        this.selectAllSlots(false);
        this.repaint();
    }

    protected void buildGui() {
        this.slotRow = this.createSlotRow();
        this.add(this.slotRow);
        this.setKeyListener(this);
        this.setMouseListener(this);
        this.setToolTip("GENSLOTSELECTOR");
        this.setToolTipToAllSlots("GENSLOTSELECTOR");
    }

    private JPanel createSlotRow() {
        JPanel slotRow = new JPanel();
        slotRow.setLayout(new FlowLayout(0));
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new JCheckBox();
            this.slots[i].setMargin(new Insets(0, 0, 0, 0));
            this.slots[i].setBorder(null);
            this.slots[i].setVerticalTextPosition(1);
            this.slots[i].setVerticalAlignment(3);
            this.slots[i].setText(Integer.toString(i + this.baseValue));
            this.slots[i].setHorizontalTextPosition(0);
            this.slots[i].setHorizontalAlignment(0);
            this.slots[i].setEnabled(false);
            this.slots[i].setSelected(false);
            slotRow.add(this.slots[i]);
        }
        return slotRow;
    }

    public void activate(Integer[] editMask) {
        this.mask = editMask;
        this.selectAllSlots(false);
        this.enableAllSlots(true);
        this.getLabel().setEnabled(true);
        this.enableSlots(false, editMask);
        this.selectSlots(editMask);
    }

    public void activate(int[] editMask) {
        this.mask = this.intToInteger(editMask);
        this.selectAllSlots(false);
        this.enableAllSlots(true);
        this.getLabel().setEnabled(true);
        this.enableSlots(false, editMask);
        this.selectSlots(editMask);
    }

    public Integer[] intToInteger(int[] source) {
        Integer[] result = null;
        if (source != null) {
            result = new Integer[source.length];
            for (int i = 0; i < source.length; ++i) {
                result[i] = new Integer(source[i]);
            }
        }
        return result;
    }

    public void activate() {
        this.mask = null;
        this.selectAllSlots(false);
        this.enableAllSlots(true);
        this.getLabel().setEnabled(true);
    }

    public void deactivate() {
        this.selectAllSlots(false);
        this.enableAllSlots(false);
        this.getLabel().setEnabled(false);
        this.mask = null;
    }

    public void selectAllSlots(boolean selected) {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].setSelected(selected);
        }
    }

    public void selectSlots(Integer[] selection) {
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] >= 0 && selection[i] < this.slots.length + this.baseValue) {
                this.slots[selection[i] - this.baseValue].setSelected(true);
                continue;
            }
            Log.logError("Unable to select slot what is not displayed in SlotSelector");
        }
    }

    public void selectSlots(int[] selection) {
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] >= 0 && selection[i] < this.slots.length + this.baseValue) {
                this.slots[selection[i] - this.baseValue].setSelected(true);
                continue;
            }
            Log.logError("Unable to select slot what is not displayed in SlotSelector");
        }
    }

    public void enableAllSlots(boolean enable) {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].setEnabled(enable);
        }
    }

    public void enableSlots(boolean enable, Integer[] editMask) {
        for (int i = 0; i < editMask.length; ++i) {
            this.slots[editMask[i] - this.baseValue].setEnabled(enable);
        }
    }

    public void enableSlots(boolean enable, int[] editMask) {
        for (int i = 0; i < editMask.length; ++i) {
            this.slots[editMask[i] - this.baseValue].setEnabled(enable);
        }
    }

    public Integer[] getAllSelectedSlots() {
        int i;
        Integer[] bufferInUseIndexes = new Integer[this.slots.length];
        int arrayIndex = 0;
        for (i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].isSelected()) continue;
            bufferInUseIndexes[arrayIndex] = new Integer(i);
            ++arrayIndex;
        }
        Integer[] slotsInUseIndexes = new Integer[arrayIndex];
        for (i = 0; i < arrayIndex; ++i) {
            slotsInUseIndexes[i] = new Integer(bufferInUseIndexes[i] + this.baseValue);
        }
        return slotsInUseIndexes;
    }

    public Integer[] getUserSelectedSlots() {
        int i;
        Integer[] bufferInUseIndexes = new Integer[this.slots.length];
        int arrayIndex = 0;
        for (i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].isSelected() || this.isPartOfMask(i)) continue;
            bufferInUseIndexes[arrayIndex] = new Integer(i);
            ++arrayIndex;
        }
        Integer[] slotsInUseIndexes = new Integer[arrayIndex];
        for (i = 0; i < arrayIndex; ++i) {
            slotsInUseIndexes[i] = new Integer(bufferInUseIndexes[i] + this.baseValue);
        }
        return slotsInUseIndexes;
    }

    private boolean isPartOfMask(int slotNumber) {
        boolean isPart = false;
        if (this.mask != null) {
            for (int i = 0; i < this.mask.length && !isPart; ++i) {
                isPart = this.mask[i] == slotNumber + this.baseValue;
            }
        }
        return isPart;
    }

    public void addToMask(Integer[] addition) {
        int i;
        int bufferIndex = 0;
        Integer[] bufferMask = new Integer[this.slots.length];
        if (this.mask != null) {
            for (i = 0; i < this.mask.length; ++i) {
                bufferMask[i] = this.mask[i];
                ++bufferIndex;
            }
        }
        for (i = 0; i < addition.length; ++i) {
            if (this.isPartOfMask(addition[i]) || addition[i] < 0 || addition[i] >= this.slots.length + this.baseValue) continue;
            bufferMask[bufferIndex] = addition[i];
            ++bufferIndex;
        }
        this.mask = new Integer[bufferIndex];
        for (i = 0; i < bufferIndex; ++i) {
            this.mask[i] = bufferMask[i];
        }
        this.enableSlots(false, this.mask);
        this.selectSlots(this.mask);
    }

    public void addToMask(int[] addition) {
        this.addToMask(this.intToInteger(addition));
    }

    public Integer[] getMask() {
        return this.mask;
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        if (aListener != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].addActionListener(aListener);
                this.slots[i].setActionCommand(aCommand);
            }
        }
    }

    public Object getFieldComponent() {
        return this;
    }

    public void readOnly(boolean option) {
        this.enableAllSlots(option);
    }

    public void setKeyListener(KeyListener aListener) {
        if (aListener != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].addKeyListener(aListener);
            }
        }
    }

    public void setToolTipToAllSlots(String toolTip) {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].setToolTipText(toolTip);
        }
    }

    public void setMouseListener(MouseListener aListener) {
        if (aListener != null) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].addMouseListener(aListener);
            }
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (this.shiftKeyDown) {
            return;
        }
        if (evt.isShiftDown()) {
            this.shiftKeyDown = true;
        }
    }

    public void keyReleased(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 16 && this.shiftKeyDown) {
            this.shiftKeyDown = false;
            this.anchorSlot = -1;
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!this.shiftKeyDown) {
            JCheckBox source = (JCheckBox)e.getComponent();
            String slotText = source.getText();
            this.anchorSlot = new Integer(slotText);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.anchorSlot == -1) {
            return;
        }
        JCheckBox source = (JCheckBox)e.getComponent();
        String slotText = source.getText();
        int slotNo = new Integer(slotText);
        if (this.shiftKeyDown) {
            int slotNoShiftDownMin = -1;
            int slotNoShiftDownMax = -1;
            if (this.anchorSlot > slotNo) {
                slotNoShiftDownMax = this.anchorSlot;
                slotNoShiftDownMin = slotNo;
            } else {
                slotNoShiftDownMax = slotNo;
                slotNoShiftDownMin = this.anchorSlot;
            }
            int numberOfSlots = slotNoShiftDownMax - slotNoShiftDownMin + 1;
            Integer[] theSlots = new Integer[numberOfSlots];
            for (int i = 0; i < theSlots.length; ++i) {
                theSlots[i] = new Integer(i + slotNoShiftDownMin);
            }
            this.selectAllSlots(false);
            this.selectSlots(theSlots);
        }
    }
}

