/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

class TranslatableBitLabel
extends JTextField
implements Translatable {
    private ResourceBundle myBundle = null;
    private Object[] translatableTags = new Object[0];

    TranslatableBitLabel() {
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(null);
    }

    public void setText(String text) {
        super.setText(" " + text);
    }

    void setTranslatableTags(Object[] tags) {
        this.translatableTags = tags;
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(null);
        if (this.myBundle != null) {
            this.updateLocale();
        }
    }

    void updateLocale() {
        String label = "";
        for (int i = 0; i < this.translatableTags.length; ++i) {
            try {
                label = label.concat(this.myBundle.getString((String)this.translatableTags[i]));
            }
            catch (MissingResourceException mre) {
                label = label.concat((String)this.translatableTags[i]);
            }
            if (i == this.translatableTags.length - 1) continue;
            label = label.concat(", ");
        }
        this.setText(label);
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        this.myBundle = bundle;
        this.updateLocale();
    }
}

