/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.date;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalComboBoxUI;
import se.ericsson.cello.support.gui.gengui.ui.date.DateField;
import se.ericsson.cello.support.gui.gengui.ui.general.SpinBox;

public class CalendarPanel
extends JPanel
implements ItemSelectable {
    protected MonthAndYearPanel monthAndYearPanel;
    protected DaysPanel daysPanel;
    protected int year;
    protected int month;
    protected int day;
    private Calendar calendar;
    private WeekdayPanel weekdayPanel;
    private String dateString;
    private Date date;
    private DateFormatSymbols dateFormatSymbols;
    private DateFormat dateFormat;
    private int amountWeekdays;
    private Dimension size;
    private MyKeyListener keyListener = new MyKeyListener();
    private MyActionListener actionListener = new MyActionListener();
    private boolean keepFocus;
    private DateField calendarOwner;
    private Locale locale;
    private int dateStyle;
    private int selectedButtonIndex;
    private boolean nullFlag;
    private static final boolean debug = false;

    public CalendarPanel() {
        this(Locale.getDefault());
    }

    public CalendarPanel(Locale l) {
        this(l, 3);
    }

    public CalendarPanel(Locale l, int style) {
        this(l, style, null, new GregorianCalendar());
    }

    public CalendarPanel(Locale l, int style, Calendar c) {
        this(l, style, null, c);
    }

    public CalendarPanel(Locale l, int style, DateField df) {
        this(l, style, df, new GregorianCalendar());
    }

    public CalendarPanel(Locale l, int style, DateField df, Calendar c) {
        this.locale = l;
        this.dateStyle = style;
        this.calendarOwner = df;
        this.size = new Dimension(0, 0);
        this.calendar = c;
        this.calendar = Calendar.getInstance(this.locale);
        c.setLenient(false);
        this.dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dateFormat = new SimpleDateFormat();
        this.setDateStyle(this.dateStyle);
        this.calendar.setTime(c.getTime());
        this.amountWeekdays = this.dateFormatSymbols.getShortWeekdays().length - 1;
        this.monthAndYearPanel = new MonthAndYearPanel();
        this.weekdayPanel = new WeekdayPanel();
        this.daysPanel = new DaysPanel();
        this.layoutPanels();
        this.registerListeners();
    }

    public void setDate() {
        this.nullFlag = false;
        int tempMonth = this.calendar.get(2);
        int tempYear = this.calendar.get(1);
        int tempDay = this.calendar.get(5);
        this.calendar.set(this.year, this.month, this.day);
        this.calendar.set(15, 0);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        if (tempMonth != this.month && this.calendar.get(2) - this.month == 1 && Math.abs(this.calendar.get(2) - tempMonth) != 1 || tempYear != this.calendar.get(1) && tempMonth != this.calendar.get(2) && tempDay != this.calendar.get(5) && tempMonth == this.month && tempDay == this.day) {
            this.calendar.set(this.year, this.calendar.get(2), 0);
        }
        this.debug("setDate : date(y m d) = " + this.calendar.get(1) + " " + this.calendar.get(2) + " " + this.calendar.get(5));
        this.updatePanel();
        this.fireItemStateChanged(new ItemEvent(this, 701, this.getDate(), 1));
        this.updateUI();
    }

    public void setDate(Date d) {
        if (d != null) {
            this.nullFlag = false;
            this.calendar.setTime(d);
            this.year = this.calendar.get(1);
            this.month = this.calendar.get(2);
            this.day = this.calendar.get(5);
            this.setDate();
        } else {
            this.nullFlag = true;
            this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
        }
    }

    public String getDateToString() {
        if (this.nullFlag) {
            return null;
        }
        this.calendar.set(this.year, this.month, this.day);
        return this.dateFormat.format(this.calendar.getTime());
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void setDateStyle(int style) {
        this.dateStyle = style;
        this.dateFormat = DateFormat.getDateInstance(this.dateStyle, this.locale);
    }

    public int getDateStyle() {
        return this.dateStyle;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        this.calendar = Calendar.getInstance(this.locale);
        this.dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.setDateStyle(this.dateStyle);
        this.monthAndYearPanel.setMonths(this.dateFormatSymbols.getMonths());
        this.weekdayPanel.setWeekdays(this.dateFormatSymbols.getShortWeekdays());
        this.validate();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCalendar(Calendar newCalendar) {
        this.year = newCalendar.get(1);
        this.month = newCalendar.get(2);
        this.day = newCalendar.get(5);
        this.calendar = Calendar.getInstance(this.locale);
        this.setDate();
        this.monthAndYearPanel.layoutComponents();
        this.weekdayPanel.layoutComponents();
        this.daysPanel.layoutMonth();
        this.daysPanel.layoutComponents();
        this.layoutPanels();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void requestFocus() {
        this.daysPanel.validate();
        this.actionListener.actionPerformed(new ActionEvent(this.daysPanel, 1001, "drop_focus_dayspanel"));
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public Object[] getSelectedObjects() {
        Date selectedObject = this.getDate();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent event) {
        Object[] l = this.listenerList.getListenerList();
        for (int k = l.length - 2; k >= 0; k -= 2) {
            if (l[k] != ItemListener.class) continue;
            ((ItemListener)l[k + 1]).itemStateChanged(event);
        }
    }

    private void layoutPanels() {
        this.setVisible(false);
        this.removeAll();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        layout.setVgap(2);
        if (this.weekdayPanel != null) {
            this.add("North", this.weekdayPanel);
        }
        if (this.daysPanel != null) {
            this.add("Center", this.daysPanel);
        }
        if (this.monthAndYearPanel != null) {
            this.add("South", this.monthAndYearPanel);
        }
        this.setVisible(true);
    }

    private void updatePanel() {
        this.day = this.calendar.get(5);
        this.month = this.calendar.get(2);
        this.year = this.calendar.get(1);
        this.daysPanel.layoutMonth();
        this.monthAndYearPanel.monthBox.setSelectedIndex(this.month);
        this.monthAndYearPanel.yearBox.setText(String.valueOf(this.year));
        this.monthAndYearPanel.invalidate();
        this.repaint();
    }

    private void registerListeners() {
        if (this.calendarOwner == null) {
            MyItemListener itemListener = new MyItemListener();
            this.monthAndYearPanel.monthBox.addItemListener(itemListener);
            this.monthAndYearPanel.yearBox.addItemListener(itemListener);
        }
        MyFocusListener focusListener = new MyFocusListener();
        this.daysPanel.addFocusListener(focusListener);
        this.daysPanel.setRequestFocusEnabled(true);
        for (int i = 0; i < 42; ++i) {
            this.daysPanel.dayButtons[i].addKeyListener(this.keyListener);
        }
    }

    private void gridBagAdd(JPanel dest, JComponent comp, GridBagLayout gb, GridBagConstraints gbc) {
        dest.add(comp);
        gb.setConstraints(comp, gbc);
    }

    private void debug(String string) {
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && !CalendarPanel.this.keepFocus) {
                if (e.getItemSelectable() == CalendarPanel.this.monthAndYearPanel.monthBox) {
                    CalendarPanel.this.month = CalendarPanel.this.monthAndYearPanel.monthBox.getSelectedIndex();
                } else {
                    CalendarPanel.this.year = Integer.valueOf(CalendarPanel.this.monthAndYearPanel.yearBox.getText());
                }
                if (e.getSource() instanceof JComboBox && ((JComboBox)e.getSource()).getUI() instanceof MetalComboBoxUI) {
                    ((JComboBox)e.getSource()).getComponent(0).requestFocus();
                } else {
                    ((JComponent)e.getSource()).requestFocus();
                }
                CalendarPanel.this.setDate();
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof DaysPanel) {
                int i = 0;
                while (!CalendarPanel.this.daysPanel.dayButtons[i].isSelected()) {
                    ++i;
                }
                CalendarPanel.this.daysPanel.dayButtons[i].requestFocus();
            }
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int modification = 0;
            if (e.getComponent() instanceof JToggleButton && (e.getKeyCode() == 39 || e.getKeyCode() == 37 || e.getKeyCode() == 40 || e.getKeyCode() == 38)) {
                if (e.getKeyCode() == 39) {
                    modification = 1;
                } else if (e.getKeyCode() == 37) {
                    modification = -1;
                } else if (e.getKeyCode() == 40) {
                    modification = CalendarPanel.this.amountWeekdays;
                } else if (e.getKeyCode() == 38) {
                    modification = -CalendarPanel.this.amountWeekdays;
                }
                CalendarPanel.this.day += modification;
                GregorianCalendar tempCalendar = new GregorianCalendar();
                tempCalendar.set(CalendarPanel.this.year, CalendarPanel.this.month, CalendarPanel.this.day);
                if (tempCalendar.get(2) != CalendarPanel.this.month) {
                    CalendarPanel.this.keepFocus = true;
                    CalendarPanel.this.setDate();
                    CalendarPanel.this.daysPanel.dayButtons[CalendarPanel.this.selectedButtonIndex].doClick();
                } else {
                    CalendarPanel.this.selectedButtonIndex = Integer.parseInt(((JToggleButton)e.getComponent()).getClientProperty("index").toString()) + modification;
                    CalendarPanel.this.daysPanel.dayButtons[CalendarPanel.this.selectedButtonIndex].doClick();
                }
            }
            CalendarPanel.this.keepFocus = false;
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getComponent() == CalendarPanel.this.daysPanel) {
                CalendarPanel.this.actionListener.actionPerformed(new ActionEvent(CalendarPanel.this.daysPanel, 1001, "drop_focus_dayspanel"));
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class WeekdayPanel
    extends JPanel {
        public JLabel[] label;

        public WeekdayPanel() {
            this.label = new JLabel[CalendarPanel.this.amountWeekdays];
            for (int i = 0; i < CalendarPanel.this.amountWeekdays; ++i) {
                this.label[i] = new JLabel();
                this.label[i].setHorizontalAlignment(0);
                this.label[i].setVerticalAlignment(0);
            }
            this.setWeekdays(CalendarPanel.this.dateFormatSymbols.getShortWeekdays());
        }

        public void setWeekdays(String[] days) {
            int firstDay = CalendarPanel.this.calendar.getFirstDayOfWeek();
            for (int i = 0; i < CalendarPanel.this.amountWeekdays; ++i) {
                this.label[i].setText(days[(firstDay + i - 1) % CalendarPanel.this.amountWeekdays + 1]);
                this.label[i].validate();
            }
            CalendarPanel.this.size = this.label[0].getPreferredSize();
            this.layoutComponents();
        }

        public void layoutComponents() {
            this.removeAll();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            this.setLayout(gridbag);
            for (int i = 0; i < CalendarPanel.this.amountWeekdays; ++i) {
                if (this.label[i].getPreferredSize().width <= ((CalendarPanel)CalendarPanel.this).size.width) continue;
                CalendarPanel.this.size = this.label[i].getPreferredSize();
            }
            JToggleButton testButton = new JToggleButton("33");
            testButton.setMargin(new Insets(2, 2, 2, 2));
            if (testButton.getPreferredSize().width > ((CalendarPanel)CalendarPanel.this).size.width) {
                ((CalendarPanel)CalendarPanel.this).size.width = testButton.getPreferredSize().width;
            }
            if (CalendarPanel.this.monthAndYearPanel.getPreferredSize().width / CalendarPanel.this.amountWeekdays > ((CalendarPanel)CalendarPanel.this).size.width) {
                ((CalendarPanel)CalendarPanel.this).size.width = CalendarPanel.this.monthAndYearPanel.getPreferredSize().width / CalendarPanel.this.amountWeekdays;
            }
            for (int i = 0; i < CalendarPanel.this.amountWeekdays; ++i) {
                if (this.label[i] == null) continue;
                if (i == CalendarPanel.this.amountWeekdays - 1) {
                    gbc.gridwidth = 0;
                }
                gbc.ipadx = ((CalendarPanel)CalendarPanel.this).size.width - this.label[i].getPreferredSize().width;
                CalendarPanel.this.gridBagAdd(this, this.label[i], gridbag, gbc);
            }
        }
    }

    protected class MonthAndYearPanel
    extends JPanel {
        public JComboBox monthBox;
        public SpinBox yearBox;

        public MonthAndYearPanel() {
            String[] months = CalendarPanel.this.dateFormatSymbols.getMonths();
            this.monthBox = new JComboBox<String>(months);
            this.yearBox = new SpinBox(String.valueOf(CalendarPanel.this.calendar.get(1)));
            this.monthBox.setSelectedIndex(CalendarPanel.this.calendar.get(2));
            this.layoutComponents();
        }

        public void setMonths(String[] months) {
            this.monthBox.hidePopup();
            int monthRemainder = CalendarPanel.this.month;
            this.monthBox.removeAllItems();
            for (int i = 0; i < months.length; ++i) {
                this.monthBox.addItem(months[i]);
            }
            this.monthBox.setSelectedIndex(monthRemainder);
            CalendarPanel.this.debug("setMonths : selected index = " + this.monthBox.getSelectedIndex());
            this.monthBox.validate();
        }

        public void setYear(int year) {
            this.yearBox.setText(String.valueOf(year));
            this.yearBox.validate();
        }

        public void layoutComponents() {
            this.removeAll();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            this.setLayout(gridbag);
            if (this.monthBox != null && this.yearBox != null) {
                gbc.fill = 1;
                gbc.weightx = 0.0;
                CalendarPanel.this.gridBagAdd(this, this.monthBox, gridbag, gbc);
                gbc.fill = 1;
                gbc.weightx = 1.0;
                CalendarPanel.this.gridBagAdd(this, this.yearBox, gridbag, gbc);
            }
        }
    }

    protected class DaysPanel
    extends JPanel {
        public JToggleButton[] dayButtons;
        public ButtonGroup group;

        public DaysPanel() {
            Insets insets = new Insets(2, 2, 2, 2);
            CalendarPanel.this.month = CalendarPanel.this.calendar.get(2);
            CalendarPanel.this.year = CalendarPanel.this.calendar.get(1);
            CalendarPanel.this.day = CalendarPanel.this.calendar.get(5);
            this.dayButtons = new JToggleButton[42];
            this.group = new ButtonGroup();
            for (int i = 0; i < 42; ++i) {
                this.dayButtons[i] = new JToggleButton();
                this.dayButtons[i].setMargin(insets);
                this.dayButtons[i].setText("");
                this.dayButtons[i].putClientProperty("index", String.valueOf(i));
                this.group.add(this.dayButtons[i]);
            }
            this.layoutMonth();
            this.layoutComponents();
        }

        public void updateUI() {
            super.updateUI();
            if (this.dayButtons != null) {
                for (int i = 0; i < 42; ++i) {
                    this.dayButtons[i].updateUI();
                }
            }
        }

        public void layoutMonth() {
            int dayCount = 1;
            CalendarPanel.this.calendar.set(1, CalendarPanel.this.year);
            CalendarPanel.this.calendar.set(2, CalendarPanel.this.month);
            CalendarPanel.this.calendar.set(5, 1);
            int day_of_week = CalendarPanel.this.calendar.get(7);
            if (this.dayButtons != null) {
                int index = (CalendarPanel.this.amountWeekdays - (CalendarPanel.this.calendar.getFirstDayOfWeek() - day_of_week)) % CalendarPanel.this.amountWeekdays;
                if (index == 0) {
                    index = 7;
                }
                CalendarPanel.this.calendar.set(5, -index + 1);
                index = 0;
                while (CalendarPanel.this.calendar.get(2) != CalendarPanel.this.month) {
                    this.dayButtons[index].setText(String.valueOf(CalendarPanel.this.calendar.get(5)));
                    this.dayButtons[index].setEnabled(false);
                    this.dayButtons[index].validate();
                    CalendarPanel.this.calendar.set(5, CalendarPanel.this.calendar.get(5) + 1);
                    ++index;
                }
                while (CalendarPanel.this.calendar.get(2) == CalendarPanel.this.month) {
                    this.group.add(this.dayButtons[index]);
                    this.dayButtons[index].setEnabled(true);
                    this.dayButtons[index].validate();
                    this.dayButtons[index].setText(String.valueOf(dayCount));
                    if (dayCount == CalendarPanel.this.day) {
                        this.dayButtons[index].setSelected(true);
                        CalendarPanel.this.selectedButtonIndex = index;
                    }
                    ++index;
                    CalendarPanel.this.calendar.set(5, ++dayCount);
                }
                while (index < 42) {
                    this.dayButtons[index].setText(String.valueOf(CalendarPanel.this.calendar.get(5)));
                    this.dayButtons[index].setEnabled(false);
                    this.dayButtons[index].validate();
                    CalendarPanel.this.calendar.set(5, CalendarPanel.this.calendar.get(5) + 1);
                    ++index;
                }
                CalendarPanel.this.calendar.set(1, CalendarPanel.this.year);
                CalendarPanel.this.calendar.set(2, CalendarPanel.this.month);
                CalendarPanel.this.calendar.set(5, CalendarPanel.this.day);
            }
        }

        public void layoutComponents() {
            this.removeAll();
            this.setLayout(new GridLayout(42 / CalendarPanel.this.amountWeekdays, CalendarPanel.this.amountWeekdays));
            for (int i = 0; i < 42; ++i) {
                this.add(this.dayButtons[i]);
            }
            this.setVisible(true);
        }
    }
}

