/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.date;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.ericsson.cello.support.gui.gengui.ui.date.Parser;

public class TimeParser
extends Parser {
    private DateFormatSymbols formatSymbols;
    private Date time;
    private String[] patternList;
    private String[] timeList;
    private String[] prefixList;
    private Locale locale;
    private char hourChar;
    private boolean amPmFlag = false;
    private boolean timeZoneFlag = false;

    public TimeParser() {
        this(Locale.getDefault(), 3);
    }

    public TimeParser(Locale loc) {
        this(loc, 3);
    }

    public TimeParser(Locale loc, int timeStyle) {
        super(loc, timeStyle);
        int i;
        this.locale = loc;
        this.dateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(timeStyle, this.locale);
        this.setDefaultPatternString(this.dateFormat.toPattern());
        this.formatSymbols = new DateFormatSymbols(loc);
        int index = 0;
        this.timeList = new String[12];
        String defaultPattern = this.getDefaultPattern();
        if (defaultPattern.indexOf("h") > -1 || defaultPattern.indexOf("H") > -1) {
            this.hourChar = defaultPattern.indexOf("h") > -1 ? (char)104 : (char)72;
            this.timeList[index++] = "HH:mm:ss";
            this.timeList[index++] = "H:mm:ss";
            this.timeList[index++] = "HH:mm";
            this.timeList[index++] = "H:mm";
            this.timeList[index++] = "HHmm";
            this.timeList[index++] = "HHmmss";
            this.timeList[index++] = "hh:mm:ss";
            this.timeList[index++] = "h:mm:ss";
            this.timeList[index++] = "hh:mm";
            this.timeList[index++] = "h:mm";
            this.timeList[index++] = "hhmm";
            this.timeList[index++] = "hhmmss";
        } else if (defaultPattern.indexOf("k") > -1 || defaultPattern.indexOf("K") > -1) {
            this.hourChar = defaultPattern.indexOf("k") > -1 ? (char)107 : (char)75;
            this.timeList[index++] = "KK:mm:ss";
            this.timeList[index++] = "K:mm:ss";
            this.timeList[index++] = "KK:mm";
            this.timeList[index++] = "K:mm";
            this.timeList[index++] = "KKmm";
            this.timeList[index++] = "KKmmss";
            this.timeList[index++] = "kk:mm:ss";
            this.timeList[index++] = "k:mm:ss";
            this.timeList[index++] = "kk:mm";
            this.timeList[index++] = "k:mm";
            this.timeList[index++] = "kkmmss";
            this.timeList[index++] = "kkmm";
        }
        String[] tempList = new String[index];
        for (int i2 = 0; i2 < index; ++i2) {
            if (this.hourChar == 'h' || this.hourChar == 'k') {
                if (i2 < index / 2) {
                    tempList[i2] = this.timeList[index / 2 + i2];
                    continue;
                }
                tempList[i2] = this.timeList[i2 - index / 2];
                continue;
            }
            tempList[i2] = this.timeList[i2];
        }
        this.timeList = tempList;
        this.prefixList = new String[6];
        this.prefixList[0] = " ";
        this.prefixList[1] = "a";
        this.prefixList[2] = "z";
        this.prefixList[3] = "zzz";
        this.prefixList[4] = "a z";
        this.prefixList[5] = "a zzz";
        this.patternList = new String[this.timeList.length * this.prefixList.length];
        int count = 0;
        for (i = 0; i < this.prefixList.length; ++i) {
            for (int j = 0; j < this.timeList.length; ++j) {
                this.patternList[count] = this.prefixList[i].equals(" ") ? this.timeList[j] : this.prefixList[i] + " " + this.timeList[j];
                if (this.patternList[count].indexOf(97) > -1 && this.patternList[count].indexOf(72) > -1) continue;
                ++count;
            }
        }
        tempList = new String[count];
        for (i = 0; i < count; ++i) {
            tempList[i] = this.patternList[i];
        }
        this.patternList = tempList;
    }

    public Date parseDate(String parseString) {
        this.time = null;
        if (!this.isDefinedPattern()) {
            if ((parseString = this.strip(parseString)).length() < 4) {
                return null;
            }
            parseString = parseString.toUpperCase();
            int i = 0;
            this.dateFormat.applyPattern(this.patternList[i]);
            while (this.time == null && i < this.patternList.length) {
                try {
                    this.dateFormat.setLenient(false);
                    if (!this.amPmFlag && this.patternList[i].indexOf(97) > -1 || this.amPmFlag && this.patternList[i].indexOf(97) < 0) {
                        throw new ParseException("ParseString or pattern contains no am/pm", 0);
                    }
                    if (!this.timeZoneFlag && this.patternList[i].indexOf(122) > -1 || this.timeZoneFlag && this.patternList[i].indexOf(122) < 0) {
                        throw new ParseException("ParseString or pattern contains no time zone", 0);
                    }
                    if (this.locationOfLetter(parseString) < 0 && (this.patternList[i].indexOf("a") >= 0 || this.patternList[i].indexOf("z") >= 0)) {
                        throw new ParseException("ParseString contains no letters", 0);
                    }
                    if (Character.isDigit(parseString.charAt(0)) && (this.patternList[i].startsWith("a") || this.patternList[i].startsWith("z"))) {
                        throw new ParseException("Pattern do not start with numerics", 0);
                    }
                    if (this.locationOfLetter(parseString) > -1 && this.patternList[i].indexOf("a") < 0 && this.patternList[i].indexOf("z") < 0) {
                        throw new ParseException("Pattern contains no letters", 0);
                    }
                    if (this.amPmFlag && this.timeZoneFlag && this.patternList[i].indexOf(97) < 0 && this.patternList[i].indexOf(122) < 0) {
                        throw new ParseException("Pattern does not contains am/pm and time zone)", 0);
                    }
                    if (!this.amPmFlag && !this.timeZoneFlag && this.patternList[i].indexOf(97) > -1 && this.patternList[i].indexOf(122) > -1) {
                        throw new ParseException("ParseString does not contains am/pm and time zone)", 0);
                    }
                    this.time = this.dateFormat.parse(parseString);
                }
                catch (Exception e) {
                    this.time = null;
                    this.dateFormat.applyPattern(this.patternList[i]);
                    ++i;
                }
            }
        } else {
            try {
                this.time = this.dateFormat.parse(parseString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return this.time;
    }

    public boolean isHourField(String parseString, int caretPosition) {
        int[] pos = this.getFieldPositions(3, parseString);
        return caretPosition >= pos[0] && caretPosition <= pos[1];
    }

    public boolean isMinuteField(String parseString, int caretPosition) {
        int[] pos = this.getFieldPositions(4, parseString);
        return caretPosition >= pos[0] && caretPosition <= pos[1];
    }

    public boolean isSecondField(String parseString, int caretPosition) {
        int[] pos = this.getFieldPositions(5, parseString);
        return caretPosition >= pos[0] && caretPosition <= pos[1];
    }

    public boolean isAmPmField(String parseString, int caretPosition) {
        int[] pos = this.getFieldPositions(7, parseString);
        return caretPosition >= pos[0] && caretPosition <= pos[1];
    }

    public boolean isTimeZoneField(String parseString, int caretPosition) {
        int[] pos = this.getFieldPositions(8, parseString);
        return caretPosition >= pos[0] && caretPosition <= pos[1];
    }

    public int[] getFieldPositions(int field, String parseString) {
        parseString = " " + parseString + " ";
        int[] timeZonePos = new int[]{this.getTimeZonePos(parseString), 1000};
        int[] amPmPos = new int[]{this.getAmPmPos(parseString) - 1, -1};
        if (amPmPos[0] >= 0) {
            amPmPos[1] = amPmPos[0] + 2;
        }
        int[] hourPos = new int[]{-1, -1};
        int[] minutePos = new int[]{-1, -1};
        int[] secondPos = new int[]{-1, -1};
        boolean hourPosSet = false;
        boolean minutePosSet = false;
        boolean secondPosSet = false;
        int[] digitList = new int[12];
        int index = 0;
        for (int i = 0; i < parseString.length(); ++i) {
            if (!Character.isDigit(parseString.charAt(i))) continue;
            digitList[index] = i;
            ++index;
        }
        digitList = this.resizeArray(digitList, index);
        if (timeZonePos[0] > -1) {
            timeZonePos[1] = timeZonePos[0] + 1;
            while (!Character.isWhitespace(parseString.charAt(timeZonePos[1]))) {
                timeZonePos[1] = timeZonePos[1] + 1;
            }
        }
        int j = 0;
        while (j < digitList.length) {
            if (timeZonePos[0] < 0 || digitList[j] < timeZonePos[0] || digitList[j] > timeZonePos[1]) {
                if (!hourPosSet) {
                    hourPos[0] = digitList[j] - 1;
                    if (j + 1 < digitList.length) {
                        if (digitList[j] == digitList[j + 1] - 1) {
                            hourPos[1] = hourPos[0] + 1;
                            j += 2;
                        } else {
                            hourPos[1] = hourPos[0];
                            ++j;
                        }
                    } else {
                        hourPos[1] = hourPos[0];
                        ++j;
                    }
                    hourPosSet = true;
                    continue;
                }
                if (!minutePosSet) {
                    minutePos[0] = digitList[j] - 1;
                    if (j + 1 < digitList.length) {
                        if (digitList[j] == digitList[j + 1] - 1) {
                            minutePos[1] = minutePos[0] + 1;
                            j += 2;
                        } else {
                            minutePos[1] = minutePos[0];
                            ++j;
                        }
                    } else {
                        minutePos[1] = minutePos[0];
                        ++j;
                    }
                    minutePosSet = true;
                    continue;
                }
                if (secondPosSet) continue;
                secondPos[0] = digitList[j] - 1;
                if (j + 1 < digitList.length) {
                    if (digitList[j] == digitList[j + 1] - 1) {
                        secondPos[1] = secondPos[0] + 1;
                        j += 2;
                    } else {
                        secondPos[1] = secondPos[0];
                        ++j;
                    }
                } else {
                    secondPos[1] = secondPos[0];
                    ++j;
                }
                secondPosSet = true;
                continue;
            }
            ++j;
        }
        timeZonePos[0] = timeZonePos[0] - 1;
        timeZonePos[1] = timeZonePos[1] - 1;
        switch (field) {
            case 3: {
                return hourPos;
            }
            case 4: {
                return minutePos;
            }
            case 5: {
                return secondPos;
            }
            case 7: {
                return amPmPos;
            }
            case 8: {
                return timeZonePos;
            }
        }
        return null;
    }

    private String strip(String s) {
        int i;
        this.amPmFlag = false;
        this.timeZoneFlag = false;
        String strippedString = "";
        String timeZoneString = "";
        String amPmString = "";
        s = " " + s + " ";
        if (this.getAmPmPos(s) > -1) {
            i = this.getAmPmPos(s) + 1;
            while (!Character.isWhitespace(s.charAt(i))) {
                amPmString = amPmString + s.charAt(i);
                ++i;
            }
            s = i < s.length() ? s.substring(0, this.getAmPmPos(s)) + s.substring(i) : s.substring(0, this.getAmPmPos(s));
            this.amPmFlag = true;
            amPmString = amPmString + " ";
        }
        if (this.getTimeZonePos(s) > -1) {
            i = this.getTimeZonePos(s) + 1;
            while (!Character.isWhitespace(s.charAt(i))) {
                timeZoneString = timeZoneString + s.charAt(i);
                ++i;
            }
            s = i < s.length() ? s.substring(0, this.getTimeZonePos(s)) + s.substring(i) : s.substring(0, this.getTimeZonePos(s));
            this.timeZoneFlag = true;
            timeZoneString = timeZoneString + " ";
        }
        for (i = 0; i < s.length() && !Character.isDigit(s.charAt(i)); ++i) {
        }
        if ((i = (s = s.substring(i)).length() - 1) > -1) {
            while (i > 0 && !Character.isDigit(s.charAt(i))) {
                --i;
            }
            s = s.substring(0, i + 1);
        }
        for (int j = 0; j < s.length(); ++j) {
            if (Character.isDigit(s.charAt(j))) {
                strippedString = strippedString + s.charAt(j);
                continue;
            }
            if (!Character.isDigit(s.charAt(j - 1))) continue;
            strippedString = strippedString + ':';
        }
        return amPmString + timeZoneString + strippedString;
    }

    private int getAmPmPos(String parseString) {
        parseString = parseString.toUpperCase();
        int position = 0;
        position = parseString.indexOf(" " + this.formatSymbols.getAmPmStrings()[0].toUpperCase() + " ");
        if (position > -1) {
            return position;
        }
        return parseString.indexOf(" " + this.formatSymbols.getAmPmStrings()[1].toUpperCase() + " ");
    }

    private int getTimeZonePos(String parseString) {
        parseString = parseString.toUpperCase();
        int position = -1;
        String[][] timeZoneList = this.formatSymbols.getZoneStrings();
        block0: for (int i = 0; i < timeZoneList.length; ++i) {
            for (int j = 0; j < timeZoneList[i].length; ++j) {
                if (parseString.indexOf(" " + timeZoneList[i][j].toUpperCase()) <= -1) continue;
                position = parseString.indexOf(" " + timeZoneList[i][j].toUpperCase());
                continue block0;
            }
        }
        return position;
    }

    private int[] resizeArray(int[] inArray, int newSize) {
        int[] outArray = new int[newSize];
        for (int i = 0; i < newSize; ++i) {
            outArray[i] = inArray[i];
        }
        return outArray;
    }
}

