/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.awt.Component;
import java.awt.Container;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ComponentToolkit {
    private ComponentToolkit() {
    }

    public static void makeSearchable(JComboBox aBox) {
        aBox.setKeySelectionManager(new ComboBoxKeySelectionManager(aBox));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getFocusOwner(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component comp = ComponentToolkit.getFocusOwnerImpl(container);
            Log.trace("getFocusOwner: " + comp);
            return comp;
        }
    }

    private static Component getFocusOwnerImpl(Container container) {
        Component focus = null;
        if (container.hasFocus()) {
            focus = container;
        } else {
            Component[] comps = container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (comp.hasFocus()) {
                    focus = comp;
                    break;
                }
                if (comp instanceof Container && (focus = ComponentToolkit.getFocusOwner((Container)comp)) != null) break;
            }
        }
        return focus;
    }

    public static void setEnabled(boolean enabled, Component component) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            ComponentToolkit.setEnabled(enabled, ((Container)component).getComponents());
        }
        if (component instanceof JMenu) {
            ComponentToolkit.setEnabled(enabled, ((JMenu)component).getMenuComponents());
        }
    }

    private static void setEnabled(boolean enabled, Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            ComponentToolkit.setEnabled(enabled, components[i]);
        }
    }

    public static void updateLookAndFeel(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        if (component instanceof Container) {
            ComponentToolkit.updateLookAndFeel(((Container)component).getComponents());
        }
        if (component instanceof JMenu) {
            ComponentToolkit.updateLookAndFeel(((JMenu)component).getMenuComponents());
        }
    }

    private static void updateLookAndFeel(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            ComponentToolkit.updateLookAndFeel(components[i]);
        }
    }

    public static String getDateFormat(Date date, Locale locale) {
        DateFormat dateFormatter = DateFormat.getDateInstance(1, locale);
        return dateFormatter.format(date);
    }

    public static String getTimeFormat(Date date, Locale locale) {
        DateFormat timeFormatter = DateFormat.getTimeInstance(2, locale);
        return timeFormatter.format(date);
    }

    public static String getDateTimeFormat(Date date, Locale locale) {
        DateFormat timeDateFormatter = DateFormat.getDateTimeInstance(1, 2, locale);
        return timeDateFormatter.format(date);
    }

    private static class ComboBoxKeySelectionManager
    implements JComboBox.KeySelectionManager {
        private String searchKey = "";
        private long lastPressed = new Date().getTime();
        private JComboBox aBox;

        protected ComboBoxKeySelectionManager(JComboBox aBox) {
            this.aBox = aBox;
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            this.aBox.showPopup();
            long thisPressed = new Date().getTime();
            if (this.isValidKey(aKey)) {
                this.searchKey = thisPressed - this.lastPressed > 1000L ? new Character(Character.toLowerCase(aKey)).toString() : this.searchKey + Character.toLowerCase(aKey);
            }
            this.lastPressed = thisPressed;
            for (int i = 0; i < aModel.getSize(); ++i) {
                Object item = aModel.getElementAt(i);
                if (!item.toString().toLowerCase().startsWith(this.searchKey)) continue;
                return i;
            }
            return -1;
        }

        private boolean isValidKey(char aKey) {
            return !Character.isISOControl(aKey) && Character.getType(aKey) != 0;
        }
    }
}

