/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateHelper {
    private static final int MS_IN_SECOND = 1000;
    private static final int MS_IN_MINUTE = 60000;
    private static final int MS_IN_HOUR = 3600000;
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static final String TIME_FORMAT_STRING = "hh:mm:ss";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("hh:mm:ss");

    public static String formatDate(Date inDate) {
        String result = DateHelper.formatCalendarDate(inDate);
        result = result + " " + DateHelper.formatTime(inDate);
        return result;
    }

    public static String formatCalendarDate(Date inDate) {
        return DATE_FORMAT.format(inDate);
    }

    public static String formatTime(Date inTime) {
        String result = TIME_FORMAT.format(inTime);
        int timezone = DateHelper.getTimeZone(inTime);
        String tzSign = timezone < 0 ? "-" : "+";
        timezone = Math.abs(timezone);
        int tzHours = timezone / 60;
        int tzMinutes = timezone % 60;
        result = result + tzSign + (tzHours < 10 ? "0" : "") + tzHours + ":" + (tzMinutes < 10 ? "0" : "") + tzMinutes;
        return result;
    }

    public static Date parseDate(String inDateStr) throws ParseException {
        Date date = null;
        try {
            date = DATE_FORMAT.parse(inDateStr);
        }
        catch (ParseException e) {
            date = DateFormat.getDateInstance().parse(inDateStr);
        }
        return date;
    }

    public static Date getDatePart(Date inFullDate) {
        Date originalDate = new Date(inFullDate.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(originalDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getTimeZone(Date inDate) {
        int timeZoneOffset = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inDate);
        int milliseconds = calendar.get(11) * 3600000 + calendar.get(12) * 60000 + calendar.get(13) * 1000 + calendar.get(14);
        timeZoneOffset = TimeZone.getDefault().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), milliseconds);
        return timeZoneOffset / 60000;
    }
}

