/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LanguageManager;
import se.ericsson.security.bootstrap.BootstrapCommunicatable;

public abstract class AbstractApplet
implements BootstrapCommunicatable {
    protected ApplicationManager applicationManager;
    protected static JApplet applet;
    public static final String SYSTPROP_FILE_KEY = "gsl.systemproperties.file";

    public AbstractApplet() {
        Log.logNotify("AbstractApplet()");
    }

    public abstract String getApplicationClassName();

    public final void customInit(JApplet bootstrapApplet) {
        Log.logNotify("customInit() : saving the applet-reference");
        applet = bootstrapApplet;
        this.loadSystProp();
    }

    public final void customStart() {
        Log.logNotify("customStart() : instantiating the ApplicationManager");
        try {
            this.applicationManager = new ApplicationManager(this.getApplicationClassName(), null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.logNotify("customStart() : starting the initial application : " + this.getApplicationClassName());
        this.applicationManager.startInitialApplication(AbstractApplet.getApplet(), true);
    }

    public final void customStop() {
        Log.logNotify("customStop() : stopping the ApplicationManager hard");
        this.applicationManager.stopApplicationManagerHard();
        this.applicationManager = null;
    }

    public final void customDestroy() {
        Log.logNotify("customDestroy() : freeing all resources");
        applet = null;
    }

    public String toString() {
        return new StringBuffer(this.getClass().toString()).append("@").append(Integer.toHexString(this.hashCode())).toString();
    }

    private String getThreadString() {
        return Thread.currentThread().getClass() + "@" + Thread.currentThread().hashCode();
    }

    public static final JApplet getApplet() {
        return applet;
    }

    protected Properties loadSystProp() {
        Properties properties = new Properties();
        String systemPropertiesFileName = System.getProperty(SYSTPROP_FILE_KEY);
        Log.logNotify("systemPropertiesFileName(from System):" + systemPropertiesFileName);
        if (systemPropertiesFileName == null && applet != null) {
            systemPropertiesFileName = applet.getParameter(SYSTPROP_FILE_KEY);
            Log.logNotify("systemPropertiesFileName(from applet):" + systemPropertiesFileName);
        }
        if (systemPropertiesFileName == null || systemPropertiesFileName.equals("")) {
            Log.logNotify("No setting for a sysprop file, not loading any.");
        } else {
            try {
                ResourceBundle bundle = GuilibResourceBundle.getBundle(systemPropertiesFileName, LanguageManager.EMPTY_LOCALE, this.getClass().getClassLoader());
                Enumeration<String> enume = bundle.getKeys();
                while (enume.hasMoreElements()) {
                    String key = enume.nextElement();
                    properties.put(key, bundle.getObject(key));
                }
            }
            catch (Throwable t) {
                String msg = "Could not create ResourceBundle: " + systemPropertiesFileName;
                Log.logNotify(msg);
                Log.assertion(false, msg);
            }
            Log.logNotify("file with systemproperties loaded : " + systemPropertiesFileName);
            EmasSystemProperties.setInitialProperties(properties);
        }
        Log.logNotify("All systemdefault systemproperties : " + System.getProperties());
        return properties;
    }
}

