/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractComponentController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractComponentView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.ComponentPresenter;
import se.ericsson.cello.support.gui.guilib.infra.Resources;

public abstract class AbstractComponent
extends JPanel
implements Resources {
    private Properties environment;
    private AbstractPresenter presenter;
    private boolean initiated = false;

    public AbstractComponent() {
        this.setLayout(new BorderLayout());
    }

    public abstract Class getComponentViewClass();

    public abstract Class getComponentControllerClass();

    public abstract String getLanguageBundleName();

    public abstract String getEnvironmentBundleName();

    public abstract String getToolTipBundleName();

    public String getHelpBundleName() {
        return null;
    }

    protected AbstractComponentController getController() {
        return (AbstractComponentController)this.presenter.getController();
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    public ResourceBundle getLanguageBundle() {
        return this.presenter.getLanguageManager().getLanguageBundle();
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    public ResourceBundle getToolTipBundle() {
        return this.presenter.getLanguageManager().getToolTipBundle();
    }

    protected AbstractComponentView getView() {
        return (AbstractComponentView)this.presenter.getView();
    }

    void init() {
        Container parent = this.getParent();
        while (!(parent instanceof AbstractView)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            Log.assertion(false, "AbstractComponent has no parent");
        }
        AbstractView parentView = (AbstractView)parent;
        AbstractApplication application = parentView.getPresenter().getApplication();
        this.environment = new Properties(application.getEnvironment());
        String bundleName = this.getEnvironmentBundleName();
        if (bundleName != null && !bundleName.equals("")) {
            ApplicationManager.loadBundle(bundleName, application.getLocale(), this.environment);
        }
        this.presenter = AbstractPresenter.createPresenter(parentView.getPresenter(), parentView.getPresenter().getApplication(), ComponentPresenter.class, this.getComponentViewClass(), this.getComponentControllerClass(), this);
    }

    void setPresenter(AbstractPresenter presenter) {
        this.presenter = presenter;
    }

    void updateLocale(Locale locale) {
        this.presenter.updateLocale(locale);
    }

    public void setEnabled(boolean enabled, boolean iterateChildComps) {
        this.setEnabled(enabled);
        if (iterateChildComps) {
            this.enableChildComponents(this, enabled);
        }
    }

    private void enableChildComponents(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.enableChildComponents(components[i], enabled);
            }
        }
    }
}

