/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;

class ApplicationDefaultView
extends AbstractApplicationView {
    Icon cut_Icon = null;
    Icon copy_Icon = null;
    Icon paste_Icon = null;
    Icon contextHelp_Icon = null;
    CutAbstractAction cutAction = null;
    CopyAbstractAction copyAction = null;
    PasteAbstractAction pasteAction = null;
    JMenu fileMenu;
    JMenuItem closeMenuItem = null;
    JMenuItem exitMenuItem = null;
    JMenu editMenu;
    JMenuItem cutMenuItem = null;
    JMenuItem copyMenuItem = null;
    JMenuItem pasteMenuItem = null;
    JMenu toolsMenu;
    JMenuItem optionsMenuItem;
    JMenu windowMenu;
    JMenuItem cascadeWindowsMenuItem;
    JMenuItem nextWindowsMenuItem;
    JMenuItem previousWindowsMenuItem;
    JMenuItem minimiseAllWindowsMenuItem;
    JMenuItem windowsWindowsMenuItem;
    JMenu helpMenu;
    JMenuItem onWindowHelpMenuItem;
    JMenuItem howToHelpMenuItem;
    JMenuItem contentsHelpMenuItem;
    JMenuItem aboutMenuItem;
    JButton cutButton = null;
    JButton copyButton = null;
    JButton pasteButton = null;

    ApplicationDefaultView() {
    }

    protected void init() {
        this.fileMenu = new JMenu("GSL_FILE");
        if (this.isInitialApplication()) {
            this.exitMenuItem = new JMenuItem("GSL_EXIT");
        } else {
            this.closeMenuItem = new JMenuItem("GSL_CLOSE");
        }
        this.toolsMenu = new JMenu("GSL_TOOLS");
        this.optionsMenuItem = new JMenuItem("GSL_OPTIONS", IconHelper.OPTIONS);
        this.windowMenu = new JMenu("GSL_WINDOW");
        this.cascadeWindowsMenuItem = new JMenuItem("GSL_CASCADE", IconHelper.CASCADE);
        this.nextWindowsMenuItem = new JMenuItem("GSL_NEXT");
        this.previousWindowsMenuItem = new JMenuItem("GSL_PREVIOUS");
        this.minimiseAllWindowsMenuItem = new JMenuItem("GSL_MINIMISE_ALL");
        this.windowsWindowsMenuItem = new JMenuItem("GSL_WINDOWS");
        this.helpMenu = new JMenu("GSL_HELP");
        this.onWindowHelpMenuItem = new JMenuItem("GSL_ON_WINDOW_HELP", IconHelper.WINDOW_DESCRIPTION);
        this.howToHelpMenuItem = new JMenuItem("Using Help", IconHelper.EMPTY);
        this.howToHelpMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.howToHelpMenuItem.setMnemonic('U');
        this.contentsHelpMenuItem = new JMenuItem("System Library", IconHelper.EMPTY);
        this.contentsHelpMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.contentsHelpMenuItem.setMnemonic('L');
        this.aboutMenuItem = new JMenuItem("About " + EmasSystemProperties.getProperty("CUSTOM_APPL_NAME"), IconHelper.EMPTY);
        this.aboutMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.aboutMenuItem.setMnemonic('A');
        this.initEditActions();
    }

    protected void dispose() {
        super.dispose();
    }

    Action[] getEditActions() {
        return new Action[]{this.cutAction, this.copyAction, this.pasteAction};
    }

    void initEditActions() {
        this.cut_Icon = IconHelper.CUT;
        this.cutAction = new CutAbstractAction("GSL_CUT", this.cut_Icon);
        this.copy_Icon = IconHelper.COPY;
        this.copyAction = new CopyAbstractAction("GSL_COPY", this.copy_Icon);
        this.paste_Icon = IconHelper.PASTE;
        this.pasteAction = new PasteAbstractAction("GSL_PASTE", this.paste_Icon);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
    }

    void initEditButtons() {
        JToolBar tempToolBar = new JToolBar();
        this.cutButton = tempToolBar.add(this.cutAction);
        this.cutButton.setText("");
        this.cutButton.setToolTipText("GSL_CUT");
        this.copyButton = tempToolBar.add(this.copyAction);
        this.copyButton.setText("");
        this.copyButton.setToolTipText("GSL_COPY");
        this.pasteButton = tempToolBar.add(this.pasteAction);
        this.pasteButton.setText("");
        this.pasteButton.setToolTipText("GSL_PASTE");
        tempToolBar.removeAll();
    }

    private JMenu createFileMenu() {
        JMenu file = null;
        JMenuItem[] fileItems = this.getApplicationView().getFileMenuItems();
        if (fileItems != null) {
            this.fileMenu.removeAll();
            for (int i = 0; i < fileItems.length; ++i) {
                if (fileItems[i] == null) {
                    this.fileMenu.addSeparator();
                    continue;
                }
                this.fileMenu.add(fileItems[i]);
            }
            if (fileItems.length != 0) {
                this.fileMenu.addSeparator();
            }
            if (this.closeMenuItem != null) {
                this.fileMenu.add(this.closeMenuItem);
            }
            if (this.exitMenuItem != null) {
                this.fileMenu.add(this.exitMenuItem);
            }
            file = this.fileMenu;
            file = this.fileMenu;
        }
        return file;
    }

    private JMenu createToolsMenu() {
        JMenu tools = null;
        JMenuItem[] toolsItems = this.getApplicationView().getToolsMenuItems();
        if (toolsItems != null) {
            this.toolsMenu.removeAll();
            for (int i = 0; i < toolsItems.length; ++i) {
                if (toolsItems[i] == null) {
                    this.toolsMenu.addSeparator();
                    continue;
                }
                this.toolsMenu.add(toolsItems[i]);
            }
            if (this.isInitialApplication()) {
                if (toolsItems.length != 0) {
                    this.toolsMenu.addSeparator();
                }
                this.toolsMenu.add(this.optionsMenuItem);
                tools = this.toolsMenu;
            } else if (toolsItems.length != 0) {
                tools = this.toolsMenu;
            }
        }
        return tools;
    }

    private JMenu createWindowMenu() {
        JMenu window = null;
        JMenuItem[] windowItems = this.getApplicationView().getWindowMenuItems();
        if (windowItems != null) {
            this.windowMenu.removeAll();
            this.windowMenu.add(this.cascadeWindowsMenuItem);
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.nextWindowsMenuItem);
            this.windowMenu.add(this.previousWindowsMenuItem);
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.minimiseAllWindowsMenuItem);
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.windowsWindowsMenuItem);
            this.windowMenu.addSeparator();
            window = this.windowMenu;
        }
        return window;
    }

    private JMenu createHelpMenu() {
        JMenu help = null;
        JMenuItem[] helpItems = this.getApplicationView().getHelpMenuItems();
        if (helpItems != null) {
            this.helpMenu.removeAll();
            String helpClass = this.getProperty("gsl.help.helphandler.class");
            if (helpClass != null && !helpClass.equals("")) {
                this.onWindowHelpMenuItem.putClientProperty("HELP_ENABLE", "");
                this.onWindowHelpMenuItem.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_ONWINDOW");
                this.contentsHelpMenuItem.putClientProperty("HELP_ENABLE", "");
                this.contentsHelpMenuItem.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_TOC");
            } else {
                this.onWindowHelpMenuItem.setEnabled(false);
                this.howToHelpMenuItem.setEnabled(false);
                this.contentsHelpMenuItem.setEnabled(false);
            }
            this.helpMenu.add(this.onWindowHelpMenuItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.contentsHelpMenuItem);
            this.helpMenu.add(this.howToHelpMenuItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.aboutMenuItem);
            help = this.helpMenu;
        }
        return help;
    }

    private JComponent[] createEditToolbar() {
        JComponent[] editComps = this.getApplicationView().getEditToolBarComponents();
        editComps = editComps != null ? new JComponent[]{this.cutButton, this.copyButton, this.pasteButton} : new JComponent[]{};
        return editComps;
    }

    protected JMenu[] getMenus() {
        JMenu[] viewMenus = this.getApplicationView().getMenus();
        JMenu[] menu = new JMenu[3 + viewMenus.length];
        int i = 0;
        menu[i++] = this.createFileMenu();
        for (int j = 0; j < viewMenus.length; ++j) {
            menu[i++] = viewMenus[j];
        }
        menu[i++] = this.createToolsMenu();
        menu[i++] = this.createHelpMenu();
        return menu;
    }

    protected JComponent[] getToolBarComponents() {
        JComponent[] viewToolBarComponents = this.getApplicationView().getToolBarComponents();
        JComponent[] comps = new JComponent[viewToolBarComponents.length];
        int counter = 0;
        for (int j = 0; j < viewToolBarComponents.length; ++j) {
            comps[counter++] = viewToolBarComponents[j];
        }
        return comps;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public JComponent getCutButton() {
        return this.cutButton;
    }

    public JComponent getCopyButton() {
        return this.copyButton;
    }

    public JComponent getPasteButton() {
        return this.pasteButton;
    }

    private AbstractApplicationView getApplicationView() {
        return (AbstractApplicationView)this.getPresenter().getView();
    }

    private boolean isInitialApplication() {
        return this.getPresenter().getApplication().getApplicationManager().isInitialApplication(this.getPresenter().getApplication());
    }

    public static class ToolBarButton
    extends JButton {
        public ToolBarButton(Icon icon) {
            super(icon);
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public class PasteAbstractAction
    extends AbstractAction {
        PasteAbstractAction(String title, Icon icon) {
            super(title, icon);
        }

        public void actionPerformed(ActionEvent e) {
            Component comp = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).paste();
            }
        }
    }

    public class CopyAbstractAction
    extends AbstractAction {
        CopyAbstractAction(String title, Icon icon) {
            super(title, icon);
        }

        public void actionPerformed(ActionEvent e) {
            Component comp = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).copy();
            }
        }
    }

    public class CutAbstractAction
    extends AbstractAction {
        CutAbstractAction(String title, Icon icon) {
            super(title, icon);
        }

        public void actionPerformed(ActionEvent e) {
            Component comp = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).cut();
                ApplicationDefaultView.this.copyAction.setEnabled(false);
                ApplicationDefaultView.this.cutAction.setEnabled(false);
            }
        }
    }
}

