/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationDefaultView;

class ApplicationMenuBar
extends JMenuBar {
    private Vector menuVector = new Vector();
    private ApplicationDefaultView defaultView;

    ApplicationMenuBar(ApplicationDefaultView defaultView) {
        this.defaultView = defaultView;
        JMenu[] menus = defaultView.getMenus();
        for (int i = 0; i < menus.length; ++i) {
            if (menus[i] == null) continue;
            this.menuVector.add(new TopMenu(menus[i], true));
        }
        this.buildMenu();
    }

    void setMenusVisible(JMenu[] menus, boolean visible) {
        block0: for (int i = 0; i < menus.length; ++i) {
            Enumeration enume = this.menuVector.elements();
            while (enume.hasMoreElements()) {
                TopMenu topMenu = (TopMenu)enume.nextElement();
                if (topMenu.getMenu() != menus[i]) continue;
                topMenu.setVisible(visible);
                continue block0;
            }
        }
        this.buildMenu();
    }

    private void buildMenu() {
        this.removeAll();
        Enumeration enume = this.menuVector.elements();
        while (enume.hasMoreElements()) {
            TopMenu topMenu = (TopMenu)enume.nextElement();
            if (!topMenu.isVisible()) continue;
            this.add(topMenu.getMenu());
        }
    }

    JMenu getFileMenu() {
        return this.defaultView.getFileMenu();
    }

    JMenu getEditMenu() {
        return this.defaultView.getEditMenu();
    }

    JMenu getToolsMenu() {
        return this.defaultView.getToolsMenu();
    }

    JMenu getWindowMenu() {
        return this.defaultView.getWindowMenu();
    }

    JMenu getTheHelpMenu() {
        return this.defaultView.getHelpMenu();
    }

    private void closeDisplayedMenu(JMenu menu) {
        JPopupMenu myPopupMenu = menu.getPopupMenu();
        if (myPopupMenu.isVisible()) {
            MenuElement[] myMenuElements = myPopupMenu.getSubElements();
            for (int i = myMenuElements.length; i > 0; --i) {
                if (myMenuElements[i - 1].getComponent() instanceof JMenu) {
                    this.closeDisplayedMenu((JMenu)myMenuElements[i - 1]);
                }
                myMenuElements[i - 1].getComponent().setVisible(false);
            }
            menu.setPopupMenuVisible(false);
        }
    }

    void dispose() {
        Enumeration enume = this.menuVector.elements();
        while (enume.hasMoreElements()) {
            TopMenu topMenu = (TopMenu)enume.nextElement();
            JMenu myMenu = topMenu.getMenu();
            this.closeDisplayedMenu(myMenu);
        }
        this.menuVector.clear();
        this.defaultView = null;
    }

    private static class TopMenu {
        private JMenu menu;
        private boolean visible;

        public TopMenu(JMenu menu, boolean visible) {
            this.menu = menu;
            this.visible = visible;
        }

        public JMenu getMenu() {
            return this.menu;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

