/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.io.PrintWriter;
import java.io.StringWriter;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporterInterface;

public class DefaultErrorReporterImpl
implements ErrorReporterInterface {
    private static final String unresolvedTag = "UNRESOLVED MESSAGE";

    public void reportException(AbstractController controller, Exception e, String msgFromView) {
        String tag = this.getErrorTag(e);
        String txt = this.getErrorDescription(e, controller);
        String trace = this.getErrorTrace(e);
        Object[] param = new String[]{msgFromView, tag, txt};
        String msg = controller.getString("ERROR_REPORTER_MSG", param);
        Log.logNotify("\n- - - -\n" + msg + "\n- - - -\n\n" + trace + "\n");
        String titleKey = "ERROR_REPORTER_TITLE";
        String[] titleArgs = new String[]{tag};
        this.showError(controller, e, "ERROR_REPORTER_MSG", (String[])param, titleKey, titleArgs);
    }

    public void reportException(AbstractController controller, Exception e, String msgKey, Object[] msgArgs) {
        String tag = this.getErrorTag(e);
        String txt = this.getErrorDescription(e, controller);
        String trace = this.getErrorTrace(e);
        Object[] param = new String[]{controller.getString(msgKey, msgArgs), tag, txt};
        String msg = controller.getString("ERROR_REPORTER_MSG", param);
        Log.logNotify("\n- - - -\n" + msg + "\n- - - -\n\n" + trace + "\n");
        String titleKey = "ERROR_REPORTER_TITLE";
        String[] titleArgs = new String[]{tag};
        this.showError(controller, e, "ERROR_REPORTER_MSG", (String[])param, titleKey, titleArgs);
    }

    protected String getErrorTag(Exception e) {
        String fullName = e.getClass().getName();
        String shortName = fullName.substring(fullName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getErrorDescription(Exception e, AbstractController controller) {
        String fullName = e.getClass().getName();
        return fullName;
    }

    protected String getErrorTrace(Exception e) {
        return e.toString();
    }

    protected void showError(AbstractController controller, Exception e, String msgKey, String[] msgArgs, String titleKey, String[] titleArgs) {
        String cl;
        AbstractView parent;
        String msg = controller.getString(msgKey, msgArgs);
        String title = controller.getString(titleKey, titleArgs);
        String trace = "";
        if (null != e) {
            if (e.toString().indexOf("stack trace = ") != -1) {
                trace = e.toString();
            } else {
                StringWriter eStr = new StringWriter();
                e.printStackTrace(new PrintWriter(eStr));
                trace = eStr.toString();
            }
        }
        if (null == (parent = controller.getView()) || !parent.isShowing()) {
            parent = EmasGuilibMediator.getReference().getMainWindowReference().getView();
        }
        cl = -1 == (cl = controller.getString("CLOSE", null)).indexOf(unresolvedTag) ? cl : null;
        String m = controller.getString("MORE", null);
        m = -1 == m.indexOf(unresolvedTag) ? m : null;
        String le = controller.getString("LESS", null);
        le = -1 == le.indexOf(unresolvedTag) ? le : null;
        ErrorDialog errDia = ErrorDialog.create(parent, msg, trace, cl, m, le, title);
        errDia.show();
    }
}

