/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.util.Enumeration;
import java.util.Properties;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.TraceHelper;

public class GuilibConfigParams {
    static final String HELP_SET_NAME_KEY = "gsl.help.helpset.name";
    private static GuilibConfigParams guilibConfigParams = null;
    private static ApplicationManager applicationManager = null;
    private Properties configProperties = null;

    private GuilibConfigParams() {
    }

    public static GuilibConfigParams getInstance() {
        if (guilibConfigParams == null) {
            guilibConfigParams = new GuilibConfigParams();
        }
        return guilibConfigParams;
    }

    void init(Properties configProperties, ApplicationManager appManager) {
        this.configProperties = configProperties;
        applicationManager = appManager;
    }

    public void setHelpSetName(String hsName) {
        this.appendConfigProperties(HELP_SET_NAME_KEY, hsName);
        if (applicationManager != null) {
            Enumeration enume = applicationManager.getAllApplications();
            while (enume.hasMoreElements()) {
                AbstractApplication app = (AbstractApplication)enume.nextElement();
                Log.logNotify("GuilibCongParam: setHelpSet for: " + app);
                app.getApplicationPresenter().getHelp().updateHelp(app.getLocale());
            }
        }
    }

    public void setLogLevel(int logLevel) {
        Log.setLogLevel(logLevel);
    }

    public void setApplicationTraceLevel(int traceLevel) {
        TraceHelper.setTraceType(traceLevel);
    }

    public void setSystemLibraryName(String slName) {
        this.appendConfigProperties("gsl.systemlibrary", slName);
    }

    public void appendConfigProperties(String key, String value) {
        if (this.configProperties != null) {
            this.configProperties.setProperty(key, value);
        }
    }

    public void dispose() {
        this.configProperties.clear();
        applicationManager = null;
        guilibConfigParams = null;
    }
}

