/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import sun.misc.SoftCache;

public abstract class GuilibResourceBundle {
    private static final ResourceCacheKey cachedKey = new ResourceCacheKey();
    private static final int INIT_CACHE_SIZE = 25;
    private static final float CACHE_FACTOR = 1.0f;
    private static final int MAX_BUNDLE_SEARCHED = 3;
    private static final Hashtable inConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEF_NOT_FOUND = new Integer(-1);
    private static SoftCache cachedList = new SoftCache(25, 1.0f);
    protected ResourceBundle parents = null;
    private Locale locales = null;

    private void setLocale(String base, String bundle) {
        if (base.length() == bundle.length()) {
            this.locales = new Locale("", "");
        } else if (base.length() < bundle.length()) {
            int position = base.length();
            String temp = bundle.substring(position + 1);
            if ((position = temp.indexOf(95)) == -1) {
                this.locales = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, position);
            if ((position = (temp = temp.substring(position + 1)).indexOf(95)) == -1) {
                this.locales = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, position);
            temp = temp.substring(position + 1);
            this.locales = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void setParent(ResourceBundle parents) {
        this.parents = parents;
    }

    public static ResourceBundle getBundle(String baseName, ClassLoader cloader) throws MissingResourceException {
        if (cloader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(baseName, Locale.getDefault(), cloader);
    }

    public static ResourceBundle getBundle(String base, Locale locale, ClassLoader cloader) throws MissingResourceException {
        if (cloader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(base, locale, cloader);
    }

    private static ResourceBundle getBundleImpl(String base, Locale locales, ClassLoader cloader) {
        if (base == null) {
            throw new NullPointerException();
        }
        Object NOTFOUND = cloader != null ? cloader : DEF_NOT_FOUND;
        String bundleName = base;
        String localeSuf = locales.toString();
        if (localeSuf.length() > 0) {
            bundleName = bundleName + "_" + localeSuf;
        } else if (locales.getVariant().length() > 0) {
            bundleName = bundleName + "___" + locales.getVariant();
        }
        Object find = GuilibResourceBundle.findBundleInCache(cloader, bundleName);
        if (find == NOTFOUND) {
            GuilibResourceBundle.throwMissingResourceException(base, locales);
        } else if (find != null) {
            return (ResourceBundle)find;
        }
        Object parents = NOTFOUND;
        try {
            boolean foundInMain;
            Object roots = GuilibResourceBundle.findBundle(cloader, base, base, null, NOTFOUND);
            if (roots == null) {
                GuilibResourceBundle.putBundleInCache(cloader, base, NOTFOUND);
                roots = NOTFOUND;
            }
            Vector name = GuilibResourceBundle.calculateBundleNames(base, locales);
            boolean bl = foundInMain = roots != NOTFOUND && name.size() == 0;
            if (!foundInMain) {
                parents = roots;
                for (int j = name.size(); j > 0; --j) {
                    bundleName = (String)name.elementAt(j - 1);
                    find = GuilibResourceBundle.findBundle(cloader, bundleName, base, parents, NOTFOUND);
                    if (find == null) continue;
                    parents = find;
                    foundInMain = true;
                    break;
                }
            }
            parents = roots;
            if (!foundInMain) {
                Vector fallbackNames = GuilibResourceBundle.calculateBundleNames(base, Locale.getDefault());
                for (int j = 0; j < fallbackNames.size() && !name.contains(bundleName = (String)fallbackNames.elementAt(j)); ++j) {
                    find = GuilibResourceBundle.findBundle(cloader, bundleName, base, parents, NOTFOUND);
                    if (find != null) {
                        parents = find;
                        continue;
                    }
                    GuilibResourceBundle.putBundleInCache(cloader, bundleName, parents);
                }
            }
            parents = GuilibResourceBundle.propagate(cloader, name, parents);
        }
        catch (Exception ex) {
            GuilibResourceBundle.cleanUpConstructionList();
            GuilibResourceBundle.throwMissingResourceException(base, locales);
        }
        catch (Error err) {
            GuilibResourceBundle.cleanUpConstructionList();
            throw err;
        }
        if (parents == NOTFOUND) {
            GuilibResourceBundle.throwMissingResourceException(base, locales);
        }
        Log.logNotify(bundleName + " has been loaded");
        return (ResourceBundle)parents;
    }

    private static Object propagate(ClassLoader cloader, Vector name, Object parents) {
        for (int j = 0; j < name.size(); ++j) {
            String bundleName = (String)name.elementAt(j);
            Object search = GuilibResourceBundle.findBundleInCache(cloader, bundleName);
            if (search == null) {
                GuilibResourceBundle.putBundleInCache(cloader, bundleName, parents);
                continue;
            }
            parents = search;
        }
        return parents;
    }

    private static void throwMissingResourceException(String base, Locale locales) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + base + ", locale " + locales, base + "_" + locales, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            Collection entries = inConstruction.values();
            Thread theThread = Thread.currentThread();
            while (entries.remove(theThread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader cloader, String bundle, String base, Object parents, Object NOTFOUND) {
        Object results;
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            boolean isBuilding;
            cachedKey.setKeyValues(cloader, bundle);
            results = cachedList.get((Object)cachedKey);
            if (results != null) {
                cachedKey.clear();
                return results;
            }
            Thread builders = (Thread)inConstruction.get(cachedKey);
            boolean bl = isBuilding = builders != null && builders != Thread.currentThread();
            if (isBuilding) {
                while (isBuilding) {
                    cachedKey.clear();
                    try {
                        cachedList.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    cachedKey.setKeyValues(cloader, bundle);
                    isBuilding = inConstruction.containsKey(cachedKey);
                }
                results = cachedList.get((Object)cachedKey);
                if (results != null) {
                    cachedKey.clear();
                    return results;
                }
            }
            Object key = cachedKey.clone();
            inConstruction.put(key, Thread.currentThread());
            cachedKey.clear();
        }
        results = GuilibResourceBundle.loadBundle(cloader, bundle);
        if (results != null) {
            boolean isConstructing;
            SoftCache softCache2 = cachedList;
            synchronized (softCache2) {
                cachedKey.setKeyValues(cloader, bundle);
                isConstructing = inConstruction.get(cachedKey) == Thread.currentThread();
                cachedKey.clear();
            }
            if (isConstructing) {
                GuilibResourceBundle.putBundleInCache(cloader, bundle, results);
            }
        }
        return results;
    }

    private static Vector calculateBundleNames(String base, Locale locales) {
        String variant;
        int vLength;
        String country;
        int cLength;
        Vector<String> results = new Vector<String>(3);
        String lang = locales.getLanguage();
        int languageLength = lang.length();
        if (languageLength + (cLength = (country = locales.getCountry()).length()) + (vLength = (variant = locales.getVariant()).length()) == 0) {
            return results;
        }
        StringBuffer tmp = new StringBuffer(base);
        tmp.append('_');
        tmp.append(lang);
        results.addElement(tmp.toString());
        if (cLength + vLength == 0) {
            return results;
        }
        tmp.append('_');
        tmp.append(country);
        results.addElement(tmp.toString());
        if (vLength == 0) {
            return results;
        }
        tmp.append('_');
        tmp.append(variant);
        results.addElement(tmp.toString());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader cloader, String bundle) {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            cachedKey.setKeyValues(cloader, bundle);
            Object results = cachedList.get((Object)cachedKey);
            cachedKey.clear();
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader cloader, String bundle, Object val) {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            cachedKey.setKeyValues(cloader, bundle);
            cachedList.put(cachedKey.clone(), val);
            inConstruction.remove(cachedKey);
            cachedKey.clear();
            cachedList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadBundle(final ClassLoader cloader, String bundle) {
        final String name = bundle.replace('.', '/') + ".properties";
        InputStream input = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (cloader != null) {
                    return cloader.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
        if (input != null) {
            input = new BufferedInputStream(input);
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(input);
                return propertyResourceBundle;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception ex) {}
            }
        }
        try {
            Class<?> cbundle = cloader != null ? cloader.loadClass(bundle) : Class.forName(bundle);
            if (ResourceBundle.class.isAssignableFrom(cbundle)) {
                Object myBundles = cbundle.newInstance();
                Object otherBundles = GuilibResourceBundle.findBundleInCache(cloader, bundle);
                if (otherBundles != null) {
                    return otherBundles;
                }
                return myBundles;
            }
        }
        catch (Exception ex) {
        }
        catch (LinkageError err) {
            // empty catch block
        }
        return null;
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderReference;
        private String searchNames;
        private int hashCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                boolean hasLoaderRef;
                ResourceCacheKey otherEntry = (ResourceCacheKey)obj;
                if (this.hashCache != otherEntry.hashCache) {
                    return false;
                }
                if (!this.searchNames.equals(otherEntry.searchNames)) {
                    return false;
                }
                boolean bl = hasLoaderRef = this.loaderReference != null;
                if (this.loaderReference == null) {
                    return otherEntry.loaderReference == null;
                }
                return otherEntry.loaderReference != null && this.loaderReference.get() == otherEntry.loaderReference.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader cloader, String searchNames) {
            this.searchNames = searchNames;
            this.hashCache = searchNames.hashCode();
            if (cloader == null) {
                this.loaderReference = null;
            } else {
                this.loaderReference = new SoftReference<ClassLoader>(cloader);
                this.hashCache ^= cloader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "");
        }
    }
}

