/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class SDIViewContainer
extends JFrame
implements ViewContainer {
    private AbstractPresenter presenter;
    private JPanel viewPanel;
    private JPanel statusBar;
    private static boolean FIRST_WINDOW = true;
    private JLabel statusLabel;
    private JLabel iconLabel;
    private WinAdapter winAdapter;
    private ApplicationMenuBar applicationMenuBar = null;
    private ApplicationToolBar applicationToolBar = null;
    private ImageIcon ericsson_icon = new ImageIcon();
    private JLabel myUtcClock;

    public void init(AbstractPresenter presenter) {
        this.presenter = presenter;
        super.setIconImage(((ImageIcon)IconHelper.UTRAN_ICON).getImage());
        this.ericsson_icon = (ImageIcon)IconHelper.createIcon("se/ericsson/cello/support/gui/guilib/infra/resources/images/toolbaricons/approved_black_logo_grey_background.gif");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)contentPanel, "Center");
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BoxLayout(this.viewPanel, 1));
        contentPanel.add((Component)this.viewPanel, "Center");
        this.createStatusBar();
        contentPanel.add((Component)this.statusBar, "South");
        this.setDefaultCloseOperation(0);
        this.winAdapter = new WinAdapter();
        this.addWindowListener(this.winAdapter);
    }

    public void dispose() {
        this.presenter = null;
        this.removeComponents(this);
        this.viewPanel = null;
        this.statusBar = null;
        this.statusLabel = null;
        Object iconLabel = null;
        this.myUtcClock = null;
        this.setJMenuBar(null);
        this.applicationMenuBar = null;
        this.applicationToolBar = null;
        this.ericsson_icon = null;
        this.removeWindowListener(this.winAdapter);
        this.winAdapter = null;
        super.dispose();
    }

    private void removeComponents(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (component instanceof JMenu) {
                this.removeComponents(container, ((JMenu)component).getMenuComponents());
            }
            this.removeComponents(container, container.getComponents());
        }
    }

    private void removeComponents(Container container, Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            container.remove(component);
            this.removeComponents(component);
        }
    }

    private void createStatusBar() {
        this.statusLabel = new JLabel("");
        this.iconLabel = new JLabel(this.ericsson_icon);
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(new BevelBorder(1), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        this.statusBar.add((Component)this.statusLabel, "Center");
        JPanel clockPanel = new JPanel(new BorderLayout());
        this.myUtcClock = new JLabel();
        if (FIRST_WINDOW) {
            this.iconLabel = new JLabel(this.ericsson_icon);
            clockPanel.add((Component)this.iconLabel, "East");
            clockPanel.add((Component)new JLabel(" Node UTC time "), "West");
            clockPanel.add((Component)this.myUtcClock, "Center");
            this.statusBar.add((Component)clockPanel, "East");
            FIRST_WINDOW = false;
        }
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        if (applicationMenuBar != null) {
            this.setJMenuBar(applicationMenuBar);
        }
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
        if (this.applicationToolBar != null) {
            this.getContentPane().remove(this.applicationToolBar);
        }
        if (applicationToolBar != null) {
            this.getContentPane().add((Component)applicationToolBar, "North");
        }
        this.applicationToolBar = applicationToolBar;
    }

    public void setView(AbstractView view) {
        this.viewPanel.removeAll();
        this.viewPanel.add(view);
        this.setResizable(view.isResizable());
    }

    public void setViewResizable(boolean resizable) {
        this.setResizable(resizable);
    }

    public Window getWindow() {
        return this;
    }

    public Component getComponent() {
        return this;
    }

    public void setStatus(String status) {
        if (status == null || status.equals("")) {
            status = " ";
        }
        if (status.startsWith("CLOCK")) {
            this.myUtcClock.setText(status.substring(5));
        } else {
            this.statusLabel.setText(status);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            this.centerOnScreen();
        }
        super.setVisible(visible);
    }

    public void setEnabled(boolean enabled) {
        if (this.presenter.isDefaultEnabling()) {
            super.setEnabled(enabled);
        }
    }

    public void bringToFront() {
        if (this.getState() == 1) {
            this.setState(0);
            Dimension size = this.getSize();
            this.setSize(size.width + 1, size.height + 1);
            this.setSize(size);
        }
        this.toFront();
        this.requestFocus();
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setMaximized() {
        this.setState(0);
    }

    public void setMinimized() {
        this.setState(1);
    }

    public void setRestored() {
        this.setState(0);
    }

    public void doValidate() {
        this.validate();
        this.repaint();
    }

    private void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
    }

    public void setHorizontalScrollBarPolicy(int policy) {
    }

    public void setVerticalScrollBarPolicy(int policy) {
    }

    private class WinAdapter
    extends WindowAdapter {
        private WinAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            if (SDIViewContainer.this.presenter.isEnabled()) {
                SDIViewContainer.this.presenter.getController().viewClosing();
            }
        }

        public void windowOpened(WindowEvent e) {
            super.windowOpened(e);
            BringToFrontThread thread = new BringToFrontThread();
            thread.start();
        }
    }

    private class BringToFrontThread
    extends Thread {
        private BringToFrontThread() {
        }

        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Runnable run = new Runnable(){

                public void run() {
                    SDIViewContainer.this.bringToFront();
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }
}

