/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;

public class TimedSocket {
    private static final int POLL_DELAY = 100;

    public static Socket getSocket(InetAddress inAddr, int portNumber, int delay) throws InterruptedIOException, IOException {
        Socket sockInstantiation;
        SocketThread sthread;
        block4: {
            sthread = new SocketThread(inAddr, portNumber);
            sthread.start();
            int timerCount = 0;
            sockInstantiation = null;
            do {
                if (sthread.isConnected()) break block4;
                if (sthread.isError()) {
                    throw sthread.getException();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while ((timerCount += 100) <= delay);
            throw new InterruptedIOException("Could not connect for " + delay + " milliseconds");
        }
        sockInstantiation = sthread.getSocket();
        return sockInstantiation;
    }

    public static Socket getSocket(String hostName, int ports, int delayTime) throws InterruptedIOException, IOException {
        InetAddress inetAddr = InetAddress.getByName(hostName);
        return TimedSocket.getSocket(inetAddr, ports, delayTime);
    }

    static class SocketThread
    extends Thread {
        private volatile Socket new_connection = null;
        private String new_host = null;
        private InetAddress new_inet = null;
        private int new_port = 0;
        private IOException new_exception = null;

        public SocketThread(String host, int port) {
            this.new_host = host;
            this.new_port = port;
        }

        public SocketThread(InetAddress inetAddr, int port) {
            this.new_inet = inetAddr;
            this.new_port = port;
        }

        public void run() {
            Socket sock = null;
            try {
                sock = this.new_host != null ? new Socket(this.new_host, this.new_port) : new Socket(this.new_inet, this.new_port);
            }
            catch (IOException ioe) {
                this.new_exception = ioe;
                return;
            }
            this.new_connection = sock;
        }

        public boolean isConnected() {
            return this.new_connection != null;
        }

        public boolean isError() {
            return this.new_exception != null;
        }

        public Socket getSocket() {
            return this.new_connection;
        }

        public IOException getException() {
            return this.new_exception;
        }
    }
}

