/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup
extends JTableHeader {
    private TableCellRenderer render;
    private Vector columnVector;
    private int margin = 0;
    private String key;
    private String title = "";

    public ColumnGroup(String key) {
        this(null, key);
    }

    public ColumnGroup(TableCellRenderer render, String key) {
        this.render = render == null ? new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object val, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader head = table.getTableHeader();
                if (head != null) {
                    this.setForeground(head.getForeground());
                    this.setBackground(head.getBackground());
                    this.setFont(head.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(val == null ? "" : val.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : render;
        this.key = key;
        this.columnVector = new Vector();
    }

    public void add(Object object) {
        if (object == null) {
            return;
        }
        this.columnVector.addElement(object);
    }

    Vector getColumnGroups(TableColumn c, Vector v) {
        v.addElement(this);
        if (this.columnVector.contains(c)) {
            return v;
        }
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Vector group;
            Object object = enume.nextElement();
            if (!(object instanceof ColumnGroup) || (group = ((ColumnGroup)object).getColumnGroups(c, (Vector)v.clone())) == null) continue;
            return group;
        }
        return null;
    }

    public TableCellRenderer getHeaderRender() {
        return this.render;
    }

    public void setHeaderRenderer(TableCellRenderer render) {
        if (render != null) {
            this.render = render;
        }
    }

    public Object getHeaderVal() {
        return this.title;
    }

    public String getHeaderKey() {
        return this.key;
    }

    public void setHeaderValue(String title) {
        this.title = title;
    }

    Dimension getSize(JTable table) {
        Component comp = this.render.getTableCellRendererComponent(table, this.getHeaderVal(), false, false, -1, -1);
        int h = comp.getPreferredSize().height;
        int w = 0;
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Object object = enume.nextElement();
            if (object instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)object;
                w += aColumn.getWidth();
                w += this.margin;
                continue;
            }
            w += ((ColumnGroup)object).getSize((JTable)table).width;
        }
        return new Dimension(w, h);
    }

    void setColumnMargin(int m) {
        this.margin = m;
        Enumeration enume = this.columnVector.elements();
        while (enume.hasMoreElements()) {
            Object object = enume.nextElement();
            if (!(object instanceof ColumnGroup)) continue;
            ((ColumnGroup)object).setColumnMargin(m);
        }
    }
}

