/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Level;

public class LogRecord
implements Serializable {
    private static long globalSequenceNumb;
    private static int nextThreadIndex;
    private static ThreadLocal localthreadIds;
    private Level levels;
    private long sequenceNumberId;
    private String sourceClassNamed;
    private String sourceMethodNamed;
    private String messages;
    private transient Object[] parameter;
    private int threadId;
    private long millisecond;
    private Throwable throwns;
    private String loggerNamed;
    private String resourceBundleNamed;
    private transient ResourceBundle resourceBundler;
    private String backTraces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level levels, String msg) {
        levels.getClass();
        this.levels = levels;
        this.messages = msg;
        Class<LogRecord> clazz = LogRecord.class;
        synchronized (LogRecord.class) {
            this.sequenceNumberId = globalSequenceNumb++;
            Integer iD = (Integer)localthreadIds.get();
            if (iD == null) {
                iD = new Integer(nextThreadIndex++);
                localthreadIds.set(iD);
            }
            this.threadId = iD;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.millisecond = System.currentTimeMillis();
            return;
        }
    }

    public String getLoggerName() {
        return this.loggerNamed;
    }

    public void setLoggerName(String name) {
        this.loggerNamed = name;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundler;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundler = bundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleNamed;
    }

    public void setResourceBundleName(String name) {
        this.resourceBundleNamed = name;
    }

    public Level getLevel() {
        return this.levels;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.levels = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumberId;
    }

    public void setSequenceNumber(long seq) {
        this.sequenceNumberId = seq;
    }

    public String getSourceClassName() {
        return this.sourceClassNamed;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassNamed = sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodNamed;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodNamed = sourceMethodName;
    }

    public String getMessage() {
        return this.messages;
    }

    public void setMessage(String message) {
        this.messages = message;
    }

    public Object[] getParameters() {
        return this.parameter;
    }

    public void setParameters(Object[] parameters) {
        this.parameter = parameters;
    }

    public int getThreadID() {
        return this.threadId;
    }

    public void setThreadID(int threadID) {
        this.threadId = threadID;
    }

    public long getMillis() {
        return this.millisecond;
    }

    public void setMillis(long millis) {
        this.millisecond = millis;
    }

    public Throwable getThrown() {
        return this.throwns;
    }

    public String getThrownBackTrace() {
        if (this.backTraces != null) {
            return this.backTraces;
        }
        if (this.throwns == null) {
            return null;
        }
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        this.throwns.printStackTrace(pwriter);
        pwriter.close();
        this.backTraces = swriter.toString();
        return this.backTraces;
    }

    public void setThrown(Throwable thrown) {
        this.throwns = thrown;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        this.getThrownBackTrace();
        output.defaultWriteObject();
        output.writeByte(1);
        output.writeByte(0);
        if (this.parameter == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(this.parameter.length);
        for (int i = 0; i < this.parameter.length; ++i) {
            if (this.parameter[i] == null) {
                output.writeObject(null);
                continue;
            }
            output.writeObject(this.parameter[i].toString());
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        byte majorObject = input.readByte();
        byte minorObject = input.readByte();
        if (majorObject != 1) {
            throw new IOException("LogRecord: bad version: " + majorObject + "." + minorObject);
        }
        int length = input.readInt();
        if (length == -1) {
            this.parameter = null;
        } else {
            this.parameter = new Object[length];
            for (int i = 0; i < this.parameter.length; ++i) {
                this.parameter[i] = input.readObject();
            }
        }
        if (this.resourceBundleNamed != null) {
            try {
                this.resourceBundler = ResourceBundle.getBundle(this.resourceBundleNamed);
            }
            catch (MissingResourceException ex) {
                this.resourceBundler = null;
            }
        }
    }

    static {
        nextThreadIndex = 10;
        localthreadIds = new ThreadLocal();
    }
}

