/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private Level pushLeve;
    private int sizes;
    private Handler targets;
    private LogRecord[] buffers;
    int started;
    int countNumber;

    private void configure() {
        LogManager managerLog = LogManager.getLogManager();
        String cnamed = MemoryHandler.class.getName();
        this.pushLeve = managerLog.getLevelProperty(cnamed + ".push", Level.SEVERE);
        this.sizes = managerLog.getIntProperty(cnamed + ".size", 1000);
        this.setLevel(managerLog.getLevelProperty(cnamed + ".level", Level.ALL));
        this.setFilter(managerLog.getFilterProperty(cnamed + ".filter", null));
        this.setFormatter(managerLog.getFormatterProperty(cnamed + ".formatter", new SimpleFormatter()));
    }

    public MemoryHandler() {
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
        String named = "???";
        try {
            LogManager logmanager = LogManager.getLogManager();
            named = logmanager.getProperty("se.ericsson.cello.support.logging.MemoryHandler.target");
            Class<?> claz = ClassLoader.getSystemClassLoader().loadClass(named);
            this.targets = (Handler)claz.newInstance();
        }
        catch (Exception ex) {
            System.err.println("MemoryHandler can't load handler \"" + named + "\"");
            System.err.println("" + ex);
            throw new RuntimeException("Can't load " + named);
        }
        this.init();
    }

    private void init() {
        this.buffers = new LogRecord[this.sizes];
        this.started = 0;
        this.countNumber = 0;
    }

    public MemoryHandler(Handler targets, int sizes, Level pushLeve) {
        if (targets == null || pushLeve == null) {
            throw new NullPointerException();
        }
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
        this.targets = targets;
        this.pushLeve = pushLeve;
        this.sizes = sizes;
        this.init();
    }

    public synchronized void publish(LogRecord logrecord) {
        if (!this.isLoggable(logrecord)) {
            return;
        }
        int index = (this.started + this.countNumber) % this.buffers.length;
        this.buffers[index] = logrecord;
        if (this.countNumber < this.buffers.length) {
            ++this.countNumber;
        } else {
            ++this.started;
        }
        if (logrecord.getLevel().intValue() >= this.pushLeve.intValue()) {
            this.push();
        }
    }

    public synchronized void push() {
        for (int i = 0; i < this.countNumber; ++i) {
            int index = (this.started + i) % this.buffers.length;
            LogRecord record = this.buffers[index];
            this.targets.publish(record);
        }
        this.started = 0;
        this.countNumber = 0;
    }

    public void flush() {
        this.targets.flush();
    }

    public void close() throws SecurityException {
        this.targets.close();
        this.setLevel(Level.OFF);
    }

    public void setPushLevel(Level newLeve) throws SecurityException {
        if (newLeve == null) {
            throw new NullPointerException();
        }
        LogManager logmanager = LogManager.getLogManager();
        this.checkAccessRight();
        this.pushLeve = newLeve;
    }

    public synchronized Level getPushLevel() {
        return this.pushLeve;
    }

    public boolean isLoggable(LogRecord logrecord) {
        return super.isLoggable(logrecord);
    }
}

