/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    Date dateObject = new Date();
    private static final String formate = "{0,date} {0,time}";
    private MessageFormat messageFormatter;
    private Object[] objectArgs = new Object[1];

    public synchronized String format(LogRecord logRecord) {
        StringBuffer sBuffer = new StringBuffer();
        this.dateObject.setTime(logRecord.getMillis());
        this.objectArgs[0] = this.dateObject;
        StringBuffer textBuffer = new StringBuffer();
        if (this.messageFormatter == null) {
            this.messageFormatter = new MessageFormat(formate);
        }
        this.messageFormatter.format(this.objectArgs, textBuffer, (FieldPosition)null);
        sBuffer.append(textBuffer);
        return this.appendString(logRecord, sBuffer);
    }

    private String appendString(LogRecord logRecord, StringBuffer sBuffer) {
        sBuffer.append(" ");
        if (logRecord.getSourceClassName() != null) {
            sBuffer.append(logRecord.getSourceClassName());
        } else {
            sBuffer.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            sBuffer.append(" ");
            sBuffer.append(logRecord.getSourceMethodName());
        }
        sBuffer.append("\n");
        String formatMessage = this.formatMessage(logRecord);
        sBuffer.append(logRecord.getLevel().toString());
        sBuffer.append(": ");
        sBuffer.append(formatMessage);
        sBuffer.append("\n");
        if (logRecord.getThrown() != null) {
            sBuffer.append(logRecord.getThrownBackTrace());
        }
        return sBuffer.toString();
    }
}

