/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.StreamHandler;
import se.ericsson.cello.support.logging.XMLFormatter;

public class SocketHandler
extends StreamHandler {
    private Socket socket;
    private String hosted;
    private int ports;

    private void configure() {
        LogManager managerLog = LogManager.getLogManager();
        String cnamed = SocketHandler.class.getName();
        this.setLevel(managerLog.getLevelProperty(cnamed + ".level", Level.ALL));
        this.setFilter(managerLog.getFilterProperty(cnamed + ".filter", null));
        this.setFormatter(managerLog.getFormatterProperty(cnamed + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(managerLog.getStringProperty(cnamed + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        this.ports = managerLog.getIntProperty(cnamed + ".port", 0);
        this.hosted = managerLog.getStringProperty(cnamed + ".host", null);
    }

    public SocketHandler() throws IOException {
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
        try {
            this.connect();
        }
        catch (IOException ix) {
            System.err.println("SocketHandler: connect failed to " + this.hosted + ":" + this.ports);
            throw ix;
        }
    }

    public SocketHandler(String host, int port) throws IOException {
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
        this.ports = port;
        this.hosted = host;
        this.connect();
    }

    private void connect() throws IOException {
        if (this.ports == 0) {
            throw new IllegalArgumentException("Bad port: " + this.ports);
        }
        if (this.hosted == null) {
            throw new IllegalArgumentException("Null host name: " + this.hosted);
        }
        this.socket = new Socket(this.hosted, this.ports);
        OutputStream output = this.socket.getOutputStream();
        BufferedOutputStream bufferout = new BufferedOutputStream(output);
        this.setOutputStream(bufferout);
    }

    public synchronized void close() throws SecurityException {
        super.close();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public synchronized void publish(LogRecord recorded) {
        if (!this.isLoggable(recorded)) {
            return;
        }
        super.publish(recorded);
        this.flush();
    }
}

