/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.LogRecord;

public class XMLFormatter
extends Formatter {
    private void a2(StringBuffer sbuff, int a) {
        if (a < 10) {
            sbuff.append('0');
        }
        sbuff.append(a);
    }

    private void appendISO8601(StringBuffer sbuff, long millisecond) {
        Date dates = new Date(millisecond);
        SimpleDateFormat sdformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sbuff.append(sdformat.format(dates));
    }

    public String format(LogRecord recorder) {
        StringBuffer sbuff;
        block13: {
            sbuff = new StringBuffer(500);
            sbuff.append("<record>\n");
            sbuff.append("  <date>");
            this.appendISO8601(sbuff, recorder.getMillis());
            sbuff.append("</date>\n");
            sbuff.append("  <millis>");
            sbuff.append(recorder.getMillis());
            sbuff.append("</millis>\n");
            sbuff.append("  <sequence>");
            sbuff.append(recorder.getSequenceNumber());
            sbuff.append("</sequence>\n");
            sbuff.append("  <logger>");
            sbuff.append(recorder.getLoggerName());
            sbuff.append("</logger>\n");
            sbuff.append("  <level>");
            sbuff.append(recorder.getLevel().toString());
            sbuff.append("</level>\n");
            if (recorder.getSourceClassName() != null) {
                sbuff.append("  <class>");
                sbuff.append(recorder.getSourceClassName());
                sbuff.append("</class>\n");
            }
            if (recorder.getSourceMethodName() != null) {
                sbuff.append("  <method>");
                sbuff.append(recorder.getSourceMethodName());
                sbuff.append("</method>\n");
            }
            sbuff.append("  <thread>");
            sbuff.append(recorder.getThreadID());
            sbuff.append("</thread>\n");
            if (recorder.getMessage() != null) {
                String message = this.formatMessage(recorder);
                sbuff.append("  <message>");
                sbuff.append(message);
                sbuff.append("</message>");
                sbuff.append("\n");
            }
            ResourceBundle bundle = recorder.getResourceBundle();
            try {
                if (bundle == null || bundle.getString(recorder.getMessage()) == null) break block13;
                sbuff.append("  <key>");
                sbuff.append(recorder.getMessage());
                sbuff.append("</key>\n");
                sbuff.append("  <catalog>");
                sbuff.append(recorder.getResourceBundleName());
                sbuff.append("</catalog>\n");
                Object[] parameters = recorder.getParameters();
                for (int k = 0; k < parameters.length; ++k) {
                    sbuff.append("  <param>");
                    try {
                        sbuff.append(parameters[k].toString());
                    }
                    catch (Exception ex) {
                        sbuff.append("???");
                    }
                    sbuff.append("</param>\n");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (recorder.getThrown() != null) {
            sbuff.append("  <exception>\n");
            try {
                int start;
                int end;
                Throwable th = recorder.getThrown();
                sbuff.append("    <message>");
                sbuff.append(th.toString());
                sbuff.append("</message>\n");
                String stack = recorder.getThrownBackTrace();
                int index = 0;
                while (index < stack.length() && (index = stack.indexOf("at ", index)) >= 0 && (end = stack.indexOf("(", start = index + 3)) >= 0) {
                    int dot = stack.lastIndexOf(".", end);
                    sbuff.append("    <frame>\n");
                    sbuff.append("      <class>");
                    sbuff.append(stack.substring(start, dot));
                    sbuff.append("</class>\n");
                    sbuff.append("      <method>");
                    sbuff.append(stack.substring(dot + 1, end));
                    sbuff.append("</method>\n");
                    start = stack.indexOf(":", end);
                    end = stack.indexOf(")", end);
                    if (start > 0 && start < end) {
                        sbuff.append("      <line>");
                        sbuff.append(stack.substring(start + 1, end));
                        sbuff.append("</line>\n");
                    }
                    sbuff.append("    </frame>\n");
                    index = end;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            sbuff.append("  </exception>\n");
        }
        sbuff.append("</record>\n");
        return sbuff.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("<?xml version=\"1.0\"");
        String encoding = handler.getEncoding();
        if (encoding != null && encoding.equals("UTF8")) {
            encoding = "UTF-8";
        }
        if (encoding != null) {
            sbuffer.append(" encoding=\"");
            sbuffer.append(encoding);
            sbuffer.append("\"");
        }
        sbuffer.append(" standalone=\"no\"?>\n");
        sbuffer.append("<!DOCTYPE log SYSTEM \"file:logger.dtd\">\n");
        sbuffer.append("<log>\n");
        return sbuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>\n";
    }
}

