/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.Filter;
import BasicConfig.Session;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.MOName;
import se.ericsson.cello.support.proxy.MOProxyCache;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.RequestedAttributeSeq;
import se.ericsson.cello.support.proxy.Trace;

public class MOProxy
implements Comparable {
    private static final String EmasViewElementCreatorClass = "se.ericsson.cello.support.mgr.EmasViewElementCreator";
    private Filter filter = new Filter("", "");
    private MOName dn;
    private CSFacade cs;
    private Consumer consumer = new Consumer();
    private Vector listeners = new Vector();
    private static final boolean useOfCacheIsEnabled = true;

    public MOProxy(String aLDN) {
        this(new MOName(aLDN));
        Trace.enter(MOProxy.class, "MOProxy(String)", aLDN);
    }

    public boolean isExisting() throws CSException {
        Trace.enter(MOProxy.class, "isExisting()");
        boolean exists = this.cs.isMO(this.dn);
        Trace.exit(MOProxy.class, "isExisting()", Boolean.valueOf(String.valueOf(exists)));
        return exists;
    }

    public int compareTo(Object o) {
        return this.getDN().compareTo(((MOProxy)o).getDN());
    }

    public boolean isExisting(Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "isExisting()", aSession);
        boolean exists = this.cs.isMO(this.dn, aSession);
        Trace.exit(MOProxy.class, "isExisting()", Boolean.valueOf(String.valueOf(exists)));
        return exists;
    }

    public void create() throws CSException {
        Trace.enter(MOProxy.class, "create()");
        this.cs.createMO(this.dn);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void create(Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "create()", aSession);
        this.cs.createMO(this.dn, aSession);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void create(NameValue[] someAttributes) throws CSException {
        Trace.enter(MOProxy.class, "create(NameValue[])", someAttributes);
        this.cs.createMO(this.dn, someAttributes);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void create(NameValue[] someAttributes, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "create(NameValue[])", someAttributes, aSession);
        this.cs.createMO(this.dn, someAttributes, aSession);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void delete() throws CSException {
        Trace.enter(MOProxy.class, "delete()");
        this.cs.deleteMO(this.dn, 0, this.filter);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void delete(int aScope, String aType, String aFilter) throws CSException {
        Trace.enter(MOProxy.class, "delete()", new Integer(aScope), aType, aFilter);
        this.cs.deleteMO(this.dn, aScope, new Filter(aType, aFilter));
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void delete(Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "delete()", aSession);
        this.cs.deleteMO(this.dn, 0, this.filter, aSession);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public void delete(int aScope, String aType, String aFilter, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "delete()", new Integer(aScope), aType, aFilter, aSession);
        this.cs.deleteMO(this.dn, aScope, new Filter(aType, aFilter), aSession);
        MOProxyCache.getInstance().flush(this.getParent());
    }

    public Object action(String anAction, NameValue[] someParameters) throws CSException {
        Trace.enter(MOProxy.class, "action(String,  NameValue[])", anAction, someParameters);
        Object returnValue = this.cs.action(this.dn, anAction, someParameters);
        return returnValue;
    }

    public Object action(String anAction, NameValue[] someParameters, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "action(String,  NameValue[])", anAction, someParameters, aSession);
        Object returnValue = this.cs.action(this.dn, anAction, someParameters, aSession);
        return returnValue;
    }

    public MOProxy getParent() {
        MOName parentDN = this.dn.getParentName();
        MOProxy parent = new MOProxy(parentDN);
        return parent;
    }

    public MOProxy[] getChildren() throws CSException {
        MOProxy[] children = null;
        children = MOProxyCache.getInstance().getMOChildren(this);
        return children;
    }

    public MOProxy[] getChildren(Session aSession) throws CSException {
        MOName[] childrenDNs = this.cs.getMOChildren(this.dn, 1, this.filter, aSession);
        MOProxy[] children = new MOProxy[childrenDNs.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = new MOProxy(childrenDNs[i]);
        }
        return children;
    }

    public MOProxy[] getChildren(int aScope, String aType, String aFilter) throws CSException {
        MOProxy[] children = null;
        if (aType.equals("") && aFilter.equals("")) {
            children = MOProxyCache.getInstance().getMOChildren(this, aScope, aType);
        } else {
            MOName[] childrenDNs = this.cs.getMOChildren(this.dn, aScope, new Filter(aType, aFilter));
            children = new MOProxy[childrenDNs.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = new MOProxy(childrenDNs[i]);
            }
        }
        return children;
    }

    public MOProxy[] getChildren(int aScope, String aType, String aFilter, Session aSession) throws CSException {
        MOName[] childrenDNs = this.cs.getMOChildren(this.dn, aScope, new Filter(aType, aFilter), aSession);
        MOProxy[] children = new MOProxy[childrenDNs.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = new MOProxy(childrenDNs[i]);
        }
        return children;
    }

    public Hashtable getChildrenWithAttributes(String childrenType, String[] attrNames, int scope) throws CSException {
        Hashtable mosAndAttribs = null;
        try {
            mosAndAttribs = this.cs.getMosWithAttributes(this.getDN(), childrenType, attrNames, scope);
        }
        catch (CSException x) {
            Trace.exception(this.getClass(), "getMosWithAttributes", x);
            throw x;
        }
        return mosAndAttribs;
    }

    public String getDN() {
        Trace.enter(MOProxy.class, "getDN()");
        String rdnSeq = this.dn.getRDNSeq();
        Trace.exit(MOProxy.class, "getDN()", rdnSeq);
        return rdnSeq;
    }

    public String getLastRDN() {
        Trace.enter(MOProxy.class, "getLastRDN()");
        String rdn = this.dn.getLastRDN();
        Trace.exit(MOProxy.class, "getLastRDN()", rdn);
        return rdn;
    }

    public String getType() {
        Trace.enter(MOProxy.class, "getType()");
        String type = this.dn.getType();
        Trace.exit(MOProxy.class, "getType()", type);
        return type;
    }

    public String getId() {
        Trace.enter(MOProxy.class, "getId()");
        String id = this.dn.getId();
        Trace.exit(MOProxy.class, "getId()", id);
        return id;
    }

    public Object[] getAttributes(String[] someAttributeNames) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(String[])", someAttributeNames);
        Object[] attributeValues = this.cs.getMOAttributes(this.dn, someAttributeNames, this.filter);
        Trace.exit(MOProxy.class, "getAttributes(String[])", attributeValues);
        return attributeValues;
    }

    public Object[] getAttributes(String[] someAttributeNames, String aType, String aFilter) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(String[])", someAttributeNames, aType, aFilter);
        Object[] attributeValues = this.cs.getMOAttributes(this.dn, someAttributeNames, new Filter(aType, aFilter));
        Trace.exit(MOProxy.class, "getAttributes(String[])", attributeValues);
        return attributeValues;
    }

    public Object[] getAttributes(String[] someAttributeNames, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(String[])", someAttributeNames, aSession);
        Object[] attributeValues = this.cs.getMOAttributes(this.dn, someAttributeNames, this.filter, aSession);
        Trace.exit(MOProxy.class, "getAttributes(String[])", attributeValues);
        return attributeValues;
    }

    public Object[] getAttributes(String[] someAttributeNames, String aType, String aFilter, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(String[])", someAttributeNames, aType, aFilter, aSession);
        Object[] attributeValues = this.cs.getMOAttributes(this.dn, someAttributeNames, new Filter(aType, aFilter), aSession);
        Trace.exit(MOProxy.class, "getAttributes(String[])", attributeValues);
        return attributeValues;
    }

    public static NameValue[][] getAttributes(RequestedAttributeSeq[] someAttributeNames, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(RequestedAttributeSeq[])", someAttributeNames, aSession);
        CSFacade cs = CSFacade.getInstance();
        NameValue[][] attributeValues = cs.getMOAttributes(someAttributeNames, aSession);
        return attributeValues;
    }

    public static NameValue[][] getAttributes(RequestedAttributeSeq[] someAttributeNames) throws CSException {
        Trace.enter(MOProxy.class, "getAttributes(RequestedAttributeSeq[])");
        CSFacade cs = CSFacade.getInstance();
        NameValue[][] attributeValues = cs.getMOAttributes(someAttributeNames);
        return attributeValues;
    }

    public Object getAttribute(String anAttributeName) throws CSException {
        Trace.enter(MOProxy.class, "getAttribute(String)", anAttributeName);
        Object attributeValue = this.cs.getMOAttribute(this.dn, anAttributeName, this.filter);
        Trace.exit(MOProxy.class, "getAttribute(String)", attributeValue);
        return attributeValue;
    }

    public Object getAttribute(String anAttributeName, String aType, String aFilter) throws CSException {
        Trace.enter(MOProxy.class, "getAttribute(String)", anAttributeName, aType, aFilter);
        Object attributeValue = this.cs.getMOAttribute(this.dn, anAttributeName, new Filter(aType, aFilter));
        Trace.exit(MOProxy.class, "getAttribute(String)", attributeValue);
        return attributeValue;
    }

    public Object getAttribute(String anAttributeName, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getAttribute(String)", anAttributeName, aSession);
        Object attributeValue = this.cs.getMOAttribute(this.dn, anAttributeName, this.filter, aSession);
        Trace.exit(MOProxy.class, "getAttribute(String)", attributeValue);
        return attributeValue;
    }

    public Object getAttribute(String anAttributeName, String aType, String aFilter, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getAttribute(String)", anAttributeName, aFilter, aSession);
        Object attributeValue = this.cs.getMOAttribute(this.dn, anAttributeName, new Filter(aType, aFilter), aSession);
        Trace.exit(MOProxy.class, "getAttribute(String)", attributeValue);
        return attributeValue;
    }

    public void setAttribute(String anAttributeName, Object anAttributeValue) throws CSException {
        Trace.enter(MOProxy.class, "setAttribute(String, Object)", anAttributeName, anAttributeValue);
        this.cs.setMOAttribute(this.dn, anAttributeName, anAttributeValue);
        Trace.exit(MOProxy.class, "setAttribute(String, Object)");
    }

    public void setAttribute(String anAttributeName, Object anAttributeValue, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "setAttribute(String, Object)", anAttributeName, anAttributeValue, aSession);
        this.cs.setMOAttribute(this.dn, anAttributeName, anAttributeValue, aSession);
        Trace.exit(MOProxy.class, "setAttribute(String, Object)");
    }

    public void setAttributes(NameValue[] someAttributes) throws CSException {
        Trace.enter(MOProxy.class, "setAttributes(NameValue[])", someAttributes);
        this.cs.setMOAttributes(this.dn, someAttributes);
        Trace.exit(MOProxy.class, "setAttributes(NameValue[])");
    }

    public void setAttributes(NameValue[] someAttributes, Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "setAttributes(NameValue[])", someAttributes, aSession);
        this.cs.setMOAttributes(this.dn, someAttributes, aSession);
        Trace.exit(MOProxy.class, "setAttributes(NameValue[])");
    }

    public String toString() {
        String name = this.dn.toString();
        return name;
    }

    public int hashCode() {
        int code = this.dn.hashCode();
        return code;
    }

    public boolean equals(Object anObject) {
        boolean equality = false;
        if (anObject instanceof MOProxy) {
            MOProxy moProxy = (MOProxy)anObject;
            equality = this.dn.equals(moProxy.dn);
        } else {
            equality = this.dn.equals(anObject);
        }
        return equality;
    }

    public void addMOListener(MOListener anMOListener) {
        boolean wasEmpty = this.listeners.isEmpty();
        this.listeners.addElement(anMOListener);
        if (wasEmpty) {
            this.cs.subscribe(this.consumer, this.dn);
        }
    }

    public void removeMOListener(MOListener anMOListener) {
        this.listeners.removeElement(anMOListener);
        if (this.listeners.isEmpty()) {
            this.cs.unsubscribe(this.consumer, this.dn);
        } else if (this.listeners.size() == 1 && this.listeners.lastElement().getClass().getName().equals(EmasViewElementCreatorClass)) {
            this.listeners.removeAllElements();
            this.cs.unsubscribe(this.consumer, this.dn);
        } else {
            boolean onlyCreatorsLeft = true;
            for (MOListener mol : this.listeners) {
                if (mol.getClass().getName().equals(EmasViewElementCreatorClass)) continue;
                onlyCreatorsLeft = false;
            }
            if (onlyCreatorsLeft) {
                this.listeners.removeAllElements();
                this.cs.unsubscribe(this.consumer, this.dn);
            }
        }
    }

    public static void beginTransaction() throws CSException {
        Trace.enter(MOProxy.class, "beginTransaction()");
        CSFacade cs = CSFacade.getInstance();
        cs.beginTransaction();
    }

    public static void endTransaction(boolean aCommit) throws CSException {
        Trace.enter(MOProxy.class, "endTransaction(boolean)", Boolean.valueOf(String.valueOf(aCommit)));
        CSFacade cs = CSFacade.getInstance();
        cs.endTransaction(aCommit);
    }

    public static MOProxy getRoot() throws CSException {
        Trace.enter(MOProxy.class, "getRoot()");
        CSFacade cs = CSFacade.getInstance();
        MOName rootDN = cs.getRootMOName();
        MOProxy rootMO = new MOProxy(rootDN);
        Trace.exit(MOProxy.class, "getRoot()", rootMO);
        return rootMO;
    }

    public static MOProxy getRoot(Session aSession) throws CSException {
        Trace.enter(MOProxy.class, "getRoot()");
        CSFacade cs = CSFacade.getInstance();
        MOName rootDN = cs.getRootMOName(aSession);
        MOProxy rootMO = new MOProxy(rootDN);
        Trace.exit(MOProxy.class, "getRoot()", rootMO);
        return rootMO;
    }

    MOProxy(MOName aDN) {
        Trace.enter(MOProxy.class, "MOProxy(MOName)", aDN);
        String ldn = aDN.getRDNSeq();
        if (ldn != null) {
            int rdnIdx = ldn.indexOf("ManagedElement=1");
            if (rdnIdx > 0) {
                ldn = ldn.substring(rdnIdx);
                this.dn = new MOName(ldn);
            } else {
                this.dn = aDN;
            }
        } else {
            this.dn = aDN;
        }
        this.cs = CSFacade.getInstance();
    }

    public static String genLDN(String parent, String moType) throws CSException {
        String uniqueLDN = parent + "," + moType + "=" + MOProxy.genFreeIdentity(parent, moType);
        return uniqueLDN;
    }

    public static int genFreeIdentity(String parent, String moType) throws CSException {
        int freeId;
        MOProxy parentMO = new MOProxy(parent);
        MOProxyCache.getInstance().flush(parentMO);
        MOProxy[] mos = parentMO.getChildren(1, moType, "");
        for (freeId = 1; freeId <= mos.length; ++freeId) {
            int i;
            for (i = 0; i < mos.length; ++i) {
                try {
                    Integer dummy = new Integer(mos[i].getId());
                    if (dummy != freeId) continue;
                    break;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (i == mos.length) break;
        }
        return freeId;
    }

    public static void cleanup() {
        if (MOProxyCache.getInstance() != null) {
            MOProxyCache.getInstance().flush();
            MOProxyCache.getInstance().cleanup();
        }
    }

    private class Consumer
    implements CSFacade.Subscriber {
        private Consumer() {
        }

        public void childCreated(MOName theChild) {
            Iterator i = ((Vector)MOProxy.this.listeners.clone()).iterator();
            while (i.hasNext()) {
                try {
                    MOListener mol = (MOListener)i.next();
                    mol.childCreated(new MOProxy(theChild));
                }
                catch (Exception e) {
                    Trace.exception(this.getClass(), "childCreated", e);
                }
            }
        }

        public void childDeleted(MOName theChild) {
            Iterator i = ((Vector)MOProxy.this.listeners.clone()).iterator();
            while (i.hasNext()) {
                try {
                    MOListener mol = (MOListener)i.next();
                    mol.childDeleted(new MOProxy(theChild));
                }
                catch (Exception e) {
                    Trace.exception(this.getClass(), "childDeleted", e);
                }
            }
        }

        public void attributesChanged(MOName theMO, NameValue[] someAttributes) {
            Iterator i = ((Vector)MOProxy.this.listeners.clone()).iterator();
            while (i.hasNext()) {
                try {
                    MOListener mol = (MOListener)i.next();
                    mol.attributesChanged(new MOProxy(theMO), someAttributes);
                }
                catch (Exception e) {
                    Trace.exception(this.getClass(), "attributesChanged", e);
                }
            }
        }
    }

    public static interface MOListener {
        public void childCreated(MOProxy var1);

        public void childDeleted(MOProxy var1);

        public void attributesChanged(MOProxy var1, NameValue[] var2);
    }
}

