/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.climate;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.cabinet.CabinetMaoImpl;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ClimateHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;

public class ClimateMaoImpl
extends GenericMao {
    private static final String MO_TYPE_CABINET = "Cabinet";
    private static final String MO_TYPE_CLIMATE = "Climate";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    public static final String ATTRIBUTE_CLIMATE_CONTROL_MODE = "climateControlMode";
    private static final String ATTRIBUTE_CONTROL_DOMAIN_REF = "controlDomainRef";
    private static final String ATTRIBUTE_CABINET_TEMPERATURE = "cabinetTemperature";
    private static final Class THIS_CLASS = ClimateMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "Climate";

    public ClimateMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, "Climate", genericMaoContext, n, coordinator, initialMaoContext);
        int n2;
        int n3;
        logger.traceEnter(THIS_CLASS, "ClimateMaoImpl() - constructor");
        int n4 = attrList.indexOf(ATTRIBUTE_CONTROL_DOMAIN_REF);
        if (n4 >= 0) {
            logger.traceGeneral(THIS_CLASS, "Handle attribute controlDomainRef at Climate MO creation.");
            ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n4);
            this.validateControlDomainRef(managedObjectArray, coordinator);
        }
        if ((n3 = attrList.indexOf(ATTRIBUTE_CLIMATE_CONTROL_MODE)) >= 0) {
            logger.traceGeneral(THIS_CLASS, "Handle attribute climateControlMode at Climate MO creation.");
            Integer n5 = (Integer)attrList.getValue(n3);
            this.mirrorClimateControlModeToCabinet(n5, coordinator);
        }
        if ((n2 = attrList.indexOf(ATTRIBUTE_CABINET_TEMPERATURE)) >= 0) {
            logger.traceGeneral(THIS_CLASS, "Handle attribute cabinetTemperature at Climate MO creation.");
            Integer n6 = (Integer)attrList.getValue(n2);
        }
        logger.traceReturn(THIS_CLASS, "ClimateMaoImpl() - constructor");
    }

    public ClimateMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    private void postSetClimateControlMode(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postSetClimateControlModeOnCabinet()");
        this.mirrorClimateControlModeToCabinet(n, coordinator);
        logger.traceReturn(THIS_CLASS, "postSetClimateControlModeOnCabinet()");
    }

    private void mirrorClimateControlModeToCabinet(Integer n, Coordinator coordinator) throws MoAccessException {
        Integer n2;
        logger.traceEnter(((Object)((Object)this)).getClass(), "mirrorClimateControlModeToCabinet()");
        ClimateHelper climateHelper = new ClimateHelper();
        ManagedObject managedObject = climateHelper.getCabinetForClimate((ManagedObject)this, coordinator);
        if (managedObject != null && !(n2 = (Integer)managedObject.getAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, coordinator)).equals(n)) {
            managedObject.setAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, (Object)n, coordinator);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "mirrorClimateControlModeToCabinet()");
    }

    private void postSetControlDomainRef(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postSetControlDomainRef()");
        Integer n = (Integer)this.getAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, coordinator);
        this.mirrorClimateControlModeToCabinet(n, coordinator);
        ClimateHelper climateHelper = new ClimateHelper();
        CabinetMaoImpl cabinetMaoImpl = (CabinetMaoImpl)climateHelper.getCabinetForClimate((ManagedObject)this, coordinator);
        if (cabinetMaoImpl != null) {
            cabinetMaoImpl.createFanGroups(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSetControlDomainRef()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_CONTROL_MODE)) {
            this.postSetClimateControlMode((Integer)object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CONTROL_DOMAIN_REF)) {
            this.postSetControlDomainRef(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "preSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_CONTROL_DOMAIN_REF)) {
            this.preSetControlDomainRef((ManagedObject[])object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_CONTROL_MODE)) {
            this.preSetClimateControlMode(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void preSetClimateControlMode(Coordinator coordinator) throws ValueOutOfRangeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetClimateControlMode()");
        logger.traceGeneral(THIS_CLASS, "Attribute will be validated");
        if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
            throw new ValueOutOfRangeException(ATTRIBUTE_CLIMATE_CONTROL_MODE, "Climate", "Attribute climateControlMode cannot be set in a Secondary Node.");
        }
        logger.traceReturn(THIS_CLASS, "preSetClimateControlMode()");
    }

    private void preSetControlDomainRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws ValueOutOfRangeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetControlDomainRef");
        this.validateControlDomainRef(managedObjectArray, coordinator);
        logger.traceReturn(THIS_CLASS, "preSetControlDomainRef");
    }

    private void validateControlDomainRef(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
        if (managedObjectArray.length > 1) {
            logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef cannot refer to more than one MO.");
            throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, "Climate", "Attribute controlDomainRef cannot refer to more than one MO.");
        }
        if (managedObjectArray.length == 1) {
            if (managedObjectArray[0].getType().equals(MO_TYPE_CABINET)) {
                ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[0].getAttribute(ATTRIBUTE_RESERVED_BY, coordinator);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    if (!managedObjectArray2[i].getType().equals("Climate") || managedObjectArray2[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                    logger.traceGeneral(THIS_CLASS, "The Cabinet MO cannot be referred to since it is already referred to from another Climate MO.");
                    throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, "Climate", "The Cabinet MO cannot be referred to since it is already referred to from another Climate MO.");
                }
            } else {
                logger.traceGeneral(THIS_CLASS, "Attribute controlDomainRef can only refer to MO of type Cabinet");
                throw new ValueOutOfRangeException(ATTRIBUTE_CONTROL_DOMAIN_REF, "Climate", "Attribute controlDomainRef can only refer to MO of type Cabinet");
            }
        }
        logger.traceEnter(THIS_CLASS, "validateControlDomainRef");
    }
}

