/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.energymeter;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.consumedenergy.ConsumedEnergyMaoImpl;
import se.ericsson.crbs.supsys.efuse.ActionNotSupportedException;

public class EnergyMeterMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = EnergyMeterMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "EnergyMeter";
    private static final String ATTRIBUTE_CONSUMED_ENERGY_REF = "consumedEnergyRef";
    private static final String CONSUMED_ENERGY_MO = "ConsumedEnergy";
    private static final String AUX_PLUG_IN_UNIT_MO = "AuxPlugInUnit";
    private ManagedObject parent;

    public EnergyMeterMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EneryMeterMaoImpl() - constructor");
        this.parent = managedObject;
        this.setConsumedEnergyReference(coordinator);
        logger.traceReturn(THIS_CLASS, "EneryMeterMaoImpl() - constructor");
    }

    public EnergyMeterMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EnergyMeterImpl() - Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "EnergyMeterImpl() - Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- " + string);
        if (string.equals(ATTRIBUTE_CONSUMED_ENERGY_REF)) {
            this.preSetConsumedEnergyRef(object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void preSetConsumedEnergyRef(Object object, Coordinator coordinator) throws ActionNotSupportedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetConsumedEnergyRef()");
        boolean bl = object instanceof ConsumedEnergyMaoImpl;
        boolean bl2 = this.parent.getType().equals(AUX_PLUG_IN_UNIT_MO);
        if (!bl || !bl2) {
            throw new ActionNotSupportedException(MO_TYPE, "Attribute consumedEnergyRef cannot be set manually.");
        }
        logger.traceReturn(THIS_CLASS, "preSetConsumedEnergyRef()");
    }

    private void setConsumedEnergyReference(Coordinator coordinator) throws ActionNotSupportedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "setConsumedEnergyReference()");
        if (this.parent.getType().equals(AUX_PLUG_IN_UNIT_MO) && this.moExists(CONSUMED_ENERGY_MO)) {
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(CONSUMED_ENERGY_MO);
            this.setAttribute(ATTRIBUTE_CONSUMED_ENERGY_REF, moIterator.nextMo(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setConsumedEnergyReference()");
    }

    private boolean moExists(String string) {
        logger.traceEnter(THIS_CLASS, "moExists()");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        logger.traceReturn(THIS_CLASS, "moExists()");
        return null != moIterator;
    }
}

