/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportunit;

import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class SupportUnitMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = SupportUnitMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String RESULT_UNSUPPORTED_ACTION_ON_OBJECT = Integer.toString(0x1040001);
    private static final int LOCKED = 0;
    private static final int SHUTTING_DOWN = 2;
    private static final String MO_TYPE = "SupportUnit";
    private static final String ACTION_DEREGISTER_SUPPORT_UNIT = "deregisterSupportUnit";
    private static final String OPERATIONAL_STATE = "operationalState";
    private static final String ADMINISTRATIVE_STATE = "administrativeState";
    protected static final String ATTRIBUTE_PROVIDED_SERVICES = "providedServices";
    protected static final String ATTRIBUTE_SU_ADDRESS_INFO = "suAddressInfo";
    private boolean beingDeregistered = false;

    public SupportUnitMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "SupportUnitMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "SupportUnitMaoImpl() - constructor");
    }

    public SupportUnitMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "SupportUnitMaoImpl() - Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "SupportUnitMaoImpl() - Constructor used at restore");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_PROVIDED_SERVICES, (Object)nArray);
        ((AttrListImpl)attrList).addAttribute(ATTRIBUTE_SU_ADDRESS_INFO, (Object)nArray2);
        return attrList;
    }

    public void actionDeregisterSupportUnit(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionDeregisterSupportUnit()");
        this.beingDeregistered = true;
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap treeMap = new TreeMap();
        try {
            this.sendActionWithCfm(ACTION_DEREGISTER_SUPPORT_UNIT, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_UNSUPPORTED_ACTION_ON_OBJECT)) {
                String string3 = "Action not supported on object. " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionDeregisterSupportUnit()");
    }

    public void delete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "delete()");
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    private int getReservedByCount(Coordinator coordinator) throws MoAccessException {
        Object object = this.getAttribute("reservedBy", coordinator);
        if (object != null && object instanceof ManagedObject[]) {
            return ((ManagedObject[])object).length;
        }
        return -1;
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException, MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "release(" + managedObject.getFullDistinguishedName() + ")");
        int n = this.getReservedByCount(coordinator);
        super.release(managedObject, coordinator);
        int n2 = this.getReservedByCount(coordinator);
        if (!this.beingDeregistered && n > 0 && n2 == 0) {
            logger.traceGeneral(THIS_CLASS, "Performing automatic deregistration for " + this.getFullDistinguishedName() + " (since no longer referred to)");
            this.actionDeregisterSupportUnit(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "release(" + managedObject.getFullDistinguishedName() + ")");
    }
}

