/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.model.LicenseType;
import se.ericsson.cello.licensing.model.LicensingModelFactory;
import se.ericsson.cello.licensing.view.DisplayKeyFileListener;
import se.ericsson.cello.licensing.view.HyperToolListener;
import se.ericsson.cello.licensing.view.HyperToolParser;
import se.ericsson.cello.licensing.view.LicenseView;
import se.ericsson.cello.licensing.view.OpenPropsListener;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class LicenseController {
    private LicenseView licView = null;
    private TableModel model;
    private NodeServices myNodeServices;
    private final LauncherInterface myLauncher;
    private final Launchable myParent;
    private final Properties myProperties;
    private LicenseType myType;
    private HyperToolParser myHyperToolParser;
    private DisplayKeyFileListener myDisplayKeyFileListener;
    private OpenPropsListener myOpenPropsListener;
    private RefreshListener myRefreshListener;

    public LicenseController(Properties properties, Launchable parent, LauncherInterface launcher, NodeServices nodeServices, LicenseType type) {
        this.myLauncher = launcher;
        this.myParent = parent;
        this.myProperties = properties;
        this.myNodeServices = nodeServices;
        this.myType = type;
        this.myHyperToolParser = new HyperToolParser(properties);
    }

    public JComponent getComponent() {
        if (this.licView == null) {
            this.licView = new LicenseView(this.model, this.myHyperToolParser.getHyperToolNames(), this.myType);
        }
        return this.licView.getComponent();
    }

    private void initNodeServices() {
        LicensingLogger.logger().finer("Init NodeService");
        String myHost = this.myProperties.getProperty("HOST", "Host is not defined");
        String myNodservicesConfig = (String)this.myProperties.get("NODESERVICES_CONFIG");
        try {
            if (this.myNodeServices == null) {
                this.myNodeServices = (NodeServices)LaunchHandler.getToolAsResource((LauncherInterface)this.myLauncher, (String)myNodservicesConfig, (String)myHost, (Properties)this.myProperties, (Launchable)this.myParent);
            }
        }
        catch (Exception ce) {
            LicensingLogger.logger().log(Level.WARNING, "It was not possible to launch Node Services.\n" + LicensingLogger.stackToString(ce));
            MessageDialogFactory.createMessageDialog((String)"Node Connection Failure", (String)"Failed to get a node connection. Not possible to fetch license information.", (Exception)ce, (boolean)false, null).setVisible(true);
        }
    }

    public void init() {
        LicensingLogger.logger().fine("LicenseController: init");
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    LicenseController.this.init();
                }
            };
            new Thread(runner).start();
        } else {
            this.initNodeServices();
            try {
                this.model = LicensingModelFactory.createModel(this.myNodeServices, this.myType);
            }
            catch (Exception e) {
                LicensingLogger.logger().warning("Failed to create model for " + this.myType.tabName + ". " + LicensingLogger.stackToString(e));
                MessageDialogFactory.createMessageDialog((String)("Problems occurred when creating the tab " + this.myType.tabName), (String)(this.myType.tabName + " might not be displayed correctly."), (Exception)e, (boolean)false, null).setVisible(true);
            }
            this.initView(this.model);
            LicensingLogger.logger().fine("LicenseController: init done");
        }
    }

    public void destroy() {
        LicensingLogger.logger().fine("Destroying a Licensing Embeddable GUI");
        this.licView.getComponent().setVisible(false);
        this.licView.removeKeyFileListener(this.myDisplayKeyFileListener);
        this.licView.removePropsListener(this.myOpenPropsListener);
        this.licView.removeRefreshListener(this.myRefreshListener);
        this.licView.getComponent().removeAll();
        this.myDisplayKeyFileListener = null;
        this.myOpenPropsListener = null;
        this.myRefreshListener = null;
        this.licView = null;
        this.model = null;
        this.myNodeServices = null;
        this.myType = null;
        this.myHyperToolParser = null;
    }

    private void initView(final TableModel model) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LicenseController.this.licView = new LicenseView(model, LicenseController.this.myHyperToolParser.getHyperToolNames(), LicenseController.this.myType);
                    LicenseController.this.myDisplayKeyFileListener = new DisplayKeyFileListener(LicenseController.this.myLauncher, LicenseController.this.myParent, LicenseController.this.myProperties, LicenseController.this.myNodeServices);
                    LicenseController.this.licView.setKeyFileListener(LicenseController.this.myDisplayKeyFileListener);
                    LicenseController.this.myOpenPropsListener = new OpenPropsListener(LicenseController.this.myLauncher, LicenseController.this.myParent, LicenseController.this.myProperties, LicenseController.this.licView);
                    LicenseController.this.licView.setPropsListener(LicenseController.this.myOpenPropsListener);
                    LicenseController.this.myRefreshListener = new RefreshListener();
                    LicenseController.this.licView.setRefreshListener(LicenseController.this.myRefreshListener);
                    LicenseController.this.licView.setHyperToolsListener(new HyperToolListener(LicenseController.this.myLauncher, LicenseController.this.myParent, LicenseController.this.myProperties, LicenseController.this.licView, LicenseController.this.myHyperToolParser.getHyperTools()));
                }
            });
        }
        catch (InterruptedException e) {
            LicensingLogger.logger().warning("Interrupted during initializing license view." + LicensingLogger.stackToString(e));
        }
        catch (InvocationTargetException e) {
            LicensingLogger.logger().warning("InvocationTargetException when initializing license view" + LicensingLogger.stackToString(e));
        }
    }

    class RefreshListener
    implements ActionListener {
        RefreshListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LicensingLogger.logger().fine(this.getClass().getName() + " refresh");
            LicenseController.this.model = LicensingModelFactory.createModel(LicenseController.this.myNodeServices, LicenseController.this.myType);
            LicenseController.this.licView.setModel(LicenseController.this.model);
        }
    }
}

