/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.ISSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.SSLSocketFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.Socket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.factory.SocketFactory;

public class PortRangeSSLSocketFactory
extends AbstractSocketFactory
implements ConfigurableSSLSocketFactory,
Configurable,
SocketFactory {
    private final ISSLSocketFactory delegate;
    public static final String MIN_PROP = "jacorb.ssl.socket_factory.port_min";
    public static final String MAX_PROP = "jacorb.ssl.socket_factory.port_max";
    private int portMin;
    private int portMax;

    public PortRangeSSLSocketFactory(ORB oRB) {
        this(new SSLSocketFactory(oRB));
    }

    public PortRangeSSLSocketFactory(ISSLSocketFactory iSSLSocketFactory) {
        this.delegate = iSSLSocketFactory;
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.portMin = configuration.getAttributeAsInteger(MIN_PROP);
        this.portMax = configuration.getAttributeAsInteger(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
        if (this.delegate instanceof Configurable) {
            ((Configurable)((Object)this.delegate)).configure(configuration);
        }
    }

    public Socket createSocket(String string, int n2) {
        return this.createSocketInConfiguredRange(string, n2, 0);
    }

    protected Socket doCreateSocket(String string, int n2, int n3) {
        return this.createSocketInConfiguredRange(string, n2, 0);
    }

    public boolean isSSL(Socket socket) {
        return this.delegate.isSSL(socket);
    }

    private Socket createSocketInConfiguredRange(String string, int n2, int n3) {
        for (int i2 = this.portMin; i2 <= this.portMax; ++i2) {
            try {
                Socket socket = this.createSocketOnLocalPort(string, n2, i2);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("PortRangeSSLSocketFactory: Created socket between localhost:" + i2 + " and " + string + ":" + n2);
                }
                return socket;
            }
            catch (IOException iOException) {
                this.logger.debug("couldn't open socket.", iOException);
                continue;
            }
        }
        this.logger.error("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n2);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    private Socket createSocketOnLocalPort(String string, int n2, int n3) {
        return this.delegate.createSocket(string, n2, n3, 0);
    }

    public void setKeyMaterialProvider(KeyMaterialProvider keyMaterialProvider) {
        if (this.delegate instanceof ConfigurableSSLSocketFactory) {
            ((ConfigurableSSLSocketFactory)((Object)this.delegate)).setKeyMaterialProvider(keyMaterialProvider);
        }
    }

    public void reconfigure() {
        if (this.delegate instanceof ConfigurableSSLSocketFactory) {
            ((ConfigurableSSLSocketFactory)((Object)this.delegate)).reconfigure();
        }
    }
}

