/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.cos.CosNamingME;

import com.prismtech.cos.CosNamingME.NamingContextImpl;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.config.JacORBConfiguration;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class NameServer {
    private static ORB orb = null;
    private static Logger logger;

    private static void usage() {
        System.err.println("Usage: java com.prismtech.cos.CosNamingME.NameServer [-f <ior_filename>] [-p <ns_port>]");
        System.exit(1);
    }

    public static void main(String[] args) throws ConfigurationException {
        Configuration config = JacORBConfiguration.getConfiguration(null, null, false);
        String port = null;
        String fileName = null;
        System.setProperty("jacorb.implname", "NameServiceME");
        try {
            logger = config.getNamedLogger("jacorb.naming");
            if (args.length > 4) {
                NameServer.usage();
            }
            int idx = 0;
            if (args.length > 0) {
                if (idx < args.length && args[idx].startsWith("-p")) {
                    if (idx + 1 < args.length) {
                        port = args[idx + 1];
                        ++idx;
                    } else {
                        NameServer.usage();
                    }
                } else if (idx < args.length && args[idx].startsWith("-f")) {
                    if (idx + 1 < args.length) {
                        fileName = args[idx + 1];
                        ++idx;
                    } else {
                        NameServer.usage();
                    }
                } else {
                    NameServer.usage();
                }
            }
            if (args == null) {
                args = new String[]{};
            }
            Properties props = new Properties();
            props.put("jacorb.implname", "NameServiceME");
            props.put("jacorb.orb.objectKeyMap.NameService", "NameServiceME/NameServer-POA/_root");
            if (config.getAttributeAsInteger("jacorb.connection.server.timeout", -1) < 0) {
                logger.debug("Default server.timeout to 10000");
                props.put("jacorb.connection.server.timeout", "10000");
            }
            if (port == null && (port = config.getAttribute("jacorb.naming.port", "")).length() > 0) {
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException ex) {
                    port = null;
                }
            }
            if (port != null) {
                props.put("OAPort", port);
            }
            orb = ORB.init(args, props);
            NamingContextExt nc = NameServer.init(orb);
            if (fileName == null) {
                fileName = config.getAttribute("jacorb.naming.ior");
            }
            if (fileName != null) {
                PrintWriter out = new PrintWriter(new FileOutputStream(fileName), true);
                out.println(orb.object_to_string(nc));
                out.close();
            } else {
                logger.fatalError("No NameService IOR specified in the configuration file or on the command line");
                NameServer.usage();
                System.exit(1);
            }
            if (logger.isInfoEnabled()) {
                logger.info("NameService active");
            }
            orb.run();
            orb.shutdown(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }

    public static NamingContextExt init(ORB orb) throws AdapterAlreadyExists, AdapterInactive, InvalidName, InvalidPolicy, ObjectAlreadyActive, ObjectNotActive, ServantAlreadyActive, WrongPolicy {
        NamingContextExt result = null;
        POA rootPOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        Policy[] policies = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        POA nsPOA = rootPOA.create_POA("NameServer-POA", rootPOA.the_POAManager(), policies);
        nsPOA.the_POAManager().activate();
        for (int i2 = 0; i2 < policies.length; ++i2) {
            policies[i2].destroy();
        }
        byte[] oid = "_root".getBytes();
        nsPOA.activate_object_with_id(oid, new NamingContextImpl("_root", orb, nsPOA));
        result = NamingContextExtHelper.narrow(nsPOA.id_to_reference(oid));
        return result;
    }
}

