/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.util.Collection;
import java.util.Collections;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBaseOperations;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.ETF.Profile;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public abstract class ProfileBase
extends _ProfileLocalBase
implements ProfileBaseOperations,
Cloneable,
Configurable {
    protected Version version = null;
    protected byte[] objectKey = null;
    protected TaggedComponentList components = null;
    protected org.jacorb.config.Configuration configuration;
    protected String corbalocStr = null;
    protected Logger logger;

    public void set_object_key(byte[] key) {
        this.objectKey = key;
    }

    public byte[] get_object_key() {
        return this.objectKey;
    }

    public Version version() {
        return this.version;
    }

    public abstract int tag();

    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder componentSequence) {
        TaggedComponentSeqHolder compSeq = componentSequence;
        if (this.encapsulation() != 0) {
            throw new BAD_PARAM("We can only marshal big endian style profiles !!");
        }
        CDROutputStream profileDataStream = new CDROutputStream();
        try {
            profileDataStream.beginEncapsulatedArray();
            this.writeAddressProfile(profileDataStream);
            profileDataStream.write_long(this.objectKey.length);
            profileDataStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
            switch (this.version.minor) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    int i2;
                    if (compSeq == null) {
                        compSeq = new TaggedComponentSeqHolder(new TaggedComponent[0]);
                    }
                    profileDataStream.write_long(this.components.size() + compSeq.value.length);
                    TaggedComponent[] ourTaggedProfiles = this.components.asArray();
                    for (i2 = 0; i2 < ourTaggedProfiles.length; ++i2) {
                        TaggedComponentHelper.write(profileDataStream, ourTaggedProfiles[i2]);
                    }
                    for (i2 = 0; i2 < compSeq.value.length; ++i2) {
                        TaggedComponentHelper.write(profileDataStream, compSeq.value[i2]);
                    }
                    break;
                }
                default: {
                    throw new INTERNAL("Unknown GIOP version tag " + this.version.minor + " when marshalling for IIOPProfile");
                }
            }
            tagged_profile.value = new TaggedProfile(this.tag(), profileDataStream.getBufferCopy());
        }
        finally {
            profileDataStream.close();
        }
    }

    public void demarshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        if (tagged_profile.value.tag != this.tag()) {
            throw new BAD_PARAM("Wrong tag for Transport, tag: " + tagged_profile.value.tag);
        }
        this.initFromProfileData(tagged_profile.value.profile_data);
        if (components != null) {
            components.value = this.getComponents().asArray();
        }
    }

    public short encapsulation() {
        return 0;
    }

    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int tag, Class helper) {
        return this.components.getComponent(tag, helper);
    }

    public void addComponent(int tag, Object data, Class helper) {
        this.components.addComponent(tag, data, helper);
    }

    public void addComponent(int tag, byte[] data) {
        this.components.addComponent(tag, data);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder result = new TaggedProfileHolder();
        this.marshal(result, null);
        return result.value;
    }

    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("error cloning profile: " + e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromProfileData(byte[] data) {
        CDRInputStream in = new CDRInputStream(data);
        try {
            boolean showProfileInit;
            in.openEncapsulatedArray();
            this.readAddressProfile(in);
            int length = in.read_ulong();
            if (in.available() < length) {
                throw new MARSHAL("Unable to extract object key. Only " + in.available() + " available and trying to assign " + length);
            }
            this.objectKey = new byte[length];
            in.read_octet_array(this.objectKey, 0, length);
            String val = System.getProperty("ShowProfileInit");
            boolean bl = showProfileInit = val != null && val.equals("1");
            if (showProfileInit) {
                if (this.version == null) {
                    System.out.println("JAC824: version = NULL");
                } else {
                    System.out.println("JAC824: version major = " + this.version.major);
                    System.out.println("JAC824: version minor = " + this.version.minor);
                }
            }
            TaggedComponentList taggedComponentList = this.components = this.version != null && this.version.minor > 0 ? new TaggedComponentList(in) : new TaggedComponentList();
            if (showProfileInit) {
                int componentsSize = this.components.size();
                System.out.println("JAC824: components size = " + componentsSize);
                if (componentsSize > 0) {
                    for (int i2 = 0; i2 < componentsSize; ++i2) {
                        TaggedComponent comp = this.components.get(i2);
                        System.out.println("JAC824: component " + (i2 + 1) + "/" + componentsSize + " -> tag " + comp.tag);
                    }
                }
            }
        }
        finally {
            in.close();
        }
    }

    public Collection asListenPoints() {
        return Collections.EMPTY_LIST;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)config;
    }
}

