/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;

public class PortRangeServerSocketFactory
implements ServerSocketFactory,
Configurable {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";
    private final ServerSocketFactory delegate;
    private Logger logger;
    private int portMin;
    private int portMax;

    public PortRangeServerSocketFactory(ServerSocketFactory delegate) {
        this.delegate = delegate;
    }

    public PortRangeServerSocketFactory() {
        this(new DefaultServerSocketFactory());
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)config).getNamedLogger("jacorb.orb.port_rang_fctry");
        this.portMin = this.getPortProperty(config, MIN_PROP);
        this.portMax = this.getPortProperty(config, MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (port <= this.portMax && port >= this.portMin) {
            try {
                return this.doCreateServerSocket(port, backlog);
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                return this.doCreateServerSocket(localPort, backlog);
            }
            catch (IOException ex) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int port, int backlog) throws IOException {
        ServerSocket socket = this.delegate.createServerSocket(port, backlog);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PortRangeServerSocketFactory: Created server socket at :" + port);
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (port <= this.portMax && port >= this.portMin) {
            try {
                return this.doCreateServerSocket(port, backlog, ifAddress);
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                return this.doCreateServerSocket(localPort, backlog, ifAddress);
            }
            catch (IOException ex) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int localPort, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket socket = this.delegate.createServerSocket(localPort, backlog, ifAddress);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created server socket at :" + localPort);
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws BindException {
        if (port <= this.portMax && port >= this.portMin) {
            try {
                return this.doCreateServerSocket(port);
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                return this.doCreateServerSocket(localPort);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int port) throws IOException {
        ServerSocket socket = this.delegate.createServerSocket(port);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created server socket at :" + port);
        }
        return socket;
    }

    private ServerSocket handleCreationFailed() throws BindException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    protected int getPortProperty(Configuration config, String name) throws ConfigurationException {
        int port = config.getAttributeAsInteger(name);
        if (port < 0) {
            port += 65536;
        }
        if (port <= 0 || port > 65535) {
            throw new ConfigurationException("PortRangeFactory: " + name + " invalid port number");
        }
        return port;
    }
}

