/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.naming;

import org.jacorb.orb.naming.Iiop;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class INSUtil {
    public static NameComponent[] insToComponent(String n2) throws InvalidName {
        NameComponent[] components = Iiop.getComponents(n2);
        if (components != null) {
            for (int i2 = 0; i2 < components.length; ++i2) {
                components[i2].id = INSUtil.unescapeString(components[i2].id);
                components[i2].kind = INSUtil.unescapeString(components[i2].kind);
            }
        } else {
            throw new InvalidName();
        }
        return components;
    }

    public static String componentToIns(NameComponent[] n2) throws InvalidName {
        StringBuffer str = new StringBuffer();
        if (n2 != null && n2.length != 0) {
            for (int i2 = 0; i2 < n2.length; ++i2) {
                str.append(INSUtil.convertCOStoString(n2[i2]));
                if (i2 >= n2.length - 1) continue;
                str.append('/');
            }
        } else {
            throw new InvalidName();
        }
        return str.toString();
    }

    public static NameComponent convertStringToCOS(String component) {
        NameComponent result = new NameComponent();
        StringBuffer id = new StringBuffer("");
        StringBuffer kind = new StringBuffer("");
        boolean first = true;
        char previous = '\u0000';
        for (int i2 = 0; i2 < component.length(); ++i2) {
            char current = component.charAt(i2);
            if (current == '.' && previous != '\\') {
                first = false;
            } else if (current != '\\' || current == '\\' && previous == '\\') {
                if (first) {
                    id.append(current);
                } else {
                    kind.append(current);
                }
            }
            previous = previous == current ? (char)'\u0000' : current;
        }
        result.id = id.toString();
        result.kind = kind.toString();
        return result;
    }

    public static String convertCOStoString(NameComponent n2) {
        char[] v;
        int counter = 0;
        int idlength = n2.id.length();
        int kindlength = n2.kind.length();
        if (idlength == 0 && kindlength == 0) {
            v = new char[1];
            v[counter++] = 46;
        } else {
            char current;
            int z;
            v = new char[(idlength + kindlength) * 3];
            if (idlength == 0) {
                v[counter++] = 46;
            } else {
                for (z = 0; z < idlength; ++z) {
                    current = n2.id.charAt(z);
                    switch (current) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            v[counter++] = 92;
                        }
                    }
                    v[counter++] = current;
                }
            }
            if (kindlength != 0) {
                if (idlength != 0) {
                    v[counter++] = 46;
                }
                for (z = 0; z < kindlength; ++z) {
                    current = n2.kind.charAt(z);
                    switch (current) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            v[counter++] = 92;
                        }
                    }
                    v[counter++] = current;
                }
            }
        }
        return new String(v, 0, counter);
    }

    private static String byteToHex(byte b2) {
        StringBuffer result = new StringBuffer();
        result.append(Character.forDigit(b2 >> 4 & 0xF, 16));
        result.append(Character.forDigit(b2 & 0xF, 16));
        return result.toString();
    }

    public static String encode(String name) {
        StringBuffer result = new StringBuffer();
        char[] chrs = name.toCharArray();
        for (int i2 = 0; i2 < chrs.length; ++i2) {
            if (!INSUtil.isLetterOrDigit(chrs[i2])) {
                switch (chrs[i2]) {
                    case '!': 
                    case '$': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '?': 
                    case '@': 
                    case '_': 
                    case '~': {
                        result.append(chrs[i2]);
                        break;
                    }
                    default: {
                        result.append('%');
                        result.append(INSUtil.byteToHex((byte)chrs[i2]));
                        break;
                    }
                }
                continue;
            }
            result.append(chrs[i2]);
        }
        return result.toString();
    }

    private static boolean isLetterOrDigit(char c2) {
        boolean result = false;
        if (c2 >= '0') {
            if (c2 <= '9') {
                result = true;
            } else if (c2 >= 'A') {
                if (c2 <= 'Z') {
                    result = true;
                }
                if (c2 >= 'a' && c2 <= 'z') {
                    result = true;
                }
            }
        }
        return result;
    }

    private static String unescapeString(String source) {
        StringBuffer str = new StringBuffer("");
        boolean skip = true;
        for (int z = 0; z < source.length(); ++z) {
            char currchar = source.charAt(z);
            if (currchar == '\\' && skip) {
                skip = false;
                continue;
            }
            str.append(currchar);
            skip = true;
        }
        return str.toString();
    }
}

