/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.portableInterceptor.IORInfoExt;
import org.jacorb.poa.POA;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponent;

public class IORInfoImpl
extends LocalObject
implements IORInfoExt {
    private final Map components;
    private final Map policy_overrides;
    private final ORB orb;
    private final POA poa;
    private final List _profiles;

    public IORInfoImpl(ORB orb, POA poa, Map components, Map policy_overrides, List profiles) {
        this.orb = orb;
        this.poa = poa;
        this.components = components;
        this.policy_overrides = policy_overrides;
        this._profiles = profiles;
    }

    public void add_ior_component(TaggedComponent component) {
        Iterator i2 = this.components.values().iterator();
        while (i2.hasNext()) {
            TaggedComponentList list = (TaggedComponentList)i2.next();
            list.addComponent(component);
        }
    }

    public void add_ior_component_to_profile(TaggedComponent component, int id) {
        TaggedComponentList list = (TaggedComponentList)this.components.get(ObjectUtil.newInteger(id));
        if (list == null) {
            throw new BAD_PARAM("unknown profile tag: " + id, 29, CompletionStatus.COMPLETED_MAYBE);
        }
        list.addComponent(component);
    }

    public Policy get_effective_policy(int type) {
        if (!this.orb.hasPolicyFactoryForType(type)) {
            throw new INV_POLICY("No PolicyFactory for type " + type + " has been registered!", 3, CompletionStatus.COMPLETED_MAYBE);
        }
        Policy policy = null;
        if (this.policy_overrides != null) {
            policy = (Policy)this.policy_overrides.get(ObjectUtil.newInteger(type));
        }
        return policy != null ? policy : this.poa.getPolicy(type);
    }

    public void add_profile(Profile profile) {
        if (this._profiles != null) {
            this._profiles.add(profile);
        }
    }

    public int get_number_of_profiles(int tag) {
        int retVal = 0;
        for (int i2 = 0; i2 < this._profiles.size(); ++i2) {
            Profile p2 = (Profile)this._profiles.get(i2);
            if (p2.tag() != tag) continue;
            ++retVal;
        }
        return retVal;
    }

    public Profile get_profile(int tag, int position) {
        int cnt = position;
        Profile result = null;
        for (int i2 = 0; i2 < this._profiles.size(); ++i2) {
            Profile profile = (Profile)this._profiles.get(i2);
            if (profile.tag() == tag && cnt == 0) {
                result = profile;
                break;
            }
            --cnt;
        }
        if (result == null) {
            throw new ArrayIndexOutOfBoundsException("no profile with tag=" + tag + " at position" + position);
        }
        return result;
    }

    public Profile get_profile(int tag) {
        Profile result = null;
        for (int i2 = 0; i2 < this._profiles.size(); ++i2) {
            Profile profile = (Profile)this._profiles.get(i2);
            if (profile.tag() != tag) continue;
            result = profile;
            break;
        }
        return result;
    }
}

