/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestAnalyser;
import org.jacorb.poa.RequestAnalyserProcessor;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.RequestQueue;
import org.jacorb.poa.except.CompletionRequestedException;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.except.ShutdownInProgressException;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.JDK14StackTraceHelper;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;

public final class RequestController
extends Thread
implements Configurable {
    private final POA poa;
    private final ORB orb;
    private final RequestQueue requestQueue;
    private final AOM aom;
    private final RPPoolManager poolManager;
    private int localRequests = 0;
    private static int count = 0;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger;
    private final HashSet activeRequestTable;
    private final HashSet deactivationList = new HashSet();
    private boolean terminate;
    private boolean waitForCompletionCalled;
    private boolean waitForShutdownCalled;
    private final Object queueLog = new Object();
    private int threadPriority = 10;
    private static RequestAnalyserProcessor analyserProcessor;
    private static RequestAnalyser requestAnalyser;
    private boolean requestAnalyserEnabled = false;
    private boolean checkRequestIDs = false;

    RequestController(POA _poa, ORB _orb, AOM _aom, RPPoolManager _poolManager) {
        super("RequestController-" + ++count);
        this.poa = _poa;
        this.aom = _aom;
        this.orb = _orb;
        this.requestQueue = new RequestQueue();
        this.poolManager = _poolManager;
        int threadPoolMax = _orb.getConfiguration().getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
        this.activeRequestTable = this.poa.isSingleThreadModel() ? new HashSet(1) : new HashSet(threadPoolMax);
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa.controller");
        this.requestQueue.configure(myConfiguration);
        this.threadPriority = this.configuration.getAttributeAsInteger("jacorb.poa.thread_priority", 10);
        this.requestAnalyserEnabled = this.configuration.isAttributeSet("jacorb.poa.requestanalyser");
        this.checkRequestIDs = this.configuration.getAttributeAsBoolean("jacorb.poa.checkRequestIDs", false);
        if (this.threadPriority < 1) {
            this.threadPriority = 1;
        } else if (this.threadPriority > 10) {
            this.threadPriority = 10;
        }
        this.setPriority(this.threadPriority);
        this.setDaemon(true);
        this.start();
        if (this.requestAnalyserEnabled) {
            analyserProcessor = (RequestAnalyserProcessor)this.configuration.getAttributeAsObject("jacorb.poa.requestanalyserprocessor");
            if (analyserProcessor != null) {
                analyserProcessor.configure(this.configuration);
            }
            requestAnalyser = (RequestAnalyser)this.configuration.getAttributeAsObject("jacorb.poa.requestanalyser");
            if (this.logger.isDebugEnabled()) {
                if (analyserProcessor != null) {
                    this.logger.debug("Using RequestAnalyserProcessor: " + analyserProcessor.getClass().getName());
                }
                if (requestAnalyser != null) {
                    this.logger.debug("Using RequestAnalyser: " + requestAnalyser.getClass().getName());
                }
            }
        }
    }

    void clearUpPool() {
        this.poolManager.destroy();
    }

    void clearUpQueue(SystemException exception) {
        ServerRequest request;
        while ((request = this.requestQueue.removeLast()) != null) {
            this.rejectRequest(request, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueToWork() {
        Object object = this.queueLog;
        synchronized (object) {
            this.queueLog.notifyAll();
        }
    }

    synchronized void end() {
        this.terminate = true;
        if (analyserProcessor != null) {
            analyserProcessor.shutdown();
        }
        this.continueToWork();
    }

    synchronized void freeObject(ByteArrayKey oid) {
        this.deactivationList.remove(oid);
    }

    AOM getAOM() {
        return this.aom;
    }

    Logger getLogger() {
        return this.logger;
    }

    ORB getORB() {
        return this.orb;
    }

    POA getPOA() {
        return this.poa;
    }

    RPPoolManager getPoolManager() {
        return this.poolManager;
    }

    RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    synchronized boolean isDeactivating(ByteArrayKey oid) {
        return this.deactivationList.contains(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(ServerRequest request) throws ShutdownInProgressException, CompletionRequestedException {
        Servant servant = null;
        ServantManager servantManager = null;
        boolean invalid = false;
        ByteArrayKey oid = request.objectIdAsByteArrayKey();
        RequestController requestController = this;
        synchronized (requestController) {
            if (this.waitForCompletionCalled) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request because waitForCompletion was called");
                }
                throw new CompletionRequestedException();
            }
            if (this.waitForShutdownCalled) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request because POA shutdown in progress");
                }
                throw new ShutdownInProgressException();
            }
            if (this.aom != null && this.aom.isDeactivating(oid) || this.deactivationList.contains(oid)) {
                if (!this.poa.isUseServantManager() && !this.poa.isUseDefaultServant()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request, because object is already in the deactivation process");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
                invalid = true;
            }
            if (!invalid && this.poa.isRetain()) {
                servant = this.aom.getServant(oid);
            }
            if (servant == null) {
                if (this.poa.isUseDefaultServant()) {
                    servant = this.poa.defaultServant;
                    if (servant == null) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request because default servant is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else if (this.poa.isUseServantManager()) {
                    servantManager = this.poa.servantManager;
                    if (servantManager == null) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request because servant manager is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("rid: " + request.requestId() + " opname: " + request.operation() + " cannot process request, because object doesn't exist");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
            }
            this.activeRequestTable.add(oid);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + request.requestId() + " opname: " + request.operation() + " trying to get a RequestProcessor" + ", oid: " + POAUtil.convert(oid.getBytes()));
        }
        if (this.requestAnalyserEnabled && requestAnalyser != null) {
            requestAnalyser.analyse(request);
        }
        if (this.checkRequestIDs && request.getAnalyser() >= 1) {
            request.getConnection().addOutstandingRequest(request.requestId());
        }
        if (analyserProcessor != null && analyserProcessor.verify(request)) {
            analyserProcessor.process(new RequestAnalyserProcessor.ProcessorArgs(this, request, servant, servantManager));
        } else {
            RequestProcessor processor = this.getPoolManager().getProcessor(false);
            processor.init(this, request, servant, servantManager);
            processor.begin();
        }
    }

    void queueRequest(ServerRequest request) throws ResourceLimitReachedException {
        this.requestQueue.add(request);
        if (this.requestQueue.size() == 1) {
            this.continueToWork();
        }
    }

    void rejectRequest(ServerRequest request, SystemException exception) {
        if (exception != null) {
            request.setSystemException(exception);
        }
        this.orb.getBasicAdapter().return_result(request);
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("rid: " + request.requestId() + " opname: " + request.operation() + " request rejected with exception: " + exception.getMessage());
        }
    }

    synchronized void resetPreviousCompletionCall() {
        this.logger.debug("reset a previous completion call");
        this.waitForCompletionCalled = false;
        this.notifyAll();
    }

    void returnResult(ServerRequest request) {
        this.orb.getBasicAdapter().return_result(request);
    }

    synchronized void finish(ServerRequest request) {
        ByteArrayKey oid = request.objectIdAsByteArrayKey();
        this.activeRequestTable.remove(oid);
        this.notifyAll();
    }

    public void run() {
        OBJ_ADAPTER closed_connection_exception = new OBJ_ADAPTER("connection closed: adapter inactive");
        TRANSIENT transient_exception = new TRANSIENT();
        while (!this.terminate) {
            ServerRequest request;
            State state = this.poa.the_POAManager().get_state();
            if (POAUtil.isActive(state)) {
                request = this.requestQueue.getFirst();
                if (request != null) {
                    if (request.remainingPOAName() != null) {
                        this.orb.getBasicAdapter().deliverRequest(request, this.poa);
                        this.requestQueue.removeFirst();
                        continue;
                    }
                    try {
                        this.processRequest(request);
                        this.requestQueue.removeFirst();
                    }
                    catch (CompletionRequestedException e2) {
                    }
                    catch (ShutdownInProgressException e3) {
                        this.waitForQueue();
                    }
                    catch (OBJ_ADAPTER e4) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(request, e4);
                    }
                    catch (OBJECT_NOT_EXIST e5) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(request, e5);
                    }
                    continue;
                }
            } else if (!this.waitForShutdownCalled && (POAUtil.isDiscarding(state) || POAUtil.isInactive(state)) && (request = this.requestQueue.removeLast()) != null) {
                if (POAUtil.isDiscarding(state)) {
                    this.rejectRequest(request, transient_exception);
                    continue;
                }
                this.rejectRequest(request, closed_connection_exception);
                continue;
            }
            this.waitForQueue();
        }
    }

    synchronized void waitForCompletion() {
        this.waitForCompletionCalled = true;
        while (this.waitForCompletionCalled && !this.activeRequestTable.isEmpty()) {
            try {
                this.logger.debug("somebody waits for completion and there are active processors");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void waitForObjectCompletion(ByteArrayKey oid) {
        while (this.activeRequestTable.contains(oid)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(POAUtil.convert(oid.getBytes()) + "all active processors for this object have finished");
        }
        this.deactivationList.add(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueue() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("waiting for queue");
        }
        Object object = this.queueLog;
        synchronized (object) {
            while ((this.requestQueue.isEmpty() || POAUtil.isHolding(this.poa.the_POAManager().get_state()) || this.waitForShutdownCalled) && !this.terminate) {
                try {
                    this.queueLog.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    synchronized void waitForShutdown() {
        this.waitForShutdownCalled = true;
        while (this.waitForShutdownCalled && !this.activeRequestTable.isEmpty() || this.localRequests != 0) {
            try {
                if (this.logger.isDebugEnabled()) {
                    String poaName = this.poa._getQualifiedName();
                    if ("".equals(poaName)) {
                        poaName = "RootPOA";
                    }
                    int k2 = 0;
                    Iterator it = this.activeRequestTable.iterator();
                    StringBuffer activeRequestOID = new StringBuffer();
                    while (it.hasNext()) {
                        activeRequestOID.append("oid" + ++k2 + '<');
                        byte[] b2 = ((ByteArrayKey)it.next()).getBytes();
                        for (int j2 = 0; j2 < b2.length; ++j2) {
                            activeRequestOID.append(POAUtil.toHex(b2[j2]));
                        }
                        activeRequestOID.append('>');
                    }
                    this.logger.debug("somebody waits for shutdown and there are active processors, POA name=" + poaName + ", POA isSingleThreadModel=" + (this.poa.isSingleThreadModel() ? "yes" : "no") + ", localRequests=" + this.localRequests + ", activeRequestTable size=" + this.activeRequestTable.size() + ", oid still in activeRequestTable: " + activeRequestOID.toString() + ", Thread name=" + Thread.currentThread().getName() + ", " + JDK14StackTraceHelper.stackTraceElementArrayToString(new Throwable().getStackTrace()));
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void addLocalRequest() {
        ++this.localRequests;
    }

    synchronized void removeLocalRequest() {
        --this.localRequests;
        this.notifyAll();
    }
}

