/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.security.launcher.LauncherInstallerInterface;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.launcher.cache.StubbedVerifyListener;
import se.ericsson.security.launcher.download.StubbedDownloadListener;
import se.ericsson.security.launcher.parser.ConfigurationAccess;
import se.ericsson.security.launcher.parser.ConfigurationAccessFactory;
import se.ericsson.security.launcher.parser.EmApplicationFile;
import se.ericsson.security.launcher.parser.EmApplicationSee;
import se.ericsson.security.launcher.parser.ParserException;
import se.ericsson.security.launcher.parser.ParserInputEmptyException;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledApplications
implements LauncherInstallerInterface {
    private static final EmLogger LOG = EmLogger.LAUNCHER;

    private void insertPath(String cacheDir, String prodNr, String revision, String fileName, Collection<String> files, Collection<String> fileNames) {
        String separator = System.getProperty("file.separator");
        String fileNamePath = cacheDir + separator + prodNr + separator + revision + separator + fileName;
        String fileRevisionPath = cacheDir + separator + prodNr + separator + revision;
        if (!files.contains(fileNamePath)) {
            files.add(fileNamePath);
            fileNames.add(fileName);
        }
        if (!files.contains(fileRevisionPath)) {
            files.add(fileRevisionPath);
        }
    }

    private String contentOfFile(String fileName) {
        StringBuffer wholeContent = new StringBuffer();
        try {
            int read;
            FileInputStream fis = new FileInputStream(fileName);
            byte[] buffer = new byte[1024];
            while ((read = fis.read(buffer)) != -1) {
                wholeContent.append(new String(buffer, 0, read));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        String toRet = wholeContent.toString();
        return toRet;
    }

    @Override
    public String[] getCachedFiles(String productNumber) {
        String jarFileProdNrPath;
        String[] jarFileRevisions;
        File prodDir;
        String prodNr;
        ConfigurationAccess confAccess;
        String fileName;
        PropertyManager pm = PropertyManager.getInstance(this.getClass().getClassLoader());
        Cache cache = new Cache(new StubbedDownloadListener(), new StubbedVerifyListener(), pm);
        String cacheDir = pm.getString("se.ericsson.security.launcher.cachedirname", true);
        String separator = System.getProperty("file.separator");
        File theRoot = new File(cacheDir + separator + productNumber);
        String[] configFileRevisions = theRoot.list();
        if (configFileRevisions == null) {
            return new String[0];
        }
        Hashtable<String, String> filesDescribedInAllParsedConfigFiles = new Hashtable<String, String>();
        Vector<String> files = new Vector<String>();
        HashSet<String> fileNames = new HashSet<String>();
        for (String configFileRevision : configFileRevisions) {
            LOG.fine("Found revision: " + configFileRevision, new Object[0]);
            fileName = cache.getConfigurationFileName(productNumber, configFileRevision);
            if (fileName == null) continue;
            confAccess = ConfigurationAccessFactory.getConfigurationAccess();
            try {
                confAccess.setFileContent(this.contentOfFile(fileName));
            }
            catch (ParserInputEmptyException e) {
                // empty catch block
            }
            Collection<EmApplicationFile> filesComplete = null;
            try {
                filesComplete = confAccess.getEmApplicationFile();
            }
            catch (ParserException pe) {
                // empty catch block
            }
            if (filesComplete == null) continue;
            for (EmApplicationFile emApplicationFile : filesComplete) {
                prodNr = emApplicationFile.getFileProdNo();
                if (prodNr == null) {
                    System.out.println("prod nr is null!!!");
                }
                prodNr = prodNr.trim().replaceAll(" ", "");
                prodDir = new File(cacheDir + separator + prodNr);
                jarFileRevisions = prodDir.list();
                if (jarFileRevisions != null) {
                    for (int j = 0; j < jarFileRevisions.length; ++j) {
                        this.insertPath(cacheDir, prodNr, jarFileRevisions[j], emApplicationFile.getFileName(), files, fileNames);
                    }
                }
                if (files.contains(jarFileProdNrPath = cacheDir + separator + prodNr)) continue;
                files.add(jarFileProdNrPath);
            }
        }
        for (String configFileRevision : configFileRevisions) {
            LOG.fine("Found revision: " + configFileRevision, new Object[0]);
            fileName = cache.getConfigurationFileName(productNumber, configFileRevision);
            if (fileName == null) continue;
            confAccess = ConfigurationAccessFactory.getConfigurationAccess();
            try {
                confAccess.setFileContent(this.contentOfFile(fileName));
            }
            catch (ParserInputEmptyException e) {
                // empty catch block
            }
            Collection<EmApplicationSee> filesReference = null;
            try {
                filesReference = confAccess.getEmApplicationSee();
            }
            catch (ParserException pe) {
                // empty catch block
            }
            if (filesReference == null) continue;
            for (EmApplicationSee emApplicationSee : filesReference) {
                ProdNrPlusFilesDescribedOnPath theInfo;
                if (fileNames.contains(emApplicationSee.getRefName())) continue;
                prodNr = (String)filesDescribedInAllParsedConfigFiles.get(emApplicationSee.getRefName());
                if (prodNr == null && (theInfo = this.searchLeafConfigFile(emApplicationSee.getFileName(), emApplicationSee.getRefName(), cacheDir, filesDescribedInAllParsedConfigFiles)) != null) {
                    filesDescribedInAllParsedConfigFiles.putAll(theInfo.getFiles());
                    prodNr = theInfo.getProdNr();
                }
                if (prodNr == null) continue;
                prodNr = prodNr.trim().replaceAll(" ", "");
                prodDir = new File(cacheDir + separator + prodNr);
                jarFileRevisions = prodDir.list();
                if (jarFileRevisions != null) {
                    for (int j = 0; j < jarFileRevisions.length; ++j) {
                        this.insertPath(cacheDir, prodNr, jarFileRevisions[j], emApplicationSee.getRefName(), files, fileNames);
                    }
                }
                if (files.contains(jarFileProdNrPath = cacheDir + separator + prodNr)) continue;
                files.add(jarFileProdNrPath);
            }
        }
        return files.toArray(new String[0]);
    }

    @Override
    public String[] getCachedConfigFiles(String productNumber) {
        PropertyManager pm = PropertyManager.getInstance(this.getClass().getClassLoader());
        Cache cache = new Cache(new StubbedDownloadListener(), new StubbedVerifyListener(), pm);
        String cacheDir = pm.getString("se.ericsson.security.launcher.cachedirname", true);
        String separator = System.getProperty("file.separator");
        String prodNrDirName = cacheDir + separator + productNumber;
        File theRoot = new File(prodNrDirName);
        Vector<String> files = new Vector<String>();
        String[] configFileRevisions = theRoot.list();
        if (configFileRevisions != null) {
            for (int i = 0; i < configFileRevisions.length; ++i) {
                LOG.fine("Found revision: " + configFileRevisions[i], new Object[0]);
                String fileName = cache.getConfigurationFileName(productNumber, configFileRevisions[i]);
                if (fileName == null) continue;
                File c_file = new File(fileName);
                files.add(fileName);
                files.add(c_file.getParentFile().getAbsolutePath());
                this.getAllReferredConfigFiles(fileName, files, cacheDir);
            }
            files.add(prodNrDirName);
        }
        return files.toArray(new String[0]);
    }

    private void getAllReferredConfigFiles(String configFileName, Vector<String> paths, String cacheDir) {
        ConfigurationAccess confAccess = ConfigurationAccessFactory.getConfigurationAccess();
        try {
            confAccess.setFileContent(this.contentOfFile(configFileName));
        }
        catch (ParserInputEmptyException e) {
            // empty catch block
        }
        Collection<EmApplicationSee> filesReferenced = null;
        try {
            filesReferenced = confAccess.getEmApplicationSee();
        }
        catch (ParserException pe) {
            // empty catch block
        }
        if (filesReferenced != null) {
            for (EmApplicationSee emApplicationSee : filesReferenced) {
                String configFileN = emApplicationSee.getFileName();
                String[] configFilePathsS = this.locateConfigFiles(configFileN, cacheDir);
                if (configFilePathsS.length == 0 || paths.contains(configFilePathsS[0])) continue;
                File c_file = new File(configFilePathsS[0]);
                String configFileProdNrDir = c_file.getParentFile().getParentFile().getAbsolutePath();
                for (int i = 0; i < configFilePathsS.length; ++i) {
                    c_file = new File(configFilePathsS[i]);
                    paths.add(configFilePathsS[i]);
                    paths.add(c_file.getParentFile().getAbsolutePath());
                    this.getAllReferredConfigFiles(configFilePathsS[i], paths, cacheDir);
                }
                paths.add(configFileProdNrDir);
            }
        }
    }

    private ProdNrPlusFilesDescribedOnPath searchLeafConfigFile(String name, String jarName, String cacheDir, Hashtable<String, String> filesDescribedInConfigFiles) {
        Iterator<Object> iter;
        ConfigurationAccess confAccess;
        String[] configFilePaths = this.locateConfigFiles(name, cacheDir);
        String productNrToReturn = "";
        Hashtable<String, String> filesInTheseConfigFiles = new Hashtable<String, String>();
        boolean found = false;
        for (String configFilePath : configFilePaths) {
            confAccess = ConfigurationAccessFactory.getConfigurationAccess();
            try {
                confAccess.setFileContent(this.contentOfFile(configFilePath));
            }
            catch (ParserInputEmptyException pe) {
                // empty catch block
            }
            Collection<EmApplicationFile> filesComplete = null;
            try {
                filesComplete = confAccess.getEmApplicationFile();
            }
            catch (ParserException pe) {
                // empty catch block
            }
            if (filesComplete != null) {
                iter = filesComplete.iterator();
                found = false;
                while (iter.hasNext()) {
                    EmApplicationFile emApplicationFile = iter.next();
                    if (emApplicationFile.getFileName().equals(jarName)) {
                        found = true;
                        productNrToReturn = emApplicationFile.getFileProdNo();
                    }
                    filesInTheseConfigFiles.put(emApplicationFile.getFileName(), emApplicationFile.getFileProdNo());
                }
                filesInTheseConfigFiles.putAll(filesDescribedInConfigFiles);
            }
            if (found) break;
        }
        if (found) {
            return new ProdNrPlusFilesDescribedOnPath(productNrToReturn, filesInTheseConfigFiles);
        }
        for (String configFilePath : configFilePaths) {
            confAccess = ConfigurationAccessFactory.getConfigurationAccess();
            try {
                confAccess.setFileContent(this.contentOfFile(configFilePath));
            }
            catch (ParserInputEmptyException pe) {
                // empty catch block
            }
            Collection<EmApplicationSee> filesReferenced = null;
            try {
                filesReferenced = confAccess.getEmApplicationSee();
            }
            catch (ParserException pe) {
                // empty catch block
            }
            if (filesReferenced == null) continue;
            iter = filesReferenced.iterator();
            found = false;
            while (iter.hasNext()) {
                EmApplicationSee emApplicationSee = (EmApplicationSee)iter.next();
                if (!emApplicationSee.getRefName().equals(jarName)) continue;
                return this.searchLeafConfigFile(emApplicationSee.getFileName(), jarName, cacheDir, filesInTheseConfigFiles);
            }
        }
        return null;
    }

    private String[] locateConfigFiles(String name, String startPoint) {
        File c_file = new File(startPoint);
        String[] files = c_file.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String path = startPoint + System.getProperty("file.separator") + files[i];
                String[] filePath = this.locateConfigFiles(name, path);
                if (filePath.length == 0) continue;
                return filePath;
            }
        } else {
            if (c_file.getName().equals(name)) {
                String separator = System.getProperty("file.separator");
                File prodNrDirectory = c_file.getParentFile().getParentFile();
                String[] xmlFileRevisions = prodNrDirectory.list();
                if (xmlFileRevisions != null) {
                    String[] filePath = new String[xmlFileRevisions.length];
                    for (int i = 0; i < xmlFileRevisions.length; ++i) {
                        filePath[i] = prodNrDirectory.getAbsolutePath();
                        if (!filePath[i].endsWith(separator)) {
                            int n = i;
                            filePath[n] = filePath[n] + separator;
                        }
                        int n = i;
                        filePath[n] = filePath[n] + xmlFileRevisions[i] + separator + name;
                    }
                    return filePath;
                }
                return new String[0];
            }
            return new String[0];
        }
        return new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProdNrPlusFilesDescribedOnPath {
        String prodNr;
        Hashtable<String, String> files;

        ProdNrPlusFilesDescribedOnPath(String prodNr, Hashtable<String, String> files) {
            this.prodNr = prodNr;
            this.files = files;
        }

        Hashtable<String, String> getFiles() {
            return this.files;
        }

        String getProdNr() {
            return this.prodNr;
        }
    }
}

