/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import se.ericsson.security.launcher.ApplicationCacheInterface;
import se.ericsson.security.launcher.ApplicationClassLoader;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ApplicationFactory;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.ConfigurationException;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.ExceptionHandlerInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.LauncherObservable;
import se.ericsson.security.launcher.MetaLauncher;
import se.ericsson.security.launcher.MetaLauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.ReusableLaunchable;
import se.ericsson.security.launcher.Revision;
import se.ericsson.security.launcher.SecurityConfiguration;
import se.ericsson.security.launcher.SecurityException;
import se.ericsson.security.launcher.SecurityState;
import se.ericsson.security.launcher.VersionException;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedApplication;
import se.ericsson.security.launcher.cache.CachedJarFile;
import se.ericsson.security.launcher.cache.StubbedVerifyListener;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.SimpleDownloadListener;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationService;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.ui.SplashWindow;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.launcher.util.PropertyConstants;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.launcher.util.UrlUtilities;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.starter.investigator.EmApplicationInfoFactory;
import se.ericsson.security.starter.investigator.NodeTypeInvestigator;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher
implements VersionedLauncherInterface,
EmNotificationServiceInterface,
LauncherInterface.RevLATEST {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private static final String POA_CALLBACK_ADDRESS = "OAIAddr";
    private static final String CHMOD_CMD_DIR = "chmod 775 ";
    private static final String CHMOD_CMD_FILE = "chmod a+r ";
    private static final String NEX_CONFIG = "nexcfg.xml";
    private PropertyManager pm;
    private HashMap<Launchable, ApplicationConfiguration> applicationConfigurations;
    private HashMap<Launchable, ApplicationConfiguration> resourceConfigurations;
    private MetaLauncherInterface metaLauncher = null;
    private String manifestVersion = "";
    private String manifestCxc = "";
    private ApplicationClassLoader securityClassLoader = null;
    SplashWindow splashWindow = null;
    private ErrorDialog errorDialog = null;
    private Object theLoginContext = null;
    private Method theLoginMethod = null;
    private boolean prepareSecurityFirstTime = true;
    private LauncherObservable launcherObservable;
    private Map<URL, URL> applicationMappings;
    private EmNotificationService emNotificationService = new EmNotificationService();

    Launcher() {
        this.pm = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.applicationConfigurations = new HashMap();
        this.resourceConfigurations = new HashMap();
        this.launcherObservable = new LauncherObservable();
        this.setProductAndVersion();
        this.chmodMe();
        this.applicationMappings = new HashMap<URL, URL>();
    }

    @Override
    public synchronized boolean runsApp(Launchable app) {
        return this.applicationConfigurations.containsKey(app);
    }

    @Override
    public URL getNEAddress(Launchable app) {
        ApplicationConfiguration ac = this.getApplOrResourceConfiguration(app);
        if (ac == null) {
            return null;
        }
        return ac.getNEAddress();
    }

    public static Launcher getInstance(ClassLoader cl) {
        try {
            Class<?> c = cl.loadClass("se.ericsson.security.launcher.Launcher");
            return (Launcher)c.newInstance();
        }
        catch (Exception e) {
            LOG.warning(e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public void setMetaLauncher(MetaLauncherInterface ml) {
        LOG.fine("setMetaLauncher called; version=" + this.getVersion(), new Object[0]);
        this.metaLauncher = ml;
    }

    void putApplicationconfiguration(Launchable application, ApplicationCacheInterface ac, boolean isApplication) {
        if (isApplication) {
            this.applicationConfigurations.put(application, (ApplicationConfiguration)ac);
        } else {
            this.resourceConfigurations.put(application, (ApplicationConfiguration)ac);
        }
    }

    private void notifyObservable(ApplicationCacheInterface ac) {
        this.launcherObservable.notifyObservers(ac);
    }

    @Override
    public void addObserver(Observer observer) {
        this.launcherObservable.addObserver(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.launcherObservable.deleteObserver(observer);
    }

    private synchronized ApplicationConfiguration removeApplicationconfiguration(Launchable application) {
        return this.applicationConfigurations.remove(application);
    }

    private synchronized ApplicationConfiguration getApplOrResourceConfiguration(Launchable resource) {
        if (resource == null) {
            return null;
        }
        ApplicationConfiguration ac = this.applicationConfigurations.get(resource);
        if (ac == null) {
            ac = this.resourceConfigurations.get(resource);
        }
        return ac;
    }

    private synchronized Launchable runApplicationOrResource(String path, String hostname, Properties arguments, Launchable parentRef, HashMap<Launchable, ApplicationConfiguration> appOrResList) throws LauncherException {
        CachedApplication[] cachedApplication;
        ApplicationConfiguration applicationConfiguration;
        LOG.fine("In runApplicationOrResource. hostname: " + hostname, new Object[0]);
        LOG.fine("path: " + path, new Object[0]);
        LOG.fine("arguments: " + arguments, new Object[0]);
        EProps ep = new EProps();
        ep.put(EKEY.HOSTNAME, hostname);
        ep.put(EKEY.JAVA_METHOD, "Launcher.runApplicationOrResource");
        ep.append(EKEY.JAVA_METHOD, "path        = " + path);
        ep.append(EKEY.JAVA_METHOD, "hostname    = " + hostname);
        ep.append(EKEY.JAVA_METHOD, "arguments   = " + arguments);
        ep.append(EKEY.JAVA_METHOD, "parentRef   = " + parentRef);
        ep.append(EKEY.JAVA_METHOD, "this.launcher = " + this);
        ep.append(EKEY.JAVA_METHOD, "classloader   = " + this.getClass().getClassLoader());
        ep.append(EKEY.JAVA_METHOD, "cl.parent     = " + this.getClass().getClassLoader().getParent());
        if (path == null || path.equals("")) {
            LauncherException ne = Launcher.createLauncherException("Missing path to the application", ep, null);
            if (parentRef == null) {
                this.errorDialog = new ErrorDialog(Localizer.getString("missing_path_to_app") + " - " + Localizer.getString("application_cannot_start"), ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        if (arguments.getProperty("hostname") == null) {
            arguments.setProperty("hostname", hostname);
        }
        ClassLoader parentClassLoader = parentRef != null ? parentRef.getClass().getClassLoader() : this.getClass().getClassLoader();
        LOG.fine("Will create url from: " + hostname + path, new Object[0]);
        String protocol = arguments.getProperty("protocol", "");
        String port = arguments.getProperty("httpPort", "");
        URL url = UrlUtilities.getURL(protocol, hostname, port, path);
        if (url == null) {
            ConfigurationException ne = new ConfigurationException("Invalid NE address", ep);
            if (parentRef == null) {
                String msg = Localizer.getString("inv_ne_address") + " " + hostname + path + " - " + Localizer.getString("application_cannot_start");
                this.errorDialog = new ErrorDialog(msg, ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        if ("".equals(protocol)) {
            arguments.setProperty("protocol", url.getProtocol());
        }
        ep.append(EKEY.JAVA_INFO, "\nURL         = " + url);
        LOG.info("Launcher constructed url: " + url.toString(), new Object[0]);
        arguments.setProperty("address", url.getHost());
        arguments.setProperty("httpPort", Integer.toString(url.getPort()));
        this.setupNexEmMapping(path, url);
        Launchable app = this.findRunningAppOrResource(url, appOrResList);
        ep.append(EKEY.JAVA_INFO, "app         = " + app);
        if (app != null) {
            LOG.fine("Reusing an existing application/resource instance", new Object[0]);
            ReusableLaunchable reuseApp = app;
            reuseApp.reuse(hostname, arguments, this, parentRef);
            return app;
        }
        this.openSplash();
        Cache cache = new Cache(this.splashWindow.getDownloadListener(), this.splashWindow.getVerifyListener(), this.pm);
        String displayName = "";
        if (Boolean.getBoolean("se.ericsson.security.onapplicationserver")) {
            String prop = System.getProperty("se.ericsson.security.launcher.origAppName");
            if (prop == null || prop.equals("")) {
                System.setProperty("se.ericsson.security.launcher.origAppName", System.getProperty("se.ericsson.security.display_name"));
            }
            if ((prop = System.getProperty("se.ericsson.security.launcher.applIndex")) == null || prop.equals("")) {
                System.setProperty("se.ericsson.security.launcher.applIndex", "0");
            }
            displayName = System.getProperty("se.ericsson.security.launcher.origAppName") + System.getProperty("se.ericsson.security.launcher.applIndex");
        }
        ep.append(EKEY.JAVA_INFO, "displayName = " + displayName);
        try {
            LOG.fine("new ApplicationConfiguration(url...", new Object[0]);
            LOG.fine("url: " + url.toString(), new Object[0]);
            LOG.fine("displayName: " + displayName, new Object[0]);
            applicationConfiguration = new ApplicationConfiguration(url, cache, displayName);
        }
        catch (ConfigurationException e) {
            this.closeSplash();
            LauncherException ne = Launcher.createLauncherException("A configuration exception occurred " + e.getMessage(), ep, e);
            if (parentRef == null) {
                String msg = e.getMessage() + " - " + Localizer.getString("application_cannot_start");
                this.errorDialog = new ErrorDialog(msg, ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        String requiredRev = applicationConfiguration.getLauncherFile().getRevision();
        String requiredLauncherCxc = applicationConfiguration.getLauncherFile().getProductNumber();
        if (requiredRev == null || requiredRev.equals("")) {
            LOG.info("No required EM Launcher version was specified, continuing with current launcher.", new Object[0]);
        } else {
            LOG.info("Required EM Launcher: " + requiredLauncherCxc + " " + requiredRev, new Object[0]);
        }
        if (System.getProperty(POA_CALLBACK_ADDRESS) == null || System.getProperty(POA_CALLBACK_ADDRESS).equals("")) {
            this.setCallBackAddress(url.getHost(), url.getPort());
        }
        if (applicationConfiguration.getSecuritystate().isSecurityEnabled()) {
            LOG.fine("CORBA Security=ON", new Object[0]);
            if (Boolean.getBoolean("se.ericsson.security.onapplicationserver")) {
                System.setProperty("se.ericsson.security.display_name", System.getProperty("se.ericsson.security.launcher.origAppName") + System.getProperty("se.ericsson.security.launcher.applIndex"));
                System.setProperty("se.ericsson.security.launcher.applIndex", Integer.toString(Integer.parseInt(System.getProperty("se.ericsson.security.launcher.applIndex")) + 1));
            }
            try {
                this.prepareForSecurity(cache, applicationConfiguration, parentClassLoader);
            }
            catch (LauncherException e) {
                this.closeSplash();
                LauncherException ne = Launcher.createLauncherException("Failed preparting application for security!", ep, e);
                if (parentRef == null) {
                    this.errorDialog = new ErrorDialog(Localizer.getString("could_not_prepare_security") + " - " + Localizer.getString("application_cannot_start"), ne);
                    this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
                }
                throw ne;
            }
        } else {
            LOG.fine("CORBA Security=OFF", new Object[0]);
        }
        try {
            cachedApplication = cache.prepareApplication(applicationConfiguration);
        }
        catch (CacheException e) {
            this.closeSplash();
            LauncherException ne = Launcher.createLauncherException("Failed to start application!", ep, e);
            String message = e.getMessage();
            if (parentRef == null) {
                this.errorDialog = new ErrorDialog(message + " - " + Localizer.getString("application_cannot_start"), ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        catch (Exception e) {
            this.closeSplash();
            LauncherException ne = Launcher.createLauncherException("An unexpected exception occurred " + e.getClass().getName() + " " + e.getMessage(), ep, e);
            if (parentRef == null) {
                this.errorDialog = new ErrorDialog(e.getMessage() + " - " + Localizer.getString("application_cannot_start"), ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        arguments.setProperty("CUSTOM_APPL_NAME", applicationConfiguration.getApplicationName());
        ep.put(EKEY.APPLICATION, applicationConfiguration.getApplicationName());
        LOG.fine("createApplication(...)", new Object[0]);
        LOG.fine("createApplication arguments: " + arguments, new Object[0]);
        app = ApplicationFactory.APPLICATION_FACTORY.createApplication(applicationConfiguration, appOrResList == this.applicationConfigurations, cachedApplication, arguments, parentRef, parentClassLoader, this);
        if (app == null) {
            LOG.fine("Failed to get instance of launched application", new Object[0]);
            this.closeSplash();
            LauncherException ne = Launcher.createLauncherException("An application instantiation failure occurred", ep, null);
            if (parentRef == null) {
                this.errorDialog = new ErrorDialog(Localizer.getString("instantiation_failure") + " - " + Localizer.getString("application_cannot_start"), ne);
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw ne;
        }
        this.notifyObservable(applicationConfiguration);
        this.closeSplash();
        return app;
    }

    @Override
    public Launchable runApplication(String path, String hostname, Properties arguments, Launchable parentRef) throws LauncherException {
        LOG.fine("Launcher.runApplication() called; launcher version=" + this.getVersion(), new Object[0]);
        return this.runApplicationOrResource(path, hostname, arguments, parentRef, this.applicationConfigurations);
    }

    private void setupNexEmMapping(String path, URL appUrl) {
        if (!this.isNex(path)) {
            return;
        }
        String emPath = this.getEmPath(appUrl);
        if (emPath != null) {
            try {
                URL emAppUrl = null;
                int port = appUrl.getPort();
                if (port == -1) {
                    port = appUrl.getDefaultPort();
                }
                emAppUrl = new URL(appUrl.getProtocol(), appUrl.getHost(), port, emPath);
                LOG.info("Found mapping: " + appUrl + " - " + emAppUrl, new Object[0]);
                this.applicationMappings.put(appUrl, emAppUrl);
            }
            catch (MalformedURLException e) {
                LOG.throwing(e);
            }
        }
    }

    private boolean isNex(String path) {
        return path != null && path.endsWith(NEX_CONFIG);
    }

    private String getEmPath(URL url) {
        NodeTypeInvestigator nodeTypeInvestigator = new NodeTypeInvestigator();
        nodeTypeInvestigator.init();
        try {
            String fileContents = nodeTypeInvestigator.getEmApplicationsFileContentsFromNode(url, "/em/emapplications.xml");
            if (!"".equals(fileContents)) {
                ArrayList<EmApplicationInfo> emApps = EmApplicationInfoFactory.constructEmAppInfos(fileContents);
                for (EmApplicationInfo emApplicationInfo : emApps) {
                    if (!emApplicationInfo.getApplicationType().equals("EM")) continue;
                    return emApplicationInfo.getConfigFileName();
                }
            }
        }
        catch (Exception e) {
            LOG.throwing(e);
        }
        return null;
    }

    @Override
    public Launchable runResource(String path, String hostname, Properties arguments, Launchable parentRef) throws LauncherException {
        LOG.fine("Launcher version=" + this.getVersion(), new Object[0]);
        EProps ep = new EProps();
        ep.put(EKEY.JAVA_METHOD, "Launcher.runResource");
        ep.append(EKEY.JAVA_METHOD, "hostname      = " + hostname);
        ep.append(EKEY.JAVA_METHOD, "arguments     = " + arguments);
        ep.append(EKEY.JAVA_METHOD, "parentRef     = " + parentRef);
        ep.append(EKEY.JAVA_METHOD, "thread        = " + Thread.currentThread());
        ep.append(EKEY.JAVA_METHOD, "this.launcher = " + this);
        ep.append(EKEY.JAVA_METHOD, "classloader   = " + this.getClass().getClassLoader());
        ep.append(EKEY.JAVA_METHOD, "cl.parent     = " + this.getClass().getClassLoader().getParent());
        if (this.applicationConfigurations.size() == 0) {
            if (parentRef == null) {
                this.errorDialog = new ErrorDialog("runResource() " + Localizer.getString("may_not_be_called") + " " + Localizer.getString("when_no_appl"));
                this.errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            throw Launcher.createLauncherException("runResource() may not be called when no applications are running", ep, null);
        }
        return this.runApplicationOrResource(path, hostname, arguments, parentRef, this.resourceConfigurations);
    }

    private ReusableLaunchable findRunningAppOrResource(URL url, HashMap<Launchable, ApplicationConfiguration> map) {
        LOG.fine("Will search for already running app or resource for path " + url, new Object[0]);
        URL altUrl = this.applicationMappings.get(url);
        if (altUrl != null) {
            LOG.fine("Found an alternative URL that also will matched " + altUrl, new Object[0]);
        }
        for (Map.Entry<Launchable, ApplicationConfiguration> entry : map.entrySet()) {
            ApplicationConfiguration oldAC = entry.getValue();
            LOG.fine("Comparing with \"" + oldAC.getNEAddress() + "\"", new Object[0]);
            if (!this.checkEquals(oldAC.getNEAddress(), url) && !this.checkEquals(oldAC.getNEAddress(), altUrl)) continue;
            Launchable app = entry.getKey();
            if (app instanceof ReusableLaunchable) {
                LOG.fine("Found existing reusable application/resource for " + url.toExternalForm(), new Object[0]);
                return (ReusableLaunchable)app;
            }
            LOG.fine("Found existing application/resource, but it is NOT reusable", new Object[0]);
        }
        LOG.fine("No existing application/resource found for " + url.toExternalForm(), new Object[0]);
        return null;
    }

    private boolean checkEquals(URL firstURL, URL secondURL) {
        if (null == firstURL || null == secondURL) {
            return false;
        }
        String firstAddress = firstURL.toExternalForm().replace("http://", "").replace("https://", "").replace(":" + String.valueOf(PropertyConstants.HTTP_PORT), "").replace(":" + String.valueOf(PropertyConstants.HTTPS_PORT), "");
        String secondArress = secondURL.toExternalForm().replace("http://", "").replace("https://", "").replace(":" + String.valueOf(PropertyConstants.HTTP_PORT), "").replace(":" + String.valueOf(PropertyConstants.HTTPS_PORT), "");
        return firstAddress.equals(secondArress);
    }

    private void prepareForSecurity(Cache cache, ApplicationConfiguration applicationConfiguration, ClassLoader parentClassLoader) throws LauncherException {
        Exception cause;
        if (this.securityClassLoader == null) {
            CachedApplication[] ca;
            SecurityConfiguration secConfiguration = new SecurityConfiguration(applicationConfiguration, this.pm);
            try {
                ca = cache.prepareApplication(secConfiguration);
            }
            catch (CacheException e) {
                throw new LauncherException("Could not prepare security because of a CacheException " + e.getMessage(), (Throwable)e);
            }
            this.securityClassLoader = ApplicationFactory.APPLICATION_FACTORY.createClassLoader(applicationConfiguration.getApplicationName(), ca, parentClassLoader, true);
            String property = this.pm.getString("ssu.propertyname.enabled", false);
            System.setProperty(property, "true");
            String sls = this.pm.getString("ssu.propertyname.slsurls", false);
            System.setProperty(sls, applicationConfiguration.getSLSUrls());
            LOG.fine("slsurls: " + applicationConfiguration.getSLSUrls(), new Object[0]);
        }
        try {
            String slsKey = this.pm.getString("ssu.propertyname.slsurls", false);
            String slsUrl = System.getProperty(slsKey, applicationConfiguration.getSLSUrls());
            if (slsUrl == null || slsUrl.length() <= 0 && this.prepareSecurityFirstTime) {
                this.prepareSecurityFirstTime = false;
                LOG.warning("The SLS is not defined. Only possible to login using Stand Alone Mode", new Object[0]);
                ErrorDialog msgDialog = new ErrorDialog("There is no Single Logon Server defined. It is only possible to login using the 'Stand Alone Mode' option.");
                msgDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            }
            if (this.theLoginContext == null) {
                Class<?> c = this.securityClassLoader.loadClass("se.ericsson.security.login.LoginContext");
                Method m = c.getMethod("getInstance", null);
                this.theLoginContext = m.invoke(null, (Object[])null);
                this.theLoginMethod = c.getMethod("login", null);
            }
            this.theLoginMethod.invoke(this.theLoginContext, (Object[])null);
            return;
        }
        catch (NoSuchMethodException e) {
            cause = e;
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            cause = e;
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.fine(e.getTargetException().getMessage(), new Object[0]);
            if (e.getTargetException().getMessage().equals("Already logged in")) {
                LOG.fine("Already logged in. Reusing credentials.", new Object[0]);
                return;
            }
            cause = e;
            e.printStackTrace();
            e.getTargetException().printStackTrace();
        }
        catch (ClassNotFoundException e) {
            cause = e;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            cause = e;
            e.printStackTrace();
        }
        LOG.severe(Localizer.getString("creds_fetching") + " " + Localizer.getString("failed"), new Object[0]);
        LOG.severe("Could not prepare security because: " + cause.getClass().getName() + ": " + cause.getMessage(), new Object[0]);
        throw new LauncherException("Could not prepare security because " + cause.getClass().getName(), (Throwable)cause);
    }

    @Override
    public void NESwitch(String NEAddress, Launchable callerApplication) throws LauncherException {
        ApplicationConfiguration ac = this.applicationConfigurations.get(callerApplication);
        if (ac == null) {
            ac = this.resourceConfigurations.get(callerApplication);
        }
        if (ac == null) {
            throw new ConfigurationException("Config for application/resource not found");
        }
        ac.changeNE(NEAddress);
    }

    public static LauncherException createLauncherException(String msg, EProps ep, Throwable e) {
        LauncherException ne;
        try {
            ne = new LauncherException(msg, ep, e);
        }
        catch (Throwable t) {
            ne = e != null ? new LauncherException(msg, e) : new LauncherException(msg);
        }
        return ne;
    }

    @Override
    public Properties getApplVersion(Launchable callerApplication) {
        Properties result = new Properties();
        ApplicationConfiguration ac = this.applicationConfigurations.get(callerApplication);
        if (ac == null) {
            ac = this.resourceConfigurations.get(callerApplication);
        }
        if (ac != null) {
            String thisRev = ac.getConfigurationFile().getRevision();
            String thisProdNo = ac.getConfigurationFile().getProductNumber();
            result.setProperty("CUSTOM_APPL_PROD_NO", thisProdNo);
            result.setProperty("CUSTOM_APPL_REV", thisRev);
        }
        return result;
    }

    @Override
    public boolean hasNESameVersion(String neAddress, Launchable callerApplication) {
        return this.hasNESameVersion(neAddress);
    }

    private boolean hasNESameVersion(String neAddress) {
        if (neAddress == null || neAddress.length() == 0) {
            LOG.warning("NE Address is empty; cannot determine NE version", new Object[0]);
            return false;
        }
        ArrayList<Launchable> applications = new ArrayList<Launchable>(this.getRunningApplications());
        applications.addAll(this.getRunningResources());
        for (Launchable application : applications) {
            Collection<ApplicationFileInterface> cfgFiles = this.getConfigurationFiles(application);
            for (ApplicationFileInterface af : cfgFiles) {
                int neCheckSum = 0;
                int localCheckSum = ((ApplicationFile)af).getCheckSum();
                try {
                    String toURL = neAddress + af.getFilePath() + "/" + af.getName();
                    URL url = UrlUtilities.getURL(toURL);
                    if (url != null) {
                        Cache cache = new Cache(new SimpleDownloadListener(), new StubbedVerifyListener(), new PropertyManager());
                        String neCfg = cache.getConfigurationFileAsString(url, true, false);
                        neCheckSum = neCfg.replaceAll("\\W", "").hashCode();
                    } else {
                        LOG.warning("Incorrect NE address.", toURL);
                    }
                }
                catch (VersionException e) {
                    LOG.warning("Got VersionException while trying to download the configuration file from the node", e);
                }
                catch (CacheException e) {
                    LOG.warning("Got CacheException while trying to download the configuraiton file from node.", e);
                }
                if (localCheckSum == neCheckSum) continue;
                LOG.info("Mismatching versions of NE configuration files.", new Object[0]);
                LOG.info("ApplicationFiles: " + af.getName(), new Object[0]);
                LOG.info("ApplicationFiles: ", af);
                return false;
            }
        }
        LOG.info("Matching versions of NE configuration files.", new Object[0]);
        return true;
    }

    @Override
    public boolean hasNESameSecurityState(String neAddress, Launchable callerApplication) {
        SecurityState state;
        if (neAddress == null || neAddress.length() == 0) {
            LOG.warning("NE Address is empty; cannot determine NE security state", new Object[0]);
            return false;
        }
        ApplicationConfiguration ac = this.getApplOrResourceConfiguration(callerApplication);
        if (ac == null) {
            return true;
        }
        URL url = null;
        String path = ac.getNEAddress().getPath();
        String protocol = ac.getNEAddress().getProtocol();
        try {
            URL tmpUrl = new URL(protocol + "://" + neAddress);
            url = new URL(protocol, tmpUrl.getHost(), tmpUrl.getPort(), path);
        }
        catch (MalformedURLException e) {
            LOG.warning("Couldn't determine secure state because of malformed URL", new Object[0]);
            return false;
        }
        try {
            state = new SecurityState(url);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            return false;
        }
        return state.equals(ac.getSecuritystate());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFile(URL fileName, DownloadListener downloadListener) throws LauncherException {
        block11: {
            js = null;
            try {
                try {
                    pathDirs = fileName.getPath().split("/");
                    name = pathDirs[pathDirs.length - 1];
                    urlConnection = fileName.openConnection();
                    EmasUtilities.getInstance().enableNECertificateValidation(urlConnection);
                    js = new JarInputStream(urlConnection.getInputStream());
                    manifest = js.getManifest();
                    prodNo = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
                    rev = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    var10_12 = this.getFile(fileName, name, prodNo, rev, downloadListener);
                    var12_13 = null;
                    if (js == null) return var10_12;
                }
                catch (IOException e) {
                    throw new LauncherException("Could not open manifest from URL: " + fileName.toExternalForm(), (Throwable)e);
                }
                catch (CacheException ce) {
                    throw new LauncherException("Unexpected exception during read or download of " + fileName.toExternalForm(), (Throwable)ce);
                }
            }
            catch (Throwable var11_17) {
                var12_14 = null;
                if (js == null) throw var11_17;
                try {
                    js.close();
                }
                catch (IOException ioe) {
                    Launcher.LOG.warning("Could not close the input stream " + fileName.toExternalForm(), new Object[0]);
                }
                js = null;
                throw var11_17;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 187->194)] { 
lbl35:
            // 1 sources

            js.close();
            break block11;
lbl37:
            // 1 sources

            catch (IOException ioe) {
                Launcher.LOG.warning("Could not close the input stream " + fileName.toExternalForm(), new Object[0]);
            }
        }
        js = null;
        return var10_12;
    }

    @Override
    public synchronized void onExit(Launchable applicationReference) {
        Method m;
        ApplicationConfiguration applConf = this.removeApplicationconfiguration(applicationReference);
        if (applConf != null) {
            LOG.fine("The application '" + applicationReference.toString() + "' was removed from the collection of applications.", new Object[0]);
        } else {
            applConf = this.resourceConfigurations.remove(applicationReference);
            if (applConf != null) {
                LOG.fine("The resource '" + applicationReference.toString() + "' was removed from the collection of resources.", new Object[0]);
                return;
            }
        }
        String displayNameToRemove = "";
        if (Boolean.getBoolean("se.ericsson.security.onapplicationserver")) {
            if (applConf != null) {
                displayNameToRemove = applConf.getDisplayName();
            }
            if (this.securityClassLoader != null) {
                try {
                    Class<?> c = this.securityClassLoader.loadClass("se.ericsson.security.login.LoginContext");
                    m = c.getMethod("getInstance", null);
                    Object obj = m.invoke(null, (Object[])null);
                    m = c.getMethod("releaseCredentials", Class.forName("java.lang.String"));
                    m.invoke(obj, displayNameToRemove);
                    System.setProperty("se.ericsson.security.launcher.applIndex", Integer.toString(Integer.parseInt(System.getProperty("se.ericsson.security.launcher.applIndex")) - 1));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }
        LOG.fine(this.applicationConfigurations.size() + " running applications; " + this.resourceConfigurations.size() + " running resources", new Object[0]);
        if (this.applicationConfigurations.isEmpty()) {
            LOG.fine("All applications have called onExit. Terminating all resources.", new Object[0]);
            this.exitAllResources();
            LOG.fine("Quitting this launcher instance.", new Object[0]);
            if (this.metaLauncher == null) {
                System.exit(0);
            }
            try {
                this.metaLauncher.getClass().getMethod("onExitStatic", Class.forName(this.getClass().getPackage().getName() + ".VersionedLauncherInterface"));
                MetaLauncher.onExitStatic(this);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    m = this.metaLauncher.getClass().getMethod("onExit", Class.forName(this.getClass().getPackage().getName() + ".VersionedLauncherInterface"));
                    m.invoke((Object)this.metaLauncher, this);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    m = this.metaLauncher.getClass().getMethod("onExit", Class.forName(this.getClass().getPackage().getName() + ".VersionedLauncherInterface"));
                    m.invoke((Object)this.metaLauncher, this);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void exitAllResources() {
        Launchable[] resourceArray = this.resourceConfigurations.keySet().toArray(new Launchable[this.resourceConfigurations.keySet().size()]);
        for (int i = 0; i < resourceArray.length; ++i) {
            Launchable resource = resourceArray[i];
            if (null == resource) continue;
            LOG.fine("Before exit of resource:" + resourceArray[i].toString(), new Object[0]);
            resource.exit();
            LOG.fine("After exit of resource:" + resourceArray[i].toString(), new Object[0]);
        }
        this.resourceConfigurations.clear();
    }

    @Override
    public synchronized Collection<Launchable> getRunningApplications() {
        return this.applicationConfigurations.keySet();
    }

    @Override
    public synchronized Collection<Launchable> getRunningResources() {
        return this.resourceConfigurations.keySet();
    }

    @Override
    public Collection<ApplicationFileInterface> getConfigurationFiles(Launchable app) {
        ApplicationConfiguration ac = this.getApplOrResourceConfiguration(app);
        if (ac == null) {
            return null;
        }
        return ac.getConfigurationFiles();
    }

    @Override
    public String getVersion() {
        return this.manifestVersion;
    }

    @Override
    public String getProductNumber() {
        return this.manifestCxc;
    }

    private void setProductAndVersion() {
        try {
            String name = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            name = name.replaceAll("%20", " ");
            LOG.fine(name, new Object[0]);
            CachedJarFile jf = new CachedJarFile(name, true);
            this.manifestVersion = jf.getAttributes().getRevision();
            this.manifestCxc = jf.getAttributes().getProductNumber();
        }
        catch (CacheException e) {
            e.printStackTrace();
            LOG.warning("Couldn't determine launcher version", new Object[0]);
            this.manifestVersion = "_UNKNOWN_";
            this.manifestCxc = "_UNKNOWN_";
        }
    }

    @Override
    public ProgressListenerInterface getProgressListener() {
        return this.splashWindow;
    }

    public ProgressListenerInterface openSplash() {
        if (this.splashWindow == null) {
            this.splashWindow = new SplashWindow(this.manifestCxc, this.manifestVersion);
        }
        if (null == this.splashWindow.getUpdater()) {
            this.splashWindow.setUpdater(this);
        }
        this.splashWindow.showSplash();
        return this.splashWindow;
    }

    @Override
    public void setExceptionHandler(Launchable l, ExceptionHandlerInterface eh) {
        Object[] arglist;
        Method m;
        LOG.fine("Setting exception handler for " + l.getClass().getName(), new Object[0]);
        try {
            EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
            m = instance.getClass().getMethod("setExceptionHandler", Launchable.class, ExceptionHandlerInterface.class);
            arglist = new Object[]{l, eh};
            m.invoke((Object)instance, arglist);
        }
        catch (NoSuchMethodException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        try {
            m = this.metaLauncher.getClass().getMethod("setExceptionHandler", Launchable.class, ExceptionHandlerInterface.class);
            arglist = new Object[]{l, eh};
            m.invoke((Object)this.metaLauncher, arglist);
        }
        catch (NoSuchMethodException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.warning("A problem occured while setting exception handler: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    private void closeSplash() {
        if (this.splashWindow != null && this.splashWindow.getUpdater() == this) {
            this.splashWindow.close();
            this.splashWindow = null;
        }
    }

    /*
     * Loose catch block
     */
    private void setCallBackAddress(String address, int iport) throws ConfigurationException {
        block8: {
            LOG.fine("setCallBackAddress", new Object[0]);
            LOG.fine("address: " + address, new Object[0]);
            LOG.fine("iPort: " + iport, new Object[0]);
            Socket aSocket = new Socket();
            aSocket.connect(new InetSocketAddress(InetAddress.getByName(address), iport), this.getSocketTimeout());
            String myHostAddress = this.getMyHostAddress(aSocket.getLocalAddress());
            System.setProperty(POA_CALLBACK_ADDRESS, myHostAddress);
            LOG.fine("OAIAddr: " + System.getProperty(POA_CALLBACK_ADDRESS, "Not set!"), new Object[0]);
            Object var6_6 = null;
            try {
                aSocket.close();
            }
            catch (IOException e) {
                LOG.severe("Couldn't close socket...", new Object[0]);
            }
            break block8;
            {
                catch (Exception exep) {
                    LOG.warning("Exception while trying to get a connection to " + address + " with port " + iport + " for OAIAddr property setting. " + exep, new Object[0]);
                    if (LOG.getLogger().isLoggable(Level.FINE)) {
                        exep.printStackTrace();
                    }
                    throw new ConfigurationException("It was not possible to set up a connection to the NE " + address, (Throwable)exep);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    aSocket.close();
                }
                catch (IOException e) {
                    LOG.severe("Couldn't close socket...", new Object[0]);
                }
                throw throwable;
            }
        }
    }

    private String getMyHostAddress(InetAddress localAddress) {
        String ad = localAddress.getHostAddress().trim();
        return localAddress instanceof Inet6Address ? "[" + ad + "]" : ad;
    }

    private int getSocketTimeout() {
        int timeout = 0;
        String timeoutStr = System.getProperty("sun.net.client.defaultConnectTimeout");
        if (null != timeoutStr && timeoutStr.trim().length() > 0) {
            try {
                timeout = Integer.parseInt(timeoutStr.trim());
            }
            catch (NumberFormatException ee) {
                LOG.info("Can't parse timeout. It will be set to 0.", new Object[0]);
            }
        }
        return timeout;
    }

    @Override
    public void addEmNotificationListener(EmNotificationListenerInterface listener) {
        this.emNotificationService.addEmNotificationListener(listener);
    }

    @Override
    public void removeEmNotificationListener(EmNotificationListenerInterface listener) {
        this.emNotificationService.removeEmNotificationListener(listener);
    }

    @Override
    public void sendNotification(EmEventInterface note) {
        this.emNotificationService.sendNotification(note);
    }

    @Override
    public String getFile(URL fileName, String productName, String productNumber, String productRevision, DownloadListener downloadListener) throws VerifyException, LauncherException {
        LOG.fine("Getting file: " + fileName.toExternalForm(), new Object[0]);
        String dirDelimiter = File.separator;
        String cxcWithoutSpaceAndSlash = Revision.rewritePreferred(productNumber.toUpperCase().replaceAll("\\s", ""));
        String revWithoutSpaceAndSlash = Revision.rewritePreferred(productRevision.toUpperCase().replaceAll("\\s", ""));
        try {
            String[] pathDirs = fileName.getPath().split("/");
            String name = pathDirs[pathDirs.length - 1];
            String filePath = this.pm.getString("se.ericsson.security.launcher.cachedirname", true) + dirDelimiter + cxcWithoutSpaceAndSlash + dirDelimiter + revWithoutSpaceAndSlash + dirDelimiter;
            LOG.fine("Application requested file " + name + " " + productNumber + " " + productRevision + " in path " + filePath + " to be downloaded if not present.", new Object[0]);
            ApplicationFile af = new ApplicationFile(name, filePath, productNumber, productRevision);
            Cache tempCache = new Cache(downloadListener, new StubbedVerifyListener(), this.pm);
            tempCache.getFile(af, fileName, true);
            return filePath + name;
        }
        catch (VerifyException ve) {
            LOG.warning(ve.getMessage(), new Object[0]);
            throw ve;
        }
        catch (CacheException ce) {
            throw new LauncherException("Unexpected exception during read or download of " + fileName.toExternalForm(), (Throwable)ce);
        }
    }

    @Override
    public Collection<ApplicationFileInterface> getUsedJars(ApplicationFileInterface appFileI) {
        Vector<ApplicationFileInterface> jars = new Vector<ApplicationFileInterface>();
        for (ApplicationConfiguration appConfig : this.applicationConfigurations.values()) {
            if (!this.isMatch(appConfig, appFileI)) continue;
            this.addUniqueApplicationFileInterface(appConfig.getApplicationFiles(), jars);
            this.addUniqueApplicationFileInterface(appConfig.getCommonApplicationFiles(), jars);
            break;
        }
        for (ApplicationConfiguration appConfig : this.resourceConfigurations.values()) {
            if (!this.isMatch(appConfig, appFileI)) continue;
            this.addUniqueApplicationFileInterface(appConfig.getApplicationFiles(), jars);
            this.addUniqueApplicationFileInterface(appConfig.getCommonApplicationFiles(), jars);
            break;
        }
        return jars;
    }

    private boolean isMatch(ApplicationConfiguration applicationConfiguration, ApplicationFileInterface applicationFile) {
        if (applicationFile.getProductNumber().equals("") && applicationFile.getRevision().equals("")) {
            for (ApplicationFileInterface af : applicationConfiguration.getConfigurationFiles()) {
                if (!af.getName().equals(applicationFile.getName())) continue;
                return true;
            }
        } else if (applicationConfiguration.getConfigurationFile().equals(applicationFile)) {
            return true;
        }
        return false;
    }

    private void addUniqueApplicationFileInterface(Collection<ApplicationFileInterface> applicationFiles, Vector<ApplicationFileInterface> jarContainer) {
        for (ApplicationFileInterface applicationFileInterface : applicationFiles) {
            if (jarContainer.contains(applicationFileInterface)) continue;
            jarContainer.add(applicationFileInterface);
        }
    }

    private void chmodMe() {
        try {
            File launcherFile = new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            this.chmodFile(launcherFile);
        }
        catch (NullPointerException e) {
            LOG.warning("Could not change file permissions on launcher.jar (NullPointer).", new Object[0]);
        }
    }

    @Override
    public boolean chmodFile(File targetFileOrDir) {
        boolean result = false;
        if (!EmasUtilities.runningOnWindows()) {
            if (!targetFileOrDir.exists()) {
                LOG.warning("Could not change permission on " + targetFileOrDir.getPath() + " since it didn't exist.", new Object[0]);
            } else {
                String chmodCmd = targetFileOrDir.isDirectory() ? CHMOD_CMD_DIR : CHMOD_CMD_FILE;
                Runtime rt = Runtime.getRuntime();
                LOG.info("Changing file permissions on " + targetFileOrDir.getPath(), new Object[0]);
                try {
                    Process p = rt.exec(chmodCmd + " " + targetFileOrDir.getPath());
                    if (p.waitFor() == 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    LOG.warning("Could not do change the permissions on " + targetFileOrDir.getPath() + ".", new Object[0]);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    @Override
    public File getAndChmodFile(File cacheDirectory, URL wantedFile) throws Exception {
        File targetFile;
        block16: {
            block17: {
                String urlFileName = wantedFile.getFile();
                targetFile = new File(cacheDirectory, urlFileName = urlFileName.substring(urlFileName.lastIndexOf("/")));
                if (targetFile.exists()) break block17;
                LOG.info("Will download file: " + wantedFile.getPath() + " since it doesn't exist on path.", new Object[0]);
                ReadableByteChannel readChannel = null;
                AbstractInterruptibleChannel fileChannel = null;
                FileOutputStream fileOutputStream = null;
                InputStream inputStream = null;
                inputStream = EmasUtilities.getInstance().getInputStreamByUrl(wantedFile);
                readChannel = Channels.newChannel(inputStream);
                ByteBuffer buffer = ByteBuffer.allocateDirect(131072);
                fileOutputStream = new FileOutputStream(targetFile);
                fileChannel = fileOutputStream.getChannel();
                while (readChannel.read(buffer) != -1) {
                    buffer.flip();
                    ((FileChannel)fileChannel).write(buffer);
                    buffer.clear();
                }
                Object var11_11 = null;
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                    if (readChannel != null) {
                        readChannel.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block16;
                }
                catch (IOException e) {
                    LOG.severe("Could not close file, read channels or output, input streams.\n" + e.toString(), new Object[0]);
                }
                break block16;
                {
                    catch (IOException e) {
                        LOG.warning("Exception while trying to download: " + targetFile.getPath() + "\nMessage:" + e.getMessage(), new Object[0]);
                        throw new Exception("Error while trying to get file:" + targetFile.getPath() + "\n" + e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        if (fileChannel != null) {
                            fileChannel.close();
                        }
                        if (readChannel != null) {
                            readChannel.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.severe("Could not close file, read channels or output, input streams.\n" + e.toString(), new Object[0]);
                    }
                    throw throwable;
                }
            }
            LOG.info("File:" + targetFile.getPath() + " already exists.", new Object[0]);
        }
        this.chmodFile(targetFile);
        return targetFile;
    }
}

