/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.utils.EmLogger;

class TrustedCertificateManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private X509Certificate[] trustedCerts;
    private char[] storepass = new char[]{'w', 'r', 'e', 'd', 'h', 's'};
    private static final int KEYSTORE_CERTIFICATE_NO = 2;
    private static final String KEYSTORE_LABEL = "keystore";
    private static final String SSW_LABEL = "SSW";

    TrustedCertificateManager() {
    }

    X509Certificate[] getTrustedcerts() throws LauncherException {
        LOG.finest("Trying to get the certificate from emas key store ", new Object[0]);
        Certificate[] keystoreCerts = this.getCertificateFromKeyStore();
        LOG.finest("Got trusted certificates: " + keystoreCerts.toString() + " from emas key store.\n", new Object[0]);
        CodeSource thisCodeSource = this.getClass().getProtectionDomain().getCodeSource();
        LOG.finest("Trying to get the certificate from SSW", new Object[0]);
        Certificate[] sswCertificates = thisCodeSource.getCertificates();
        if (sswCertificates == null) {
            LOG.finest("No SSW certificates found.\n", new Object[0]);
            this.trustedCerts = new X509Certificate[2];
        } else {
            LOG.finest("Got trusted certificates: " + sswCertificates.toString() + " from SSW.\n", new Object[0]);
            this.trustedCerts = new X509Certificate[sswCertificates.length + 2];
        }
        this.loadTrustedCerts(keystoreCerts, KEYSTORE_LABEL);
        if (sswCertificates != null) {
            this.loadTrustedCerts(sswCertificates, SSW_LABEL);
        }
        return this.trustedCerts;
    }

    private void loadTrustedCerts(Certificate[] certificates, String source) throws LauncherException {
        for (int i = 0; i < certificates.length; ++i) {
            if (certificates[i] instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificates[i];
                try {
                    x509Cert.checkValidity();
                    if (KEYSTORE_LABEL.equals(source)) {
                        this.trustedCerts[i] = x509Cert;
                    } else {
                        this.trustedCerts[i + 2] = x509Cert;
                    }
                    LOG.fine("Added " + source + " trusted certificate with SubjectDN: " + x509Cert.getSubjectDN() + "\n", new Object[0]);
                    continue;
                }
                catch (CertificateException ce) {
                    LOG.severe("Certificate with SubjectDN=" + x509Cert.getSubjectDN() + " is not valid", new Object[0]);
                    throw new LauncherException("Certificate with SubjectDN=" + x509Cert.getSubjectDN() + " is not valid", (Throwable)ce);
                }
            }
            LOG.severe("Trusted Certificate is not X509. Type= " + certificates[i].getType(), new Object[0]);
            throw new LauncherException("Trusted Certificate is not X509. Type= " + certificates[i].getType());
        }
    }

    private Certificate[] getCertificateFromKeyStore() throws LauncherException {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance("JKS");
            LOG.finest("Get keystore instance " + ks.toString(), new Object[0]);
            InputStream is = Cache.class.getResourceAsStream("emas.keystore");
            ks.load(is, this.storepass);
        }
        catch (KeyStoreException e) {
            LOG.severe("Get JKS keystore instance exception", new Object[0]);
            throw new LauncherException("Get JKS keystore instance exception", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.severe("Keystore load algorithm exception", new Object[0]);
            throw new LauncherException("Keystore load algorithm exception", (Throwable)e);
        }
        catch (CertificateException e) {
            LOG.severe("Keystore load certificate exception", new Object[0]);
            throw new LauncherException("Keystore load certificate exception", (Throwable)e);
        }
        catch (IOException e) {
            LOG.severe("Keystore load IO exception", new Object[0]);
            throw new LauncherException("Keystore load IO exception", (Throwable)e);
        }
        Certificate[] certificates = new Certificate[2];
        try {
            certificates[0] = ks.getCertificate("root");
        }
        catch (KeyStoreException e) {
            LOG.severe("Get root certificate exception", new Object[0]);
            throw new LauncherException("Get root certificate exception", (Throwable)e);
        }
        try {
            certificates[1] = ks.getCertificate("emas");
        }
        catch (KeyStoreException e) {
            LOG.severe("Get emas certificate exception", new Object[0]);
            throw new LauncherException("Get emas certificate exception", (Throwable)e);
        }
        return certificates;
    }
}

