/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.download;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.net.ssl.SSLHandshakeException;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadFeedbackListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public class DownloadManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private int SOCKET_TIMEOUT;

    public DownloadManager() {
        PropertyManager properties = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.SOCKET_TIMEOUT = properties.getInt("se.ericsson.security.launcher.connecttimeout", true, 20000);
    }

    /*
     * Exception decompiling
     */
    public void downloadToFile(URL remoteFile, File localFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadToString(URL remoteFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        InputStream in = null;
        URLConnection urlConnection = null;
        boolean failed = false;
        String remoteFileName = remoteFile.toExternalForm();
        String path = remoteFile.toExternalForm();
        ReadableByteChannel inRbs = null;
        StringBuffer strBuffCont = null;
        try {
            String string;
            block19: {
                ConnectReturn ret = this.doConnect(remoteFile, listener);
                urlConnection = ret.urlConnection;
                in = urlConnection.getInputStream();
                int totalLength = urlConnection.getContentLength();
                ByteBuffer bb = ByteBuffer.allocate(4096);
                Charset charset = Charset.forName("UTF-8");
                CharsetDecoder decoder = charset.newDecoder();
                CharBuffer charBuffer = null;
                inRbs = Channels.newChannel(in);
                strBuffCont = new StringBuffer();
                int progress = 0;
                int read = 0;
                while ((read = inRbs.read(bb)) >= 0) {
                    bb.flip();
                    charBuffer = decoder.decode(bb);
                    strBuffCont.append(charBuffer.toString());
                    bb.clear();
                    listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                }
                string = strBuffCont.toString();
                Object var20_22 = null;
                if (failed) break block19;
                if (listener instanceof DownloadFeedbackListener) {
                    ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                } else {
                    listener.finished(path.substring(path.lastIndexOf("/") + 1));
                }
            }
            if (in == null) return string;
            try {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    LOG.warning("Failed to close inputstream.", new Object[0]);
                    return string;
                }
                return string;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                in = null;
                throw throwable;
            }
            catch (IOException e) {
                failed = true;
                if (e instanceof SSLHandshakeException) {
                    throw (SSLHandshakeException)e;
                }
                String message = "Failed reading data from " + remoteFileName;
                LOG.severe(message, new Object[0]);
                if (!(listener instanceof DownloadFeedbackListener)) {
                    listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                    throw new DownloadException(message, (Throwable)e);
                }
                ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                throw new DownloadException(message, (Throwable)e);
            }
            catch (Exception e) {
                failed = true;
                throw new DownloadException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (!failed) {
                if (listener instanceof DownloadFeedbackListener) {
                    ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                } else {
                    listener.finished(path.substring(path.lastIndexOf("/") + 1));
                }
            }
            if (in == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var23_29 = null;
                in = null;
                throw throwable2;
            }
            try {}
            catch (IOException ioe) {
                LOG.warning("Failed to close inputstream.", new Object[0]);
                Object var23_28 = null;
                in = null;
                throw throwable;
            }
            in.close();
            Object var23_27 = null;
            in = null;
            throw throwable;
        }
    }

    private ConnectReturn doConnect(URL remoteFile, DownloadListener listener) throws SocketTimeoutException, SSLHandshakeException, IOException, FileNotFoundException, DownloadException {
        LOG.fine("Opening connection to url: " + remoteFile.toExternalForm(), new Object[0]);
        URLConnection urlConnection = remoteFile.openConnection();
        ConnectReturn ret = new ConnectReturn(urlConnection, -1L);
        EmasUtilities.getInstance().enableNECertificateValidation(urlConnection);
        urlConnection.setConnectTimeout(this.SOCKET_TIMEOUT);
        urlConnection.setUseCaches(false);
        urlConnection.setReadTimeout(this.SOCKET_TIMEOUT);
        String path = remoteFile.getFile();
        int port = remoteFile.getPort();
        try {
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).connecting(remoteFile.getHost() + (port != -1 ? String.valueOf(port) : ""), path.substring(path.lastIndexOf("/") + 1));
            }
            LOG.fine("Doing urlConnection.connect()...", new Object[0]);
            urlConnection.connect();
            LOG.fine("Done urlConnection.connect()", new Object[0]);
        }
        catch (SocketTimeoutException e) {
            throw this.createWrappedSocketTimeoutException(remoteFile, e);
        }
        catch (SSLHandshakeException e) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), e);
            if (e.getCause() instanceof EOFException) {
                this.retryConnect(urlConnection, e);
            }
            throw e;
        }
        catch (SocketException e) {
            this.retryConnect(urlConnection, e);
        }
        catch (IOException e) {
            throw this.createWrappedIOException(urlConnection, e);
        }
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            ret.lastModified = httpURLConnection.getLastModified();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                if (listener instanceof DownloadFeedbackListener) {
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                } else {
                    listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                }
                LOG.fine("HTTP Code: " + responseCode, new Object[0]);
                if (responseCode == 404) {
                    throw new FileNotFoundException("File " + remoteFile.toExternalForm() + " not found on server");
                }
                throw new DownloadException("Failed to download " + remoteFile.toExternalForm() + ". HTTP Code: " + responseCode);
            }
        }
        return ret;
    }

    public InputStream downloadToInputStream(URL remoteFile) throws DownloadException {
        try {
            URLConnection connection = remoteFile.openConnection();
            EmasUtilities.getInstance().enableNECertificateValidation(connection);
            InputStream is = connection.getInputStream();
            return is;
        }
        catch (IOException e) {
            throw new DownloadException("Could not download: " + remoteFile.toExternalForm(), (Throwable)e);
        }
    }

    private SocketTimeoutException createWrappedSocketTimeoutException(URL remoteFile, SocketTimeoutException e) {
        LOG.warning("Could not connect (timeout) to: " + remoteFile.getHost(), new Object[0]);
        int port = remoteFile.getPort();
        SocketTimeoutException resentExc = new SocketTimeoutException("Could not connect (timeout) to node " + remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : "") + " to download " + remoteFile.getPath());
        resentExc.setStackTrace(e.getStackTrace());
        resentExc.initCause(e);
        return resentExc;
    }

    private void retryConnect(URLConnection urlConnection, IOException originalException) throws SocketTimeoutException, SocketException, IOException {
        try {
            urlConnection.connect();
        }
        catch (SocketTimeoutException ex) {
            throw this.createWrappedSocketTimeoutException(urlConnection.getURL(), ex);
        }
        catch (SSLHandshakeException ex) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), ex);
            throw originalException;
        }
        catch (IOException ex) {
            throw this.createWrappedIOException(urlConnection, originalException);
        }
    }

    private IOException createWrappedIOException(URLConnection urlConnection, Exception originalException) {
        LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), originalException);
        IOException resentExc = new IOException("Could not download " + urlConnection.getURL().toExternalForm());
        resentExc.setStackTrace(originalException.getStackTrace());
        resentExc.initCause(originalException);
        return resentExc;
    }

    private class ConnectReturn {
        long lastModified;
        URLConnection urlConnection;

        private ConnectReturn(URLConnection urlConnection, long lastModified) {
            this.urlConnection = urlConnection;
            this.lastModified = lastModified;
        }
    }
}

