/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.parser;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.xml.sax.InputSource;
import se.ericsson.security.launcher.parser.ConfigurationAccess;
import se.ericsson.security.launcher.parser.CustomApplJavaVersion;
import se.ericsson.security.launcher.parser.CustomApplParameters;
import se.ericsson.security.launcher.parser.EmApplication;
import se.ericsson.security.launcher.parser.EmApplicationConfiguration;
import se.ericsson.security.launcher.parser.EmApplicationFile;
import se.ericsson.security.launcher.parser.EmApplicationSee;
import se.ericsson.security.launcher.parser.NameValue;
import se.ericsson.security.launcher.parser.ParseXml;
import se.ericsson.security.launcher.parser.ParserException;
import se.ericsson.security.launcher.parser.ParserInputEmptyException;
import se.ericsson.security.starter.investigator.resource.Resource;

class ConfigurationAccessImpl
implements ConfigurationAccess {
    private static final String CUSTOM_APPL_JAVA_VERSION = "CUSTOM_APPL_JAVA_VERSION";
    private static final String MIN = "MIN";
    private static final String RECOMMENDED = "RECOMMENDED";
    private static final String EM_APPLICATION = "EM_APPLICATION";
    private static final String EM_APPLICATION_CONFIG_FILE = "EM_APPLICATION_CONFIG_FILE";
    private static final String CUSTOM_APPL_INIT_CLASS = "CUSTOM_APPL_INIT_CLASS";
    private static final String CUSTOM_APPL_NAME = "CUSTOM_APPL_NAME";
    private static final String CUSTOM_APPL_PROD_NO = "CUSTOM_APPL_PROD_NO";
    private static final String CUSTOM_APPL_REV = "CUSTOM_APPL_REV";
    private static final String CUSTOM_APPL_PARAMETERS = "CUSTOM_APPL_PARAMETERS";
    private static final String PARAMETERNAME = "PARAMETERNAME";
    private static final String VALUE = "VALUE";
    private static final String EM_APPLICATION_FILE = "EM_APPLICATION_FILE";
    private static final String EM_COMMON_APPLICATION_FILE = "EM_COMMON_APPLICATION_FILE";
    private static final String EM_APPLICATION_SEE = "EM_APPLICATION_SEE";
    private static final String REF_NAME = "REF_NAME";
    private static final String FILE_NAME = "FILE_NAME";
    private static final String FILE_PROD_NO = "FILE_PROD_NO";
    private static final String FILE_REV = "FILE_REV";
    private static final String FILE_PATH = "FILE_PATH";
    private static final String EM_LAUNCHER_FILE = "EM_LAUNCHER_FILE";
    private static final String EM_LAUNCHER_SEE = "EM_LAUNCHER_SEE";
    private ParseXml itsParser = null;
    private String theFileContent = null;

    public ConfigurationAccessImpl() {
        this.itsParser = new ParseXml();
    }

    public ConfigurationAccessImpl(String theFileContent) {
        this.theFileContent = theFileContent;
        this.itsParser = new ParseXml(new InputSource(new StringReader(theFileContent)));
    }

    public ConfigurationAccessImpl(String theFileContent, boolean partial) {
        this.theFileContent = theFileContent;
        this.itsParser = new ParseXml(partial, theFileContent);
    }

    private String getParamValue(Collection col, String name) {
        for (NameValue ob : col) {
            if (!ob.getName().equals(name)) continue;
            return ob.getValue();
        }
        return "";
    }

    public CustomApplJavaVersion getCustomApplJavaVersion() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new CustomApplJavaVersion();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(CUSTOM_APPL_JAVA_VERSION);
        Iterator iter = col.iterator();
        CustomApplJavaVersion result = new CustomApplJavaVersion();
        while (iter.hasNext()) {
            Collection parameters = (Collection)iter.next();
            result.setMin(this.getParamValue(parameters, MIN));
            result.setRecommended(this.getParamValue(parameters, RECOMMENDED));
        }
        return result;
    }

    public EmApplication getEmApplication() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new EmApplication();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_APPLICATION);
        Iterator iter = col.iterator();
        EmApplication result = new EmApplication();
        while (iter.hasNext()) {
            Collection parameters = (Collection)iter.next();
            result.setCustomApplInitClass(this.getParamValue(parameters, CUSTOM_APPL_INIT_CLASS));
            result.setCustomApplName(this.getParamValue(parameters, CUSTOM_APPL_NAME));
            result.setCustomApplProdNo(this.getParamValue(parameters, CUSTOM_APPL_PROD_NO));
            result.setCustomApplRev(this.getParamValue(parameters, CUSTOM_APPL_REV));
        }
        return result;
    }

    public EmApplicationConfiguration getEmApplicationConfiguration() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new EmApplicationConfiguration();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_APPLICATION_CONFIG_FILE);
        Iterator iter = col.iterator();
        EmApplicationConfiguration result = new EmApplicationConfiguration();
        while (iter.hasNext()) {
            Collection parameters = (Collection)iter.next();
            result.setCustomApplProdNo(this.getParamValue(parameters, CUSTOM_APPL_PROD_NO));
            result.setCustomApplRev(this.getParamValue(parameters, CUSTOM_APPL_REV));
        }
        return result;
    }

    public Collection getCustomApplParameters() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(CUSTOM_APPL_PARAMETERS);
        Iterator iter = col.iterator();
        ArrayList<CustomApplParameters> result = new ArrayList<CustomApplParameters>(5);
        while (iter.hasNext()) {
            CustomApplParameters ob = new CustomApplParameters();
            Collection parameters = (Collection)iter.next();
            ob.setParameterName(this.getParamValue(parameters, PARAMETERNAME));
            ob.setValue(this.getParamValue(parameters, VALUE));
            result.add(ob);
        }
        return result;
    }

    public Collection getEmApplicationFile() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_APPLICATION_FILE);
        Iterator iter = col.iterator();
        ArrayList<EmApplicationFile> result = new ArrayList<EmApplicationFile>(10);
        while (iter.hasNext()) {
            EmApplicationFile ob = new EmApplicationFile();
            Collection parameters = (Collection)iter.next();
            ob.setFileName(this.getParamValue(parameters, FILE_NAME));
            ob.setFileProdNo(this.getParamValue(parameters, FILE_PROD_NO));
            ob.setFileRev(this.getParamValue(parameters, FILE_REV));
            ob.setFilePath(this.getParamValue(parameters, FILE_PATH));
            result.add(ob);
        }
        return result;
    }

    public Collection getEmCommonApplicationFile() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_COMMON_APPLICATION_FILE);
        Iterator iter = col.iterator();
        ArrayList<EmApplicationFile> result = new ArrayList<EmApplicationFile>(10);
        while (iter.hasNext()) {
            EmApplicationFile ob = new EmApplicationFile();
            Collection parameters = (Collection)iter.next();
            ob.setFileName(this.getParamValue(parameters, FILE_NAME));
            ob.setFileProdNo(this.getParamValue(parameters, FILE_PROD_NO));
            ob.setFileRev(this.getParamValue(parameters, FILE_REV));
            ob.setFilePath(this.getParamValue(parameters, FILE_PATH));
            result.add(ob);
        }
        return result;
    }

    public Collection getEmApplicationSee() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_APPLICATION_SEE);
        Iterator iter = col.iterator();
        ArrayList<EmApplicationSee> result = new ArrayList<EmApplicationSee>(10);
        while (iter.hasNext()) {
            EmApplicationSee ob = new EmApplicationSee();
            Collection parameters = (Collection)iter.next();
            ob.setRefName(this.getParamValue(parameters, REF_NAME));
            ob.setFileName(this.getParamValue(parameters, FILE_NAME));
            ob.setFilePath(this.getParamValue(parameters, FILE_PATH));
            result.add(ob);
        }
        return result;
    }

    public Resource getEmConfiurationSee(Resource res) throws ParserException {
        if (this.itsParser == null) {
            return null;
        }
        this.checkInput();
        Collection col = this.getEmApplicationFile();
        for (EmApplicationFile emApplicationFile : col) {
            if (!emApplicationFile.getFileName().equalsIgnoreCase(res.getResourceRef().getResourceFileName())) continue;
            res.getResourceRef().setProductNumber(emApplicationFile.getFileProdNo());
            res.getResourceRef().setProductRevision(emApplicationFile.getFileRev());
            res.setResourcePath(emApplicationFile.getFilePath());
            break;
        }
        return res;
    }

    public Collection getEmLauncherFile() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_LAUNCHER_FILE);
        Iterator iter = col.iterator();
        ArrayList<EmApplicationFile> result = new ArrayList<EmApplicationFile>(1);
        while (iter.hasNext()) {
            EmApplicationFile ob = new EmApplicationFile();
            Collection parameters = (Collection)iter.next();
            ob.setFileName(this.getParamValue(parameters, FILE_NAME));
            ob.setFileProdNo(this.getParamValue(parameters, FILE_PROD_NO));
            ob.setFileRev(this.getParamValue(parameters, FILE_REV));
            ob.setFilePath(this.getParamValue(parameters, FILE_PATH));
            result.add(ob);
        }
        return result;
    }

    public Collection getEmLauncherSee() throws ParserException, ParserInputEmptyException {
        if (this.itsParser == null) {
            return new ArrayList();
        }
        this.checkInput();
        ArrayList col = this.itsParser.parse(EM_LAUNCHER_SEE);
        Iterator iter = col.iterator();
        ArrayList<EmApplicationSee> result = new ArrayList<EmApplicationSee>(1);
        while (iter.hasNext()) {
            EmApplicationSee ob = new EmApplicationSee();
            Collection parameters = (Collection)iter.next();
            ob.setRefName(this.getParamValue(parameters, REF_NAME));
            ob.setFileName(this.getParamValue(parameters, FILE_NAME));
            ob.setFilePath(this.getParamValue(parameters, FILE_PATH));
            result.add(ob);
        }
        return result;
    }

    public void setFileContent(String theFileContent) throws ParserInputEmptyException {
        if (theFileContent == null || theFileContent.length() == 0) {
            throw new ParserInputEmptyException();
        }
        this.theFileContent = theFileContent;
        this.itsParser = new ParseXml(new InputSource(new StringReader(theFileContent)));
    }

    public void setFileContentForPartialParsing(String theFileContent) throws ParserInputEmptyException {
        if (theFileContent == null || theFileContent.length() == 0) {
            throw new ParserInputEmptyException();
        }
        this.theFileContent = theFileContent;
        this.itsParser = new ParseXml(true, theFileContent);
    }

    private void checkInput() throws ParserInputEmptyException {
        if (this.theFileContent == null || this.theFileContent.length() == 0) {
            throw new ParserInputEmptyException();
        }
    }
}

