/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.testmode;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.eprops.EmasException;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmStarterInterface;
import se.ericsson.security.utils.EmLogger;

public class TmUtilities {
    private static TmStarterInterface stubStarterInstance = null;
    protected static final EmLogger LOG = EmLogger.STARTER;
    private static final Class<?> THIS = TmUtilities.class;
    private static final String TESTMODE_HANDLING_HEADER = "TESTMODE handling";
    public static final String NEW_INDENTED_LINE = "\n   ";
    public static final String NEW_DOUBLE_INDENTED_LINE = "\n      ";
    private static final Thread.UncaughtExceptionHandler newDefaultUEH = new Thread.UncaughtExceptionHandler(){
        private final Thread.UncaughtExceptionHandler oldDefaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uncaughtException(Thread t, Throwable e) {
            try {
                try {
                    EmasException ne = new EmasException("UncaughtException killed thread '" + t.getName() + "'!", EProps.getRevisionProperties(), e);
                    LOG.severe("Caught by DefaultUncaughtExceptionHandler", ne);
                }
                catch (Throwable nt) {
                    LOG.severe("Caught by DefaultUncaughtExceptionHandler", t);
                    LOG.severe("Caused in DefaultUncaughtExceptionHandler", nt);
                    Object var5_6 = null;
                    if (this.oldDefaultUEH != null) {
                        this.oldDefaultUEH.uncaughtException(t, e);
                    }
                }
                Object var5_5 = null;
                if (this.oldDefaultUEH != null) {
                    this.oldDefaultUEH.uncaughtException(t, e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (this.oldDefaultUEH != null) {
                    this.oldDefaultUEH.uncaughtException(t, e);
                }
                throw throwable;
            }
        }
    };

    public static void setStubStarter(TmStarterInterface stubStarter) {
        stubStarterInstance = stubStarter;
    }

    public static boolean isSemlaActive() {
        return stubStarterInstance != null;
    }

    public static TmStarterInterface getStubStarter() {
        return stubStarterInstance;
    }

    public static String getLogMessage(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append(TESTMODE_HANDLING_HEADER);
        sb.append(NEW_INDENTED_LINE);
        sb.append(text);
        sb.append(NEW_INDENTED_LINE);
        return sb.toString();
    }

    public static boolean isTmPropertiesLoaded() {
        return TmProperty.isAnyPropSet();
    }

    public static boolean isClassLoadingFromJarsDisabled() {
        boolean isDisabled = TmProperty.DISABLE_JARS.isSet() ? TmProperty.DISABLE_JARS.getBoolean() : TmUtilities.runningFromEclipse();
        return isDisabled;
    }

    public static boolean runningFromEclipse() {
        URL url = THIS.getResource(THIS.getSimpleName() + ".class");
        boolean startsWithJar = url.toString().startsWith("jar");
        return !startsWithJar;
    }

    public static URL[] getSemlaUrlArray() {
        URL semlaJarUrl = TmUtilities.getSafeSemlaUrl();
        if (semlaJarUrl == null) {
            return new URL[0];
        }
        return new URL[]{semlaJarUrl};
    }

    public static URL getSafeSemlaUrl() {
        if (!TmProperty.SEMLA.isSet() || TmProperty.DISABLE_JARS.getBoolean()) {
            return null;
        }
        URL semlaJarUrl = null;
        EProps ep = new EProps();
        try {
            Object error = null;
            Object cause = null;
            File semlaJarFile = new File(TmProperty.SEMLA.getValue());
            ep.append(EKEY.JAVA_INFO, NEW_INDENTED_LINE, "SEMLA = '" + TmProperty.SEMLA.getValue() + "'");
            ep.append(EKEY.JAVA_INFO, NEW_INDENTED_LINE, "File  = '" + semlaJarFile + "'");
            if (!semlaJarFile.isFile()) {
                LOG.fine(TmUtilities.getLogMessage("SEMLA jar is not a file : '" + TmProperty.SEMLA.getValue()), new Object[0]);
                return null;
            }
            if (!semlaJarFile.canRead()) {
                LOG.severe(TmUtilities.getLogMessage("SEMLA jar is not a file : '" + TmProperty.SEMLA.getValue()), new Object[0]);
                return null;
            }
            try {
                semlaJarUrl = semlaJarFile.toURI().toURL();
                ep.append(EKEY.JAVA_INFO, NEW_INDENTED_LINE, "URL   = '" + semlaJarUrl + "'");
            }
            catch (MalformedURLException e) {
                LOG.severe(TmUtilities.getLogMessage("Failed creating a URL to SEMLA jar file : '" + semlaJarFile + "'"), e);
                return null;
            }
            return semlaJarUrl;
        }
        catch (Throwable t) {
            LOG.severe(TmUtilities.getLogMessage("Unexpected Error when creating a URL to SEMLA jar file : '" + TmProperty.SEMLA.getValue() + "'"), t);
            return null;
        }
    }
}

