/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.cache.SplashVerifyListener;
import se.ericsson.security.launcher.cache.VerifyListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.SplashDownloadListener;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.ui.SplashWindowInterface;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public final class SplashWindow
extends JFrame
implements ProgressListenerInterface,
SplashWindowInterface {
    private static final long serialVersionUID = 7656944529696762059L;
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    transient DownloadListener downloadListener = null;
    transient VerifyListener verifyListener = null;
    volatile JLabel logoLabel;
    volatile JLabel productLabel;
    volatile JProgressBar progressBar;
    volatile JLabel infoLabel;
    volatile JLabel statusLabel;
    volatile JLabel progressLabel;
    volatile JLabel versionLabel;
    volatile JLabel copyrightLabel;
    volatile JPanel downloadFeedbackPanel;
    volatile JTextArea finfaTextArea;
    volatile JScrollPane finfaScrollPane;
    volatile JPanel progressPanel;
    JPanel framePanel;
    JPanel splashPanel;
    private static final Color fgColor = Color.black;
    private static final Color bgColor = Color.white;
    boolean firstText = true;
    private transient PropertyManager pm = PropertyManager.getInstance(this.getClass().getClassLoader());
    private Object updater = null;
    private String infoMsg = "";
    private String statusMsg = "";
    private String progressOp = "";
    private int progressSoFar;
    private int progressTotal;

    public SplashWindow(String cxcnumber, String revision) {
        Color ericBlue = new Color(0, 40, 94);
        Color lightGray = new Color(192, 192, 192);
        Color veryLightGray = new Color(224, 224, 224);
        this.logoLabel = this.createJLabelFromImage("econ_with_text.png", 58, 52);
        this.productLabel = this.createJLabelFromImage("em_launcher_text.png", 416, 141);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(veryLightGray);
        this.progressBar.setForeground(ericBlue);
        this.progressBar.setMinimum(0);
        int progressBarHeight = 10;
        this.progressBar.setMinimumSize(new Dimension(20, progressBarHeight));
        this.progressBar.setPreferredSize(new Dimension(100, progressBarHeight));
        this.progressBar.setAlignmentX(0.0f);
        this.progressLabel = this.createJLabelFromString("");
        this.infoLabel = this.createJLabelFromString("");
        this.statusLabel = this.createJLabelFromString("");
        this.versionLabel = this.createJLabelFromString(cxcnumber + " Rev " + revision);
        this.copyrightLabel = this.createJLabelFromString(this.pm.getString("se.ericsson.security.launcher.copyright", false));
        this.splashPanel = new JPanel();
        this.splashPanel.setBackground(bgColor);
        Border innerBorder = BorderFactory.createLineBorder(bgColor, 20);
        LineBorder outerBorder = new LineBorder(lightGray, 5, true);
        this.splashPanel.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        this.splashPanel.setLayout(new BoxLayout(this.splashPanel, 1));
        this.splashPanel.add(this.logoLabel);
        this.splashPanel.add(Box.createVerticalStrut(30));
        this.splashPanel.add(this.productLabel);
        this.splashPanel.add(Box.createVerticalStrut(30));
        this.splashPanel.add(this.progressBar);
        this.splashPanel.add(Box.createVerticalStrut(5));
        this.splashPanel.add(this.infoLabel);
        this.splashPanel.add(this.statusLabel);
        this.splashPanel.add(this.progressLabel);
        this.splashPanel.add(Box.createVerticalStrut(30));
        this.splashPanel.add(this.versionLabel);
        this.splashPanel.add(Box.createVerticalStrut(5));
        this.splashPanel.add(this.copyrightLabel);
        this.splashPanel.add(Box.createVerticalStrut(15));
        this.setUndecorated(true);
    }

    private JLabel createJLabelFromString(String text) {
        JLabel label = new JLabel(text, 2);
        label.setFont(new Font("Arial", 0, 12));
        label.setForeground(fgColor);
        label.setAlignmentX(0.0f);
        return label;
    }

    private JLabel createJLabelFromImage(String imagePath, int width, int height) {
        URL url = this.getClass().getResource(imagePath);
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        image = image.getScaledInstance(width, height, 4);
        JLabel label = new JLabel(new ImageIcon(image));
        label.setBorder(BorderFactory.createEmptyBorder());
        label.setBackground(bgColor);
        label.setAlignmentX(0.0f);
        return label;
    }

    public void showSplash() {
        LOG.entering(new Object[0]);
        Runnable r = new Runnable(){

            public void run() {
                Container contentPane = SplashWindow.this.getContentPane();
                contentPane.add((Component)SplashWindow.this.splashPanel, "West");
                SplashWindow.this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension labelSize = SplashWindow.this.splashPanel.getPreferredSize();
                SplashWindow.this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
                boolean disableSplashWindow = TmProperty.DISABLE_SPLASH_WINDOW.getBoolean();
                LOG.fine("Splash window is {0}showed, due to Test Mode property DISABLE_SPLASH_WINDOW", disableSplashWindow ? "not " : "");
                SplashWindow.this.setVisible(!disableSplashWindow);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void removeSplash() {
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
                LOG.finer("close", new Object[0]);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setStatus(String statusString) {
        this.statusMsg = statusString;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.progressBar.setMaximum(10000);
                SplashWindow.this.progressBar.setValue(0);
                SplashWindow.this.progressBar.setIndeterminate(false);
                SplashWindow.this.progressLabel.setText("");
                SplashWindow.this.infoLabel.setText("");
                SplashWindow.this.statusLabel.setText(SplashWindow.this.statusMsg);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setInfo(String msg) {
        this.infoMsg = msg;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.statusLabel.setText("");
                SplashWindow.this.progressLabel.setText("");
                SplashWindow.this.progressBar.setMaximum(10000);
                SplashWindow.this.progressBar.setValue(0);
                SplashWindow.this.progressBar.setIndeterminate(false);
                SplashWindow.this.infoLabel.setText(SplashWindow.this.infoMsg);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized void setProgress(String operation, int sofar, int total) {
        this.progressOp = operation;
        this.progressSoFar = sofar;
        this.progressTotal = total;
        Runnable r = new Runnable(){

            public void run() {
                SplashWindow.this.statusLabel.setText("");
                SplashWindow.this.infoLabel.setText("");
                SplashWindow.this.progressLabel.setText(SplashWindow.this.progressOp);
                if (SplashWindow.this.progressTotal == -1) {
                    SplashWindow.this.progressBar.setIndeterminate(true);
                } else {
                    if (SplashWindow.this.progressBar.getMaximum() != SplashWindow.this.progressTotal) {
                        SplashWindow.this.progressBar.setMaximum(SplashWindow.this.progressTotal);
                    }
                    SplashWindow.this.progressBar.setValue(SplashWindow.this.progressSoFar);
                    SplashWindow.this.progressBar.setIndeterminate(false);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public synchronized DownloadListener getDownloadListener() {
        if (this.downloadListener == null) {
            this.downloadListener = new SplashDownloadListener(this);
        }
        return this.downloadListener;
    }

    public synchronized VerifyListener getVerifyListener() {
        if (this.verifyListener == null) {
            this.verifyListener = new SplashVerifyListener(this);
        }
        return this.verifyListener;
    }

    public void setUpdater(Object updater) {
        this.updater = updater;
    }

    public Object getUpdater() {
        return this.updater;
    }

    public synchronized void close() {
        this.updater = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SplashWindow.this.removeSplash();
            }
        });
    }
}

