/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.starter.ConnInfo;
import se.ericsson.security.utils.EmLogger;

public class ConnInfoHandler {
    private static final EmLogger LOG = EmLogger.STARTER;
    protected static final String IPv6_GRP_DELIM = ":";
    protected static final String IPv6_FILE_NAME_GRP_DELIM = "_";
    private static final String PORT_INFO_FILE_NAME_PREFIX = ".portinfo";
    private String networkElement;
    File[] dirs_file = null;
    static ConnInfoHandler theInstance = null;
    private int port;

    public static synchronized void resetInstance() {
        theInstance = null;
    }

    private ConnInfoHandler() {
    }

    public static synchronized ConnInfoHandler getInstance() {
        if (theInstance == null) {
            theInstance = new ConnInfoHandler();
        }
        return theInstance;
    }

    public synchronized void init(String[] secret_dirs, String root_dn, String networkElement) {
        String fileName;
        int nr = secret_dirs.length;
        this.dirs_file = new File[nr + 2];
        StringBuffer crt_dir = new StringBuffer(root_dn);
        this.dirs_file[nr + 1] = new File(crt_dir.toString() + File.separator);
        for (int cnt = nr; cnt > 0; --cnt) {
            fileName = secret_dirs[nr - cnt].replaceAll(IPv6_GRP_DELIM, IPv6_FILE_NAME_GRP_DELIM);
            crt_dir = crt_dir.append(File.separator).append(fileName);
            this.dirs_file[cnt] = new File(crt_dir.toString());
        }
        fileName = PORT_INFO_FILE_NAME_PREFIX + networkElement.replaceAll(IPv6_GRP_DELIM, IPv6_FILE_NAME_GRP_DELIM);
        this.dirs_file[0] = new File(crt_dir.append(File.separator).append(fileName).toString());
    }

    public synchronized void prepareForWrite(String[] secret_dirs, String root_dn, String networkElement) {
        try {
            if (!this.dirs_file[1].exists()) {
                this.dirs_file[1].mkdirs();
            }
        }
        catch (SecurityException e) {
            LOG.warning("Could not create base directory for .launcher files", new Object[0]);
        }
        this.networkElement = networkElement;
        for (int i = 1; i < this.dirs_file.length; ++i) {
            try {
                String chmod_command = "chmod 700 " + this.dirs_file[i].getAbsolutePath();
                if (EmasUtilities.runningOnWindows()) continue;
                Process pr = Runtime.getRuntime().exec(chmod_command);
                pr.waitFor();
                continue;
            }
            catch (IOException e) {
                LOG.warning(this.stackToString(e), new Object[0]);
                continue;
            }
            catch (InterruptedException ie) {
                LOG.warning(this.stackToString(ie), new Object[0]);
            }
        }
    }

    private String stackToString(Exception e) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(buffer, true);
        e.printStackTrace(writer);
        String returnValue = buffer.toString();
        writer.close();
        return returnValue;
    }

    private void setFileProtected() {
        try {
            if (!EmasUtilities.runningOnWindows() && this.dirs_file[0] != null) {
                String chmod_command = "chmod 600 " + this.dirs_file[0].getAbsolutePath();
                Process pr = Runtime.getRuntime().exec(chmod_command);
                pr.waitFor();
            }
        }
        catch (IOException e) {
            LOG.warning(this.stackToString(e), new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isFileProtected() {
        block14: {
            try {
                if (EmasUtilities.runningOnWindows()) break block14;
                if (this.dirs_file != null) {
                    String others;
                    String rights;
                    int space;
                    BufferedReader br;
                    Process pr;
                    String ls_command;
                    if (this.dirs_file[0] != null) {
                        ls_command = "ls -l " + this.dirs_file[0].getAbsolutePath();
                        pr = Runtime.getRuntime().exec(ls_command);
                        pr.waitFor();
                        br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        String fileInfo = br.readLine();
                        if (fileInfo == null) {
                            return false;
                        }
                        space = fileInfo.indexOf(" ");
                        if (space == -1) {
                            return false;
                        }
                        rights = fileInfo.substring(0, space);
                        if (!rights.startsWith("-rw-")) {
                            return false;
                        }
                        others = rights.substring("-rw-".length());
                        if (others.indexOf("r") != -1 || others.indexOf("w") != -1 || others.indexOf("x") != -1) {
                            LOG.severe("File tampered", new Object[0]);
                            return false;
                        }
                    } else {
                        return false;
                    }
                    for (int i = 1; i < this.dirs_file.length; ++i) {
                        if (this.dirs_file[i] != null) {
                            ls_command = "ls -ld " + this.dirs_file[i].getAbsolutePath();
                            pr = Runtime.getRuntime().exec(ls_command);
                            pr.waitFor();
                            br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                            String dirInfo = br.readLine();
                            if (dirInfo == null) {
                                return false;
                            }
                            space = dirInfo.indexOf(" ");
                            if (space == -1) {
                                return false;
                            }
                            rights = dirInfo.substring(0, space);
                            LOG.fine("Ran ls -ld on " + this.dirs_file[i].getAbsolutePath() + " and got the result " + dirInfo, new Object[0]);
                            if (!rights.startsWith("drwx")) {
                                return false;
                            }
                            others = rights.substring("drwx".length());
                            if (others.indexOf("r") == -1 && others.indexOf("w") == -1 && others.indexOf("x") == -1) continue;
                            LOG.severe("the directory " + this.dirs_file[i].getAbsolutePath() + " tampered", new Object[0]);
                            return false;
                        }
                        return false;
                    }
                    break block14;
                }
                return false;
            }
            catch (Exception e) {
                LOG.warning(this.stackToString(e), new Object[0]);
                return false;
            }
        }
        return true;
    }

    public synchronized void setPortLocal(int port) {
        this.port = port;
    }

    public synchronized int getPort() throws IOException, ClassNotFoundException {
        int port = 0;
        try {
            if (!this.dirs_file[0].exists()) {
                return 0;
            }
            if (!this.isFileProtected()) {
                if (this.dirs_file != null) {
                    for (int i = 0; i < this.dirs_file.length; ++i) {
                        if (this.dirs_file[i] == null) continue;
                        this.dirs_file[i].delete();
                    }
                }
                throw new IOException("Elements on path to .portinfo" + this.networkElement + " file tampered, will not trust port information.");
            }
            FileInputStream fis = new FileInputStream(this.dirs_file[0]);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object o = ois.readObject();
            if (o instanceof ConnInfo) {
                ConnInfo cinfo = (ConnInfo)o;
                port = cinfo.getPort();
            }
            ois.close();
            fis.close();
            return port;
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    public synchronized void setPort() {
        try {
            if (this.dirs_file != null && this.dirs_file[0] != null) {
                FileOutputStream fos = new FileOutputStream(this.dirs_file[0]);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                this.setFileProtected();
                ConnInfo cinfo = new ConnInfo();
                cinfo.setPort(this.port);
                oos.writeObject(cinfo);
                oos.flush();
                oos.close();
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void deleteConnInfo() {
        if (this.dirs_file != null) {
            for (int i = 0; i < this.dirs_file.length; ++i) {
                if (this.dirs_file[i] == null) continue;
                this.dirs_file[i].delete();
                this.dirs_file[i] = null;
            }
        }
        this.dirs_file = null;
        ConnInfoHandler.resetInstance();
    }

    public String toString() {
        String string = "ConnInfoHandler : Stored to ";
        try {
            if (this.dirs_file == null || this.dirs_file[0] == null) {
                string = string + "null";
            } else {
                string = string + this.dirs_file[0];
                string = string + " - exists=";
                string = string + this.dirs_file[0].exists();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

