/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.RevisionReader;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;

public class LoadModuleRevisionReader
implements RevisionReader {
    private MoAccessor accessor = null;
    private String expectedProductNumber = null;
    public static final String JVM = "Jvm";
    public static final String LOADMODULE = "LoadModule";
    public static final String ADM_CLASSPATH = "admClassPath";
    public static final String PRODUCT_NUMBER = "productNumber";
    public static final String PRODUCT_REVISION = "rState";

    public LoadModuleRevisionReader(MoAccessor moAccessor, String string) {
        this.accessor = moAccessor;
        this.expectedProductNumber = string;
    }

    public String readRevision(Coordinator coordinator) throws AueException {
        ManagedObject managedObject = this.accessor.lookupType(JVM).nextMo();
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute(managedObject, ADM_CLASSPATH);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            String string = (String)this.getAttribute(managedObjectArray[i], PRODUCT_NUMBER);
            if (!string.equals(this.expectedProductNumber)) continue;
            return (String)this.getAttribute(managedObjectArray[i], PRODUCT_REVISION);
        }
        throw new AueException("No LM with product number " + this.expectedProductNumber + " found in admClassPath.");
    }

    private Object getAttribute(ManagedObject managedObject, String string) throws AueException {
        Object object = null;
        try {
            object = managedObject.getAttribute(string, null);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to read attribute '" + string + "' from " + managedObject.getLocalDistinguishedName(), moAccessException);
        }
        return object;
    }
}

