/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector.actions;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.collector.actions.DeleteCollectorMo;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;

public class CreateCollectorMo
implements DataCollectorAction {
    private String identity;

    public CreateCollectorMo(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("DataCollector MO identity is null");
        }
        this.identity = string;
    }

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        this.removeExistingMo(collectorContext, coordinator);
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("DataCollector");
        try {
            moFactory.createMo(null, null, this.identity, null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to create DataCollector MO with identity '" + this.identity + "'", moAccessException);
        }
    }

    private void removeExistingMo(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        DeleteCollectorMo deleteCollectorMo = new DeleteCollectorMo(this.identity);
        if (deleteCollectorMo.findCollectorMo(collectorContext) != null) {
            deleteCollectorMo.perform(collectorContext, coordinator, null);
            collectorContext.getLogger().info(this.getClass(), "Deleted existing DataCollector MO (identity = " + this.identity + ")");
        }
    }
}

