/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.DirectedRevisionGraph;
import se.ericsson.cello.aueframework.common.Edge;
import se.ericsson.cello.aueframework.converter.ApproximatorAdapter;
import se.ericsson.cello.aueframework.converter.ConversionStep;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.EdgeAdapter;
import se.ericsson.cello.aueframework.converter.EmptyConversionStep;
import se.ericsson.cello.aueframework.converter.RevisionApproximator;
import se.ericsson.cello.aueframework.converter.SimpleRevisionApproximator;
import se.ericsson.cello.aueframework.converter.UpgradePath;
import se.ericsson.cello.aueframework.converter.UpgradePathCalculator;
import se.ericsson.cello.aueframework.converter.UpgradePathImpl;

public class ConversionGraph
implements UpgradePathCalculator {
    private DirectedRevisionGraph graph = null;
    private ConversionStep[] steps = null;
    private RevisionApproximator approximator = null;

    public ConversionGraph(ConversionStep[] conversionStepArray, RevisionApproximator revisionApproximator) {
        this.steps = conversionStepArray;
        this.approximator = revisionApproximator;
    }

    public ConversionGraph(ConversionStep[] conversionStepArray) {
        this(conversionStepArray, new SimpleRevisionApproximator());
    }

    public UpgradePath findUpgradePath(String string, String string2, ConverterContext converterContext) throws AueException {
        List<EdgeAdapter> list;
        if (this.graph == null) {
            list = new ArrayList();
            for (int i = 0; i < this.steps.length; ++i) {
                ((ArrayList)list).add(new EdgeAdapter(this.steps[i]));
                if (!(this.steps[i] instanceof EmptyConversionStep)) continue;
                ((ArrayList)list).add(new EdgeAdapter(new EmptyConversionStep(this.steps[i].getToRevision(), this.steps[i].getFromRevision())));
            }
            this.graph = new DirectedRevisionGraph(((ArrayList)list).toArray((Edge[])new Edge[((ArrayList)list).size()]), new ApproximatorAdapter(this.approximator, converterContext));
        }
        list = this.graph.findShortestPath(string, string2);
        ArrayList<ConversionStep> arrayList = new ArrayList<ConversionStep>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((EdgeAdapter)iterator.next()).getStep());
        }
        return new UpgradePathImpl(arrayList);
    }
}

