/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataDeleter;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;

public class MoDataDeleterImpl
implements MoDataDeleter {
    private MoDataFilter filter = null;
    private Collection actions = null;

    public MoDataDeleterImpl() {
    }

    public MoDataDeleterImpl(MoDataFilter moDataFilter) {
        this.setup(moDataFilter);
    }

    public void setup(MoDataFilter moDataFilter) {
        this.filter = moDataFilter;
        this.actions = new LinkedList();
    }

    public void add(MoDataAction moDataAction) {
        this.actions.add(moDataAction);
    }

    public void execute(ConverterContext converterContext) throws AueException {
        if (this.filter == null) {
            throw new AueException("This deleter wasn't properly configured -- Filter is NULL.");
        }
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Iterator iterator = moDataAccessor.find(this.filter).iterator();
        MoDataWrapper moDataWrapper = null;
        TransactionWrapper transactionWrapper = null;
        MoDataAction moDataAction = null;
        while (iterator.hasNext()) {
            moDataWrapper = (MoDataWrapper)iterator.next();
            transactionWrapper = converterContext.getTransactionWrapperFactory().create();
            Iterator iterator2 = this.actions.iterator();
            while (iterator2.hasNext()) {
                moDataAction = (MoDataAction)iterator2.next();
                moDataAction.perform(moDataWrapper, converterContext, transactionWrapper.getCoordinator());
            }
            moDataAccessor.delete(moDataWrapper, transactionWrapper.getCoordinator());
            transactionWrapper.commit();
        }
    }
}

