/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moadd.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.moadd.model.MoAddModel;
import se.ericsson.cello.emt.moadd.view.MoAddView;
import se.ericsson.cello.emt.motools.common.gui.components.ArrayGUI;
import se.ericsson.cello.emt.motools.common.gui.components.AttributeGroupManager;
import se.ericsson.cello.emt.motools.common.gui.components.AttributeJLabel;
import se.ericsson.cello.emt.motools.common.gui.components.CompactGridLayout;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.GuiRow;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextField;
import se.ericsson.cello.emt.motools.common.gui.components.SmartProperties;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUIDocumentListener;
import se.ericsson.cello.emt.motools.common.gui.components.StructGUI;
import se.ericsson.cello.emt.motools.common.momodel.AttributeModel;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.ParentMo;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueFactory;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public class MoAddGUI
extends JFrame
implements GUI_Container,
MoAddView {
    private static final long serialVersionUID = 1732738969008184228L;
    private static final String MO_CLASS_TOOLTIP = "Select the MO class. Mandatory.";
    private String noMoClassAvailable = "No MO class available";
    private String noMoClassSelected = "No MO class selected";
    private boolean isParentLdnValid = true;
    private SmartProperties properties;
    private String moType = null;
    private static final String NO_MO_TYPE_SELECTED = "          ";
    protected DataTypeGUI myObjectRefGUI = null;
    private boolean stateInResettingObject = false;
    private MoAddModel myModel = null;
    private ParentMo myParentMo = null;
    private MoTemplate myTemplate = null;
    private LabelledComponentTable attributesP = null;
    private AttributeGroupManager myGroups = null;
    private JPanel attrPanel = null;
    private JButton okB = null;
    private JButton resetB = null;
    private SmartNameField namefield = null;
    private int numberOfSubClasses = 0;
    private JScrollPane scroller = null;
    private JComboBox classCombo = null;
    private final Cursor waitCursor = new Cursor(3);
    protected InformationButtonGui myInfoButtonGui = null;
    private JButton helpB = null;
    private JButton closeB = null;
    private ActionListener myHelpButtonActionListener = null;
    private JButton emHelpB = null;
    private ActionListener myEmHelpButtonActionListener = null;
    private ActionListener myCloseButtonActionListener = null;
    private ActionListener myResetButtonActionListener = null;
    private ActionListener myOkButtonActionListener = null;
    private ItemListener myClassComboItemListener = null;
    private DocumentListener myNamefieldListener = null;
    private JPanel namepanel = null;
    Mo sourceMo = null;
    String myParentLdn = null;
    String mySourceLdn = null;
    private JPanel statusPanel = null;
    private JTextField statusTextField = null;

    public MoAddGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            MoAddLog.logger().log(Level.INFO, "Was not able to set the correct look and feel of the system.\n");
        }
    }

    public void initialize() {
        this.buildGui();
        this.setSize(600, 800);
        this.setLocationRelativeTo(null);
    }

    public void execute() {
        MoAddLog.logger().log(Level.FINE, "Tries to create a new object instance");
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    MoAddGUI.this.execute();
                }
            };
            new Thread(runner).start();
            return;
        }
        String new_name = this.namefield.getText();
        try {
            GuiRow[] rows = this.myGroups.getGuiRows();
            AttributeModel attr = null;
            GuiRow oneRow = null;
            DataTypeGUI guiAttr = null;
            if (rows != null && rows.length > 0) {
                for (int i = 0; i < rows.length; ++i) {
                    oneRow = rows[i];
                    Component comp = oneRow.stateIndicator;
                    guiAttr = oneRow.dataGui;
                    attr = oneRow.attr;
                    if (guiAttr.isModified()) {
                        MoAddLog.logger().log(Level.FINEST, "The attribute " + guiAttr.getName() + " has been modified");
                        guiAttr.applyValue();
                        if (!this.toBeIncluded(guiAttr)) continue;
                        continue;
                    }
                    if (!(comp instanceof JLabel) || !attr.getMomAttribute().isMandatory()) continue;
                    MoAddLog.logger().log(Level.WARNING, "The " + guiAttr.getName() + " is manadatory");
                    guiAttr.applyValue();
                }
            }
            this.myModel.createMO(this.myTemplate, new_name, this.myParentLdn, this.sourceMo);
            this.setStatusMessage("MO added successfully");
        }
        catch (Exception e) {
            MoAddLog.logger().log(Level.WARNING, "Failed to create MO");
            MessageDialogFactory.createMessageDialog((String)"Failed to create MO", (Exception)e, (boolean)false, (JFrame)this).setVisible(true);
        }
    }

    private boolean toBeIncluded(DataTypeGUI dataTypeGui) {
        DataTypeGUI[] theMembers = null;
        DataTypeGUI thisMember = null;
        boolean includeMe = false;
        if (dataTypeGui instanceof ArrayGUI) {
            theMembers = ((ArrayGUI)dataTypeGui).getMemberGUIs();
            for (int i = 0; i < theMembers.length; ++i) {
                thisMember = theMembers[i];
                if (thisMember instanceof ArrayGUI || thisMember instanceof StructGUI) {
                    if (!this.toBeIncluded(thisMember)) continue;
                    includeMe = true;
                } else {
                    if (thisMember.getValue() == null || thisMember.getValue().length() <= 0) continue;
                    includeMe = true;
                }
                break;
            }
        } else if (dataTypeGui instanceof StructGUI) {
            theMembers = ((StructGUI)dataTypeGui).getMemberGUIs();
            for (int i = 0; i < theMembers.length; ++i) {
                thisMember = theMembers[i];
                if (thisMember instanceof ArrayGUI || thisMember instanceof StructGUI) {
                    if (!this.toBeIncluded(thisMember)) continue;
                    includeMe = true;
                } else {
                    if (thisMember.getValue() == null || thisMember.getValue().length() <= 0) continue;
                    includeMe = true;
                }
                break;
            }
        } else if (dataTypeGui.getValue() != null && dataTypeGui.getValue().length() > 0) {
            includeMe = true;
        }
        return includeMe;
    }

    public void exit() {
        MoAddLog.logger().log(Level.INFO, "Exit Add MO");
        this.destroy();
        this.dispose();
    }

    private void destroy() {
        this.removeListeners(this.namepanel);
        if (this.namefield != null) {
            this.namefield.getDocument().removeDocumentListener(this.myNamefieldListener);
            this.myNamefieldListener = null;
            this.namefield = null;
        }
        if (this.closeB != null) {
            this.closeB.removeActionListener(this.myCloseButtonActionListener);
            this.closeB.getInputMap().clear();
            this.closeB.getActionMap().clear();
            this.myCloseButtonActionListener = null;
            this.closeB = null;
        }
        if (this.helpB != null) {
            this.helpB.removeActionListener(this.myHelpButtonActionListener);
            this.helpB.getInputMap().clear();
            this.helpB.getActionMap().clear();
            this.helpB = null;
        }
        if (this.emHelpB != null) {
            this.emHelpB.removeActionListener(this.myEmHelpButtonActionListener);
            this.emHelpB.getInputMap().clear();
            this.emHelpB.getActionMap().clear();
            this.emHelpB = null;
        }
        if (this.resetB != null) {
            this.resetB.removeActionListener(this.myResetButtonActionListener);
            this.myResetButtonActionListener = null;
            this.resetB = null;
        }
        if (this.okB != null) {
            this.okB.removeActionListener(this.myOkButtonActionListener);
            this.myOkButtonActionListener = null;
            this.okB = null;
        }
        if (this.classCombo != null) {
            this.classCombo.removeItemListener(this.myClassComboItemListener);
            this.myClassComboItemListener = null;
            this.classCombo = null;
        }
        if (this.attributesP != null) {
            this.removeListeners(this.attributesP);
            this.attributesP.removeAll();
            this.attributesP = null;
        }
        this.getContentPane().removeAll();
        this.scroller = null;
        if (this.myGroups != null) {
            this.myGroups.destroy();
        }
        if (this.attrPanel != null) {
            this.attrPanel.removeAll();
            this.attrPanel = null;
        }
    }

    private void removeListeners(Container comp) {
        MoAddLog.logger().log(Level.FINEST, "Remove listeners");
        int removed = 0;
        int numberOfComponents = comp.getComponentCount();
        for (int i = 0; i < numberOfComponents; ++i) {
            Component compTmp = comp.getComponent(i);
            if (compTmp instanceof AbstractButton) {
                EventListener[] listeners = compTmp.getListeners(ActionListener.class);
                for (int j = 0; j < listeners.length; ++j) {
                    ((AbstractButton)compTmp).removeActionListener((ActionListener)listeners[j]);
                    ++removed;
                }
                continue;
            }
            if (compTmp instanceof DataTypeGUI) {
                ((DataTypeGUI)compTmp).removeListeners();
                continue;
            }
            if (!(compTmp instanceof Container)) continue;
            this.removeListeners((Container)compTmp);
        }
    }

    private void setWaitCursor(boolean state) {
        block5: {
            final boolean wait = state;
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    if (wait) {
                        this.setCursor(this.waitCursor);
                        break block5;
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
                catch (Exception x) {}
            } else {
                Runnable runthis = new Runnable(){

                    public void run() {
                        MoAddGUI.this.setWaitCursor(wait);
                    }
                };
                SwingUtilities.invokeLater(runthis);
            }
        }
    }

    private void displayAttributes() {
        MoAddLog.logger().log(Level.FINEST, "Display attributes");
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                this.scroller.setViewportView(this.buildAttributesArea());
                this.validate();
                this.sendEmNiotification(GuiTestEventTypes.MO_ADD_ATTRIBUTES_UPDATED, "Attributes section updated");
            }
            catch (Exception x) {
                MoAddLog.logger().log(Level.SEVERE, "Error in Attribute presentation");
                MessageDialogFactory.createMessageDialog((String)"Error in Attribute presentation", (Exception)x, (boolean)true, (JFrame)this).setVisible(true);
            }
            this.setWaitCursor(false);
        } else {
            Runnable runthis = new Runnable(){

                public void run() {
                    MoAddGUI.this.displayAttributes();
                }
            };
            SwingUtilities.invokeLater(runthis);
        }
    }

    private void clearInputs() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.namefield.setValue("");
            this.myGroups.removeAllGui(this.attrPanel);
            this.scroller.setViewportView(new JPanel());
            this.validate();
        } else {
            Runnable runthis = new Runnable(){

                public void run() {
                    MoAddGUI.this.clearInputs();
                }
            };
            SwingUtilities.invokeLater(runthis);
        }
    }

    private Container buildAttributesArea() {
        MoAddLog.logger().log(Level.FINEST, "build Attributes Area");
        this.myGroups.removeAllGui(this.attrPanel);
        GuiRow oneRow = null;
        String sourceLDN = this.myModel.getConfiguration().getSourceMO();
        List<AttributeModel> attrModelList = null;
        if (sourceLDN != null) {
            try {
                this.sourceMo = this.myModel.getToolServices().getNodeServices().getNode().getCmService().getMo(sourceLDN);
            }
            catch (StartFailureException e1) {
                throw new RuntimeException("Failed to retrieve NodeServices, " + e1);
            }
            attrModelList = this.myTemplate.getAttributeModelsWithSrcLdnValue(this.sourceMo);
        } else {
            attrModelList = this.myTemplate.getDefaultAttributeModels();
        }
        for (AttributeModel attr : attrModelList) {
            MoAddLog.logger().log(Level.FINEST, "Add " + attr.getMomAttribute().getName() + " to Attributes Area");
            if (attr.isReadOnly()) continue;
            oneRow = new GuiRow();
            oneRow.attr = attr;
            oneRow.guiLabel = attr.getName();
            this.myGroups.guiRowsList.add(oneRow);
            this.myGroups.addAttribute(attr);
            oneRow.lcTable = this.attributesP = this.myGroups.getAttributePanel(attr);
            JPanel infoAndNameLabel = new JPanel(new FlowLayout(0, 5, 0));
            infoAndNameLabel.setName(attr.getName() + "_Name");
            InformationButtonGui infoButtonGui = new InformationButtonGui(this, this.myModel.getToolServices());
            infoButtonGui.setMargin(new Insets(0, 0, 0, 1));
            infoButtonGui.setName(attr.getName());
            infoButtonGui.setDescription(attr.getMomAttribute().getExtendedDescription());
            infoAndNameLabel.add(infoButtonGui);
            infoAndNameLabel.add(new AttributeJLabel(attr));
            this.attributesP.addI(infoAndNameLabel);
            boolean optionalAttribute = false;
            JLabel stateIcon = null;
            JCheckBox checkB = new JCheckBox("", true);
            checkB.setOpaque(false);
            if (attr.getMomAttribute().isMandatory()) {
                stateIcon = new JLabel("*");
                stateIcon.setHorizontalAlignment(4);
                stateIcon.setFont(new Font("sansserif", 0, 16));
                stateIcon.setToolTipText("Mandatory value");
                this.attributesP.addI(stateIcon);
                oneRow.stateIndicator = stateIcon;
            } else {
                this.attributesP.addI(checkB);
                checkB.setVisible(false);
                optionalAttribute = true;
                oneRow.stateIndicator = checkB;
            }
            boolean readOnly = attr.isReadOnly();
            MoAddLog.logger().log(Level.FINEST, "Create Attribute GUI");
            final DataTypeGUI valueGUI = ComponentFactory.create(attr.getTypeValue(), readOnly, this, attr.getName(), true, this.myModel.getToolServices());
            valueGUI.setLayout(new FlowLayout(0, 0, 8));
            this.attributesP.addI(valueGUI);
            oneRow.dataGui = valueGUI;
            if (optionalAttribute) {
                valueGUI.setGUIEditable(true);
            }
            checkB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        valueGUI.setGUIEditable(true);
                    } else {
                        valueGUI.setGUIEditable(false);
                    }
                }
            });
        }
        return this.myGroups.doLayout(this.attrPanel);
    }

    public void buildGui() {
        MoAddLog.logger().log(Level.INFO, "Create the GUI");
        this.statusTextField = new JTextField();
        this.myGroups = new AttributeGroupManager(this, this.properties, this.myModel.getToolServices());
        this.attrPanel = new JPanel();
        this.attrPanel.setName("attributeNamePanel");
        this.attrPanel.setLayout(new BoxLayout(this.attrPanel, 1));
        if (this.moType != null) {
            this.setTitle(this.myModel.getConfiguration().getTitle() + " " + this.moType);
        } else {
            this.setTitle(this.myModel.getConfiguration().getTitle());
        }
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setIconImage(this.myModel.getConfiguration().getIconImage());
        this.namepanel = new JPanel();
        this.namepanel.setOpaque(false);
        this.namepanel.setLayout(new CompactGridLayout(3, 2, 2));
        this.namepanel.add(new JLabel(" Parent:  "));
        MoAddLog.logger().log(Level.FINEST, "Create the parent id");
        try {
            CmService cmServ = this.myModel.getToolServices().getNodeServices().getNode().getCmService();
            Mo parentLdnMo = cmServ.getMo(this.myModel.getParentLDN());
            if (!parentLdnMo.exists()) {
                MoAddLog.logger().log(Level.SEVERE, this.myModel.getParentLDN() + " does not exist on the node");
                throw new RuntimeException("The parent ldn " + this.myModel.getParentLDN() + " does not exist on the node.");
            }
            NameValue parentLdnAsNameValue = cmServ.getNameValueFactory().create("dummyName", parentLdnMo);
            MimModel mimModel = this.myModel.getToolServices().getNodeServices().getMimModel();
            MomClass parentLdnAsMomClass = mimModel.getClass(parentLdnMo.getType());
            TypeValue typeValue = TypeValueFactory.createTypeValue((MomEntity)parentLdnAsMomClass, parentLdnAsNameValue, cmServ);
            this.myObjectRefGUI = ComponentFactory.create(typeValue, false, new ParentLdnListener(), null, true, this.myModel.getToolServices());
            this.myObjectRefGUI.setName("parentPanel");
            this.namepanel.add(this.myObjectRefGUI.getPanel());
        }
        catch (StartFailureException e) {
            MoAddLog.logger().log(Level.SEVERE, "Failed to get the the parent ld");
            MessageDialogFactory.createMessageDialog((String)"Failed to get the the parent ld", (Exception)e, (boolean)true, (JFrame)this).setVisible(true);
        }
        this.namepanel.add(new JLabel(""));
        this.namepanel.add(new JLabel(" MO class:  "));
        this.classCombo = new JComboBox();
        this.classCombo.setName("childrenClassCombo");
        this.classCombo.setToolTipText(MO_CLASS_TOOLTIP);
        JPanel combopanel = new JPanel();
        JLabel starIcon = new JLabel("*");
        starIcon.setHorizontalAlignment(4);
        starIcon.setFont(new Font("sansserif", 0, 16));
        starIcon.setToolTipText("Mandatory value");
        combopanel.add(starIcon);
        combopanel.add(this.classCombo);
        JPanel comboBoxAndInfoPanel = new JPanel(new FlowLayout(0, 5, 0));
        comboBoxAndInfoPanel.setOpaque(false);
        comboBoxAndInfoPanel.setLayout(new CompactGridLayout(2, 2, 2));
        this.myInfoButtonGui = new InformationButtonGui(this, this.myModel.getToolServices());
        comboBoxAndInfoPanel.setName("comboBoxAndInfoPanel");
        comboBoxAndInfoPanel.add(this.myInfoButtonGui.getPanel());
        comboBoxAndInfoPanel.add(combopanel);
        this.namepanel.add(comboBoxAndInfoPanel);
        this.namepanel.add(new JLabel(""));
        if (this.moType == null) {
            this.classCombo.addItem(NO_MO_TYPE_SELECTED);
        }
        this.myParentLdn = this.myObjectRefGUI.getValue();
        this.mySourceLdn = this.myModel.getConfiguration().getSourceMO();
        this.numberOfSubClasses = this.myParentMo.getPossibleChildrenMOs(this.myParentLdn).size();
        MoAddLog.logger().log(Level.FINEST, "Number of possible children = " + this.numberOfSubClasses);
        this.populateClassComboBox(this.moType);
        this.myClassComboItemListener = new ItemListener(){

            public void itemStateChanged(final ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (MoAddGUI.this.isParentLdnValid) {
                        MoAddGUI.this.setStatusMessage("");
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        Runnable runner = new Runnable(){

                            public void run() {
                                this.itemStateChanged(e);
                            }
                        };
                        new Thread(runner).start();
                    } else {
                        MoAddGUI.this.changeAttributesArea();
                        MoAddGUI.this.namefield.setValue("");
                    }
                }
            }
        };
        this.classCombo.addItemListener(this.myClassComboItemListener);
        JLabel tag = new JLabel(" ID:  ");
        this.namepanel.add(tag);
        JLabel stateIcon = new JLabel("*");
        stateIcon.setHorizontalAlignment(4);
        stateIcon.setFont(new Font("sansserif", 0, 16));
        stateIcon.setToolTipText("Mandatory value");
        JPanel stateIconAndNameFiled = new JPanel(new FlowLayout(0, 5, 0));
        stateIconAndNameFiled.add(stateIcon);
        this.namefield = new SmartNameField("", false);
        this.namefield.setName("idNameField");
        this.myNamefieldListener = new StringGUIDocumentListener(this);
        this.namefield.getDocument().addDocumentListener(this.myNamefieldListener);
        this.namefield.setToolTipText("MO instance ID");
        stateIconAndNameFiled.add(this.namefield);
        this.namepanel.add(stateIconAndNameFiled);
        this.namepanel.add(new JLabel(""));
        this.namepanel.add(new JLabel("           "));
        this.namepanel.add(new JLabel(NO_MO_TYPE_SELECTED));
        this.namepanel.add(new JLabel(""));
        JScrollPane namePScroller = new JScrollPane(21, 30);
        namePScroller.getHorizontalScrollBar().setUnitIncrement(50);
        namePScroller.setViewportView(this.namepanel);
        this.getContentPane().add((Component)namePScroller, "North");
        this.scroller = new JScrollPane(20, 30);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(50);
        this.scroller.getVerticalScrollBar().setUnitIncrement(30);
        this.scroller.setName("attrScroller");
        this.getContentPane().add((Component)this.scroller, "Center");
        if (null != this.myTemplate) {
            int num = 0;
            try {
                num = this.myTemplate.getDefaultAttributeModels().size();
            }
            catch (Exception x) {
                MoAddLog.logger().warning("MoAddGUI got exception while calling getDefaultAttributeModels. " + x);
            }
            if (num > 0) {
                this.scroller.setViewportView(this.buildAttributesArea());
            }
        }
        JPanel southP = new JPanel(new BorderLayout());
        southP.add((Component)this.getStatusPanel(), "South");
        JPanel buttonP = new JPanel(new FlowLayout(2));
        southP.add((Component)buttonP, "Center");
        buttonP.setBackground(this.getContentPane().getBackground());
        this.getContentPane().add((Component)southP, "South");
        this.okB = new JButton(" Add ");
        this.okB.setMnemonic('A');
        buttonP.add(this.okB);
        this.okB.setEnabled(false);
        this.myOkButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.execute();
                MoAddGUI.this.okB.setEnabled(false);
                MoAddGUI.this.setWaitCursor(false);
                MoAddGUI.this.sendEmNiotification(GuiTestEventTypes.MO_ADD_BUTTON_ENABLED, "The MoAdd button is enabled.");
            }
        };
        this.okB.addActionListener(this.myOkButtonActionListener);
        this.closeB = new JButton(" Close ");
        buttonP.add(this.closeB);
        this.myCloseButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.myModel.getToolServices().exit();
            }
        };
        this.closeB.addActionListener(this.myCloseButtonActionListener);
        this.closeB.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "");
        this.closeB.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 8264847325046981665L;

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.myModel.getToolServices().exit();
            }
        });
        this.resetB = new JButton(" Reset ");
        this.resetB.setMnemonic('R');
        buttonP.add(this.resetB);
        this.myResetButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.reBuildAttributesGUI();
            }
        };
        this.resetB.addActionListener(this.myResetButtonActionListener);
        JButton helpB = new JButton("MO Help");
        helpB.setMnemonic('M');
        buttonP.add(helpB);
        this.myHelpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.displayMoHelp();
            }
        };
        helpB.addActionListener(this.myHelpButtonActionListener);
        this.emHelpB = new JButton("Help");
        buttonP.add(this.emHelpB);
        this.myEmHelpButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MoAddGUI.this.displayMoAddUGHelp();
            }
        };
        this.emHelpB.addActionListener(this.myEmHelpButtonActionListener);
        this.emHelpB.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "");
        this.emHelpB.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 7963860384430745911L;

            public void actionPerformed(ActionEvent ae) {
                MoAddGUI.this.displayMoAddUGHelp();
            }
        });
        if (this.moType != null) {
            this.classCombo.addItem(this.moType);
            this.classCombo.setSelectedIndex(0);
        }
        this.pack();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
        if (this.validateParameters()) {
            this.okB.setEnabled(true);
            this.sendEmNiotification(GuiTestEventTypes.MO_ADD_BUTTON_ENABLED, "The MoAdd button is enabled.");
        } else {
            this.okB.setEnabled(false);
        }
    }

    private void populateClassComboBox(String moType) {
        boolean moTypeFound = false;
        List<MoTemplate> moTypeCollection = this.myParentMo.getPossibleChildrenMOs(this.myParentLdn);
        if (null == moType) {
            moTypeFound = true;
            MoAddLog.logger().log(Level.FINEST, "Add items to classComboBox");
            for (MoTemplate temp : this.myParentMo.getPossibleChildrenMOs(this.myParentLdn)) {
                this.classCombo.addItem(temp.getName());
            }
        } else {
            for (MoTemplate temp : moTypeCollection) {
                if (!temp.getName().equals(moType)) continue;
                moTypeFound = true;
            }
        }
        if (!moTypeFound) {
            MoAddLog.logger().log(Level.SEVERE, "The MO class " + moType + " does not exist as subclass to " + this.myParentMo.getMoRef(this.myParentLdn).getType());
            throw new RuntimeException("The MO class " + moType + " does not exist as subclass to " + this.myParentMo.getMoRef(this.myParentLdn).getType());
        }
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.add((Component)this.getStatusTextField(), "Center");
        }
        return this.statusPanel;
    }

    private JTextField getStatusTextField() {
        this.statusTextField.setEditable(false);
        this.statusTextField.setOpaque(false);
        return this.statusTextField;
    }

    public void setStatusMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    MoAddGUI.this.setStatusMessage(message);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        MoAddLog.logger().log(Level.FINEST, " setStatusMessage: " + message);
        this.statusTextField.setText(message);
    }

    public void resetObject() {
        this.stateInResettingObject = true;
        GuiRow[] rows = this.myGroups.getGuiRows();
        if (rows != null) {
            int numberOfAttributes = rows.length;
            for (int i = 0; i < numberOfAttributes; ++i) {
                DataTypeGUI guiAttr = rows[i].dataGui;
                guiAttr.refreshValue();
            }
        }
        this.validate();
        this.stateInResettingObject = false;
        this.valueChanged();
        this.setWaitCursor(false);
    }

    public void updateNeeded() {
        this.validate();
    }

    public void valueChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatusMessage("");
            if (this.stateInResettingObject) {
                return;
            }
            if (this.myParentMo.isValidParentLdn(this.myParentLdn, this.mySourceLdn)) {
                if (this.validateParameters()) {
                    this.okB.setEnabled(true);
                    this.sendEmNiotification(GuiTestEventTypes.MO_ADD_BUTTON_ENABLED, "The MoAdd button is enabled.");
                } else {
                    this.okB.setEnabled(false);
                }
            } else {
                this.okB.setEnabled(false);
            }
        } else {
            Runnable runthis = new Runnable(){

                public void run() {
                    MoAddGUI.this.valueChanged();
                }
            };
            SwingUtilities.invokeLater(runthis);
        }
    }

    public boolean validateParameters() {
        if (((String)this.classCombo.getSelectedItem()).equals(NO_MO_TYPE_SELECTED)) {
            return false;
        }
        if (this.namefield.getText().equals("")) {
            return false;
        }
        boolean returnValue = true;
        GuiRow[] rows = this.myGroups.getGuiRows();
        if (rows == null || rows.length <= 0) {
            return true;
        }
        AttributeModel attr = null;
        GuiRow oneRow = null;
        DataTypeGUI dataGui = null;
        for (int i = 0; i < rows.length; ++i) {
            oneRow = rows[i];
            attr = oneRow.attr;
            if (attr.isReadOnly()) continue;
            dataGui = oneRow.dataGui;
            boolean faultyValue = dataGui.faultyValueEntered();
            if (faultyValue) {
                returnValue = false;
                break;
            }
            if (!attr.getMomAttribute().isMandatory() || this.isFilled(dataGui)) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    private boolean isFilled(DataTypeGUI dataTypeGui) {
        DataTypeGUI[] theMembers = null;
        DataTypeGUI thisMember = null;
        boolean filled = true;
        if (dataTypeGui instanceof ArrayGUI) {
            theMembers = ((ArrayGUI)dataTypeGui).getMemberGUIs();
            if (theMembers.length == 0) {
                filled = false;
            } else {
                for (int i = 0; i < theMembers.length; ++i) {
                    thisMember = theMembers[i];
                    if (thisMember instanceof ArrayGUI || thisMember instanceof StructGUI) {
                        if (this.isFilled(thisMember)) continue;
                        filled = false;
                    } else {
                        if (thisMember.getValue() != null && thisMember.getValue().length() > 0) continue;
                        filled = false;
                    }
                    break;
                }
            }
        } else if (dataTypeGui instanceof StructGUI) {
            theMembers = ((StructGUI)dataTypeGui).getMemberGUIs();
            for (int i = 0; i < theMembers.length; ++i) {
                thisMember = theMembers[i];
                if (thisMember instanceof ArrayGUI || thisMember instanceof StructGUI) {
                    if (this.isFilled(thisMember)) continue;
                    filled = false;
                } else {
                    if (thisMember.getValue() != null && thisMember.getValue().length() > 0) continue;
                    filled = false;
                }
                break;
            }
        } else {
            filled = dataTypeGui.getValue() != null && dataTypeGui.getValue().length() > 0;
        }
        return filled;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.myModel.getToolServices().exit();
        } else {
            super.processWindowEvent(e);
        }
    }

    public void setModel(MoAddModel model) {
        this.myModel = model;
        this.myParentMo = this.myModel.getParentMo();
        String mySourceMo = this.myModel.getConfiguration().getSourceMO();
        if (null != mySourceMo) {
            try {
                this.moType = this.myModel.getToolServices().getNodeServices().getNode().getCmService().getMo(mySourceMo).getType();
            }
            catch (StartFailureException e) {
                throw new RuntimeException("Failed to retrieve NodeServices, " + e);
            }
        }
        if (null == this.moType) {
            this.moType = this.myModel.getConfiguration().getMoClass();
        }
    }

    public void showUI(boolean visible) {
        this.setVisible(visible);
        this.sendEmNiotification(GuiTestEventTypes.MO_ADD_STARTED, "The MOAdd window is shown.");
    }

    private void reBuildAttributesGUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            MoAddLog.logger().log(Level.FINEST, "Re-building the GUI");
            this.changeAttributesArea();
        } else {
            Runnable runthis = new Runnable(){

                public void run() {
                    MoAddGUI.this.reBuildAttributesGUI();
                }
            };
            SwingUtilities.invokeLater(runthis);
        }
    }

    private void changeAttributesArea() {
        Object selectedMoClassName = this.classCombo.getModel().getSelectedItem();
        if (selectedMoClassName == null || NO_MO_TYPE_SELECTED.equals(selectedMoClassName.toString()) || !this.isParentLdnValid) {
            MoAddLog.logger().log(Level.FINEST, this.noMoClassSelected);
            this.myInfoButtonGui.setDescription(this.noMoClassSelected);
            this.clearInputs();
            this.okB.setEnabled(false);
        } else {
            MoAddLog.logger().log(Level.FINEST, "Item " + selectedMoClassName + " selected");
            try {
                this.myTemplate = null;
                this.clearInputs();
                if (this.myParentMo == null) {
                    MoAddLog.logger().log(Level.WARNING, "myParentMo is null");
                }
                if (this.myParentLdn == null) {
                    MoAddLog.logger().log(Level.WARNING, "myParentLdn is null");
                }
                List<MoTemplate> templateList = this.myParentMo.getPossibleChildrenMOs(this.myParentLdn);
                for (MoTemplate template : templateList) {
                    MomClass momClass = template.getMomClass();
                    if (momClass == null) {
                        MoAddLog.logger().log(Level.WARNING, "momClass is null");
                        continue;
                    }
                    String momClassName = momClass.getName();
                    if (momClassName == null) {
                        MoAddLog.logger().log(Level.WARNING, "momClassName is null");
                        continue;
                    }
                    if (!momClassName.equals(selectedMoClassName)) continue;
                    this.myTemplate = template;
                    MoAddLog.logger().log(Level.FINER, "Working on mo class " + momClassName);
                    break;
                }
                if (this.myTemplate != null) {
                    String text = this.myTemplate.getMomClass().getDescription();
                    this.myInfoButtonGui.setDescription(text);
                    this.myInfoButtonGui.setName(this.myTemplate.getMomClass().getName());
                    List<AttributeModel> listAttribute = this.myTemplate.getDefaultAttributeModels();
                    if (listAttribute == null) {
                        MoAddLog.logger().log(Level.WARNING, "The default attribute model is null");
                    }
                    if (this.myTemplate.getDefaultAttributeModels().size() > 0) {
                        this.displayAttributes();
                    }
                } else {
                    MoAddLog.logger().log(Level.WARNING, "The mo class was not found");
                    this.myInfoButtonGui.setDescription(this.noMoClassSelected);
                    this.clearInputs();
                    this.okB.setEnabled(false);
                }
            }
            catch (Exception e1) {
                MoAddLog.logger().warning("Exception at changeAttributesArea. " + e1);
            }
        }
    }

    private void displayMoHelp() {
        if (this.classCombo.getSelectedItem().equals(NO_MO_TYPE_SELECTED)) {
            String moTypeRoot = this.myModel.getParentMo().getMoRef(this.myParentLdn).getType();
            this.myModel.getToolServices().runHelp("class " + moTypeRoot, "");
        } else {
            String moType = (String)this.classCombo.getSelectedItem();
            this.myModel.getToolServices().runHelp("class " + moType, "");
        }
    }

    private void displayMoAddUGHelp() {
        String cpiTitle = "Element Manager";
        String chapterTag = "moAddHelp";
        this.myModel.getToolServices().runHelp(cpiTitle, chapterTag);
    }

    private void sendEmNiotification(String eventType, String message) {
        this.myModel.getToolServices().sendEmNotification(eventType, message, null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
    }

    class ParentLdnListener
    implements GUI_Container {
        ParentLdnListener() {
        }

        public void updateNeeded() {
        }

        public void valueChanged() {
            MoAddGUI.this.myParentLdn = MoAddGUI.this.myObjectRefGUI.getValue();
            if (!MoAddGUI.this.myParentMo.isValidParentLdn(MoAddGUI.this.myParentLdn, MoAddGUI.this.mySourceLdn)) {
                MoAddGUI.this.isParentLdnValid = false;
                if (MoAddGUI.this.mySourceLdn == null) {
                    MoAddGUI.this.classCombo.removeAllItems();
                    MoAddGUI.this.classCombo.addItem(MoAddGUI.this.noMoClassAvailable);
                    MoAddGUI.this.setStatusMessage("Invalid LDN, or Parent class has no available MO classes.");
                } else {
                    MoAddGUI.this.changeAttributesArea();
                    MoAddGUI.this.setStatusMessage("Invalid LDN, or Parent class is not valid for selected MO class.");
                }
                MoAddGUI.this.okB.setEnabled(false);
            } else {
                MoAddGUI.this.setStatusMessage("");
                MoAddGUI.this.isParentLdnValid = true;
                if (MoAddGUI.this.mySourceLdn == null) {
                    MoAddGUI.this.classCombo.removeAllItems();
                    MoAddGUI.this.classCombo.addItem(MoAddGUI.NO_MO_TYPE_SELECTED);
                    MoAddGUI.this.populateClassComboBox(MoAddGUI.this.moType);
                } else {
                    MoAddGUI.this.changeAttributesArea();
                }
            }
        }
    }

    class SmartNameField
    extends OE_Attr_TextField {
        private static final long serialVersionUID = 7529203027847562791L;
        private final int MAX_WIDTH = 500;
        private final int MIN_WIDTH_RO = 150;
        private final int MIN_WIDTH_RW = 150;

        SmartNameField(String value, boolean readOnly) {
            super(value);
            this.MAX_WIDTH = 500;
            this.MIN_WIDTH_RO = 150;
            this.MIN_WIDTH_RW = 150;
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int width = fm.stringWidth(this.getText()) + 2 * fm.getMaxAdvance();
            width = this.isEditable() ? Math.max(width, 150) : Math.max(width, 150);
            width = Math.min(width, 500);
            return new Dimension(width, super.getPreferredSize().height);
        }

        public void setValue(String value) {
            this.setText(value);
        }

        public boolean verifyInput(String attemptedValue) {
            return true;
        }
    }
}

