/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.config.impl.CommonConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoPropConfiguration
extends CommonConfiguration {
    private static final String ACTION_NAME_KEY = "MOACTION";
    private static final String SELECTED_ATTRIBUTES_NAME_KEY = "SELECTED_ATTRIBUTES";
    private static final String PROGRESS_DISPLAY_OF_ACTION_EXECUTION = "PROGRESS_DISPLAY_OF_ACTION_EXECUTION";
    private static final String PROGRESS_COUNT_ATTRIBUTE = "PROGRESS_COUNT_ATTRIBUTE";
    private static final String PROGRESS_START = "PROGRESS_START";
    private static final String PROGRESS_TOTAL = "PROGRESS_TOTAL";
    private static final String PROGRESS_SUPERVISION_ATTRIBUTES = "PROGRESS_SUPERVISION_ATTRIBUTES";
    private static final String PROGRESS_STOP_ATTRIBUTES = "PROGRESS_STOP_ATTRIBUTES";
    private static final String PROGRESS_DISPLAY_ATTRIBUTE = "PROGRESS_DISPLAY_ATTRIBUTE";
    private static final String PROGRESS_ADDITIONAL_ACTION = "PROGRESS_ADDITIONAL_ACTION";
    private static final String MOACTION_PARAMETER_VALUES = "MOACTION_PARAMETER_VALUES";
    private static final String EXPAND_STRUCTS = "EXPAND_STRUCTS";
    private static final String EXPAND_SEQUENCES = "EXPAND_SEQUENCES";

    public MoPropConfiguration(Properties properties) {
        super(properties);
    }

    @Override
    public String getTitle() {
        return this.getAddress() + " - " + this.getManagerTitle();
    }

    @Override
    public String getSelectedActionName() {
        return this.properties.getProperty(ACTION_NAME_KEY);
    }

    @Override
    public List<String> getSelectedAttrNames() {
        return this.getAttributes(SELECTED_ATTRIBUTES_NAME_KEY);
    }

    @Override
    public boolean displayActionProgress() {
        boolean display = false;
        String propValue = this.properties.getProperty(PROGRESS_DISPLAY_OF_ACTION_EXECUTION);
        if (null != propValue && (propValue.equalsIgnoreCase("true") || propValue.equalsIgnoreCase("yes"))) {
            display = true;
        }
        return display;
    }

    @Override
    public String getProgressCountAttribute() {
        return this.properties.getProperty(PROGRESS_COUNT_ATTRIBUTE);
    }

    @Override
    public String getProgressStart() {
        return this.properties.getProperty(PROGRESS_START);
    }

    @Override
    public String getProgressTotal() {
        return this.properties.getProperty(PROGRESS_TOTAL);
    }

    @Override
    public List<String> getProgressSupervisionAttributes() {
        return this.getAttributes(PROGRESS_SUPERVISION_ATTRIBUTES);
    }

    @Override
    public List<String> getProgressStopAttributes() {
        return this.getAttributes(PROGRESS_STOP_ATTRIBUTES);
    }

    @Override
    public String getProgressDisplayAttribute() {
        return this.properties.getProperty(PROGRESS_DISPLAY_ATTRIBUTE);
    }

    @Override
    public String getProgressAdditionalAction() {
        return this.properties.getProperty(PROGRESS_ADDITIONAL_ACTION);
    }

    @Override
    public HashMap<String, String> getMoActionParameterValues() {
        List<String> parameterExpressions = this.getAttributes(MOACTION_PARAMETER_VALUES);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String parameterExpression : parameterExpressions) {
            String[] nameValuePair = parameterExpression.split("=");
            if (nameValuePair.length != 2) continue;
            result.put(nameValuePair[0], nameValuePair[1]);
        }
        return result;
    }

    @Override
    public boolean initiallyExpandStructs() {
        boolean expand = false;
        String propValue = this.properties.getProperty(EXPAND_STRUCTS);
        MoPropLog.logger().finer("EXPAND_STRUCTS is: " + propValue);
        if (null != propValue && (propValue.equalsIgnoreCase("true") || propValue.equalsIgnoreCase("yes"))) {
            expand = true;
        }
        return expand;
    }

    @Override
    public boolean initiallyExpandSequences() {
        boolean expand = false;
        String propValue = this.properties.getProperty(EXPAND_SEQUENCES);
        MoPropLog.logger().finer("EXPAND_SEQUENCES is: " + propValue);
        if (null != propValue && (propValue.equalsIgnoreCase("true") || propValue.equalsIgnoreCase("yes"))) {
            expand = true;
        }
        return expand;
    }

    public static List<String> getTemporaryPropertyKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(ACTION_NAME_KEY);
        result.add(SELECTED_ATTRIBUTES_NAME_KEY);
        result.add(PROGRESS_DISPLAY_OF_ACTION_EXECUTION);
        result.add(PROGRESS_COUNT_ATTRIBUTE);
        result.add(PROGRESS_START);
        result.add(PROGRESS_TOTAL);
        result.add(PROGRESS_SUPERVISION_ATTRIBUTES);
        result.add(EXPAND_STRUCTS);
        result.add(EXPAND_SEQUENCES);
        result.add(PROGRESS_DISPLAY_ATTRIBUTE);
        result.add(PROGRESS_STOP_ATTRIBUTES);
        result.add(MOACTION_PARAMETER_VALUES);
        result.add(PROGRESS_ADDITIONAL_ACTION);
        return result;
    }

    private List<String> getAttributes(String property) {
        LinkedList<String> attrList = new LinkedList<String>();
        String attributes = this.properties.getProperty(property);
        if (null != attributes) {
            String[] attributesArray = attributes.split(";");
            attrList.addAll(Arrays.asList(attributesArray));
        }
        return attrList;
    }
}

