/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.view.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.emt.mosearch.view.gui.TableMap;

public class TableSorter
extends TableMap {
    private static final long serialVersionUID = 8248278902025910748L;
    int[] index;
    Vector<Integer> sortingColumn = new Vector();
    boolean ascend = true;
    int compare;

    public TableSorter() {
        this.index = new int[0];
    }

    public TableSorter(TableModel m) {
        this.setModel(m);
    }

    public void setModel(TableModel m) {
        super.setModel(m);
        this.reallocateIndex();
    }

    public int compareRowsByColumn(int r1, int r2, int col) {
        Class<?> types = this.tmodel.getColumnClass(col);
        TableModel data = this.tmodel;
        Object obj1 = data.getValueAt(r1, col);
        Object obj2 = data.getValueAt(r2, col);
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        if (types.getSuperclass() == Number.class) {
            return this.compareLong(data, r1, r2, col);
        }
        if (types == Date.class) {
            return this.compareDate(data, r1, r2, col);
        }
        if (types == String.class) {
            return this.compareString(data, r1, r2, col);
        }
        if (types == Boolean.class) {
            return this.compareBoolean(data, r1, r2, col);
        }
        return this.compareObject(data, r1, r2, col);
    }

    private int compareLong(TableModel data, int r1, int r2, int col) {
        Number num2;
        double dv2;
        Number num1 = (Number)data.getValueAt(r1, col);
        double dv1 = num1.doubleValue();
        if (dv1 < (dv2 = (num2 = (Number)data.getValueAt(r2, col)).doubleValue())) {
            return -1;
        }
        if (dv1 > dv2) {
            return 1;
        }
        return 0;
    }

    private int compareDate(TableModel data, int r1, int r2, int col) {
        Date d2;
        long num2;
        Date d1 = (Date)data.getValueAt(r1, col);
        long num1 = d1.getTime();
        if (num1 < (num2 = (d2 = (Date)data.getValueAt(r2, col)).getTime())) {
            return -1;
        }
        if (num1 > num2) {
            return 1;
        }
        return 0;
    }

    private int compareString(TableModel data, int r1, int r2, int col) {
        String str2;
        String str1 = (String)data.getValueAt(r1, col);
        int results = str1.compareTo(str2 = (String)data.getValueAt(r2, col));
        if (results < 0) {
            return -1;
        }
        if (results > 0) {
            return 1;
        }
        return 0;
    }

    private int compareBoolean(TableModel data, int r1, int r2, int col) {
        Boolean bool2;
        boolean bo2;
        Boolean bool1 = (Boolean)data.getValueAt(r1, col);
        boolean bo1 = bool1;
        if (bo1 == (bo2 = (bool2 = (Boolean)data.getValueAt(r2, col)).booleanValue())) {
            return 0;
        }
        if (bo1) {
            return 1;
        }
        return -1;
    }

    private int compareObject(TableModel data, int r1, int r2, int col) {
        Object val2;
        String s2;
        Object val1 = data.getValueAt(r1, col);
        String s1 = val1.toString();
        int results = s1.compareTo(s2 = (val2 = data.getValueAt(r2, col)).toString());
        if (results < 0) {
            return -1;
        }
        if (results > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int r1, int r2) {
        ++this.compare;
        for (int level = 0; level < this.sortingColumn.size(); ++level) {
            Integer col = this.sortingColumn.elementAt(level);
            int results = this.compareRowsByColumn(r1, r2, col);
            if (results == 0) continue;
            return this.ascend ? results : -results;
        }
        return 0;
    }

    public void reallocateIndex() {
        int rows = this.tmodel.getRowCount();
        this.index = new int[rows];
        for (int r = 0; r < rows; ++r) {
            this.index[r] = r;
        }
    }

    public void tableChanged(TableModelEvent event) {
        this.reallocateIndex();
        super.tableChanged(event);
    }

    public void checkTheModel() {
        if (this.index.length != this.tmodel.getRowCount()) {
            System.err.println("Sorter is not informed of a change in model.");
        }
    }

    public void doSort(Object sender) {
        this.checkTheModel();
        this.compare = 0;
        this.shuttlesort((int[])this.index.clone(), this.index, 0, this.index.length);
    }

    public void num2sort() {
        for (int m = 0; m < this.getRowCount(); ++m) {
            for (int n = m + 1; n < this.getRowCount(); ++n) {
                if (this.compare(this.index[m], this.index[n]) != -1) continue;
                this.swap(m, n);
            }
        }
    }

    public void shuttlesort(int[] f, int[] t, int l, int h) {
        if (h - l < 2) {
            return;
        }
        int m = (l + h) / 2;
        this.shuttlesort(t, f, l, m);
        this.shuttlesort(t, f, m, h);
        int p = l;
        int q = m;
        if (h - l >= 4 && this.compare(f[m - 1], f[m]) <= 0) {
            for (int i = l; i < h; ++i) {
                t[i] = f[i];
            }
            return;
        }
        for (int i = l; i < h; ++i) {
            t[i] = q >= h || p < m && this.compare(f[p], f[q]) <= 0 ? f[p++] : f[q++];
        }
    }

    public void swap(int m, int n) {
        int tmp = this.index[m];
        this.index[m] = this.index[n];
        this.index[n] = tmp;
    }

    public Object getValueAt(int row, int column) {
        this.checkTheModel();
        return this.tmodel.getValueAt(this.index[row], column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.checkTheModel();
        this.tmodel.setValueAt(value, this.index[row], column);
    }

    public void sortByColumn(int col) {
        this.sortByColumn(col, true);
    }

    public void sortByColumn(int col, boolean ascend) {
        this.ascend = ascend;
        this.sortingColumn.removeAllElements();
        this.sortingColumn.addElement(new Integer(col));
        this.doSort(this);
        TableModelEvent e = new TableModelEvent(this);
        super.tableChanged(e);
    }

    public void addMouseListenerToHeaderInTable(JTable t) {
        final TableSorter tSorter = this;
        final JTable tView = t;
        tView.setColumnSelectionAllowed(false);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                TableColumnModel columnModel = tView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(event.getX());
                int column = tView.convertColumnIndexToModel(viewColumn);
                if (event.getClickCount() == 1 && column != -1) {
                    int shiftPressed = event.getModifiers() & 1;
                    boolean ascend = shiftPressed == 0;
                    tSorter.sortByColumn(column, ascend);
                }
            }
        };
        JTableHeader th = tView.getTableHeader();
        th.addMouseListener(mouseListener);
    }
}

