/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;

public abstract class DataTypeGUI
extends JPanel {
    private static final long serialVersionUID = 3496293387187429872L;
    protected GUI_Container container = null;
    private boolean isModified = false;
    protected TypeValue myTypeValue = null;
    protected ToolServices myToolServices = null;
    protected String description = "No Description available.";
    protected String fullName = null;
    protected JLabel revMark = null;
    static ImageIcon revMarkOn = null;
    static ImageIcon revMarkOff = null;
    protected final JButton infoBtn = new JButton(" i ");
    protected final Insets infoInsets = new Insets(0, 0, 0, 1);
    protected ActionListener infoActionListener = new InfoActionListener();
    protected JDialog infoD = null;
    protected JTextArea text = null;
    protected static final Hashtable<JDialog, JTextArea> infoDialogs = new Hashtable();

    public DataTypeGUI(GUI_Container container, ToolServices aToolServices) {
        this.container = container;
        this.myToolServices = aToolServices;
        if (revMarkOn == null) {
            try {
                revMarkOn = new ImageIcon(Toolkit.getDefaultToolkit().getImage(DataTypeGUI.class.getResource("revMarkOn.gif")));
            }
            catch (Exception e) {
                revMarkOn = null;
            }
            try {
                revMarkOff = new ImageIcon(Toolkit.getDefaultToolkit().getImage(DataTypeGUI.class.getResource("revMarkOff.gif")));
            }
            catch (Exception e) {
                revMarkOff = null;
            }
        }
        this.revMark = new JLabel();
        this.revMark.setIcon(revMarkOff);
        this.revMark.setAlignmentX(0.0f);
        this.revMark.setAlignmentY(0.0f);
        super.add(this.revMark);
        this.infoBtn.setMargin(this.infoInsets);
        this.infoBtn.setCursor(new Cursor(0));
        this.infoBtn.addActionListener(this.infoActionListener);
        this.setOpaque(false);
    }

    public DataTypeGUI(TypeValue aAttributeModel, GUI_Container container, ToolServices aToolServices) {
        this.container = container;
        this.myTypeValue = aAttributeModel;
        this.myToolServices = aToolServices;
        if (revMarkOn == null) {
            try {
                revMarkOn = new ImageIcon(Toolkit.getDefaultToolkit().getImage(DataTypeGUI.class.getResource("revMarkOn.gif")));
            }
            catch (Exception e) {
                revMarkOn = null;
            }
            try {
                revMarkOff = new ImageIcon(Toolkit.getDefaultToolkit().getImage(DataTypeGUI.class.getResource("revMarkOff.gif")));
            }
            catch (Exception e) {
                revMarkOff = null;
            }
        }
        this.revMark = new JLabel();
        this.revMark.setAlignmentX(0.0f);
        this.revMark.setAlignmentY(0.0f);
        super.add(this.revMark);
        this.revMark.setIcon(revMarkOff);
        if (this.myTypeValue.getDescription() != null) {
            this.infoBtn.addActionListener(this.infoActionListener);
        }
        this.setOpaque(false);
        this.setName(aAttributeModel.getName() + "_Value");
    }

    protected Font getGUIFont() {
        return this.getFont();
    }

    public static void closeInfoDialog(GUI_Container cont) {
        Enumeration<JDialog> dialogs = infoDialogs.keys();
        while (dialogs.hasMoreElements()) {
            JDialog info = dialogs.nextElement();
            if (!cont.equals(info.getOwner())) continue;
            infoDialogs.remove(info);
        }
    }

    public void removeListeners() {
        this.infoBtn.removeActionListener(this.infoActionListener);
        this.infoActionListener = null;
    }

    private void formatDialog(JDialog dia, JTextArea text) {
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        JScrollPane scroll = new JScrollPane(text);
        scroll.setVerticalScrollBarPolicy(20);
        JButton close = new JButton("Close");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel b_panel = new JPanel();
        panel.add((Component)scroll, "Center");
        panel.add((Component)b_panel, "South");
        b_panel.add(close);
        this.infoD.getContentPane().add(panel);
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                infoDialogs.remove(DataTypeGUI.this.infoD);
                DataTypeGUI.this.infoD.setVisible(false);
                DataTypeGUI.this.infoD.dispose();
            }
        });
        dia.pack();
    }

    public String applyValue() {
        return this.myTypeValue.setValue(this.getValue());
    }

    public String getTypeCode() {
        return this.myTypeValue.getMomXmlType();
    }

    public String getResolution() {
        String resolution = null;
        if (this.myTypeValue instanceof CorbaTypeValue) {
            MomCorbaTypeAttribute momCorbaType = ((CorbaTypeValue)this.myTypeValue).getMomCorbaTypeAttribute();
            resolution = momCorbaType.getResolution();
        }
        return resolution;
    }

    public String getValue() {
        return "";
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean faultyValueEntered() {
        return false;
    }

    public void refreshValue() {
        String value = "";
        if (this.myTypeValue.isValueDefined()) {
            value = this.myTypeValue.getValueAsString();
        }
        this.setValue(value);
    }

    public void setModified(boolean value) {
        this.isModified = value;
        if (this.isModified) {
            this.revMark.setIcon(revMarkOn);
        } else {
            this.revMark.setIcon(revMarkOff);
        }
        if (this.container != null) {
            this.container.valueChanged();
        }
    }

    public GUI_Container getContainer() {
        return this.container;
    }

    public GUI_Container getParentFrame(GUI_Container container) {
        GUI_Container cont = container;
        if (cont instanceof DataTypeGUI) {
            boolean isDataType = true;
            while (isDataType) {
                cont = ((DataTypeGUI)((Object)cont)).getContainer();
                isDataType = false;
                if (!(cont instanceof DataTypeGUI)) continue;
                isDataType = true;
            }
        }
        return cont;
    }

    private JFrame getJFrame() {
        Container p = this;
        boolean noframe = true;
        if (p instanceof JFrame) {
            noframe = false;
        }
        while (noframe) {
            if (!((p = p.getParent()) instanceof JFrame)) continue;
            noframe = false;
        }
        return (JFrame)p;
    }

    public JPanel getPanel() {
        return this;
    }

    public void setValue(String value) {
    }

    public void setGUIEditable(boolean editable) {
    }

    public void setMargin(Insets inserts) {
        this.infoBtn.setMargin(inserts);
    }

    public TypeValue getTypeValue() {
        return this.myTypeValue;
    }

    public String getName() {
        return this.fullName;
    }

    public void setName(String fullName) {
        this.fullName = fullName;
        if (!(this.getPanel() instanceof DataTypeGUI)) {
            this.getPanel().setName(fullName);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected class CloseInfoActionListener
    implements ActionListener {
        protected CloseInfoActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            infoDialogs.remove(DataTypeGUI.this.infoD);
            DataTypeGUI.this.infoD.setVisible(false);
            DataTypeGUI.this.infoD.dispose();
        }
    }

    protected class InfoActionListener
    implements ActionListener {
        protected InfoActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean foundOne = false;
            if (!infoDialogs.isEmpty()) {
                JFrame cont = DataTypeGUI.this.getJFrame();
                Enumeration<JDialog> dialogs = infoDialogs.keys();
                while (dialogs.hasMoreElements()) {
                    DataTypeGUI.this.infoD = dialogs.nextElement();
                    DataTypeGUI.this.text = infoDialogs.get(DataTypeGUI.this.infoD);
                    if (!cont.equals(DataTypeGUI.this.infoD.getOwner())) continue;
                    foundOne = true;
                    break;
                }
            }
            if (!foundOne) {
                try {
                    DataTypeGUI.this.infoD = new JDialog(DataTypeGUI.this.getJFrame());
                    DataTypeGUI.this.text = new JTextArea(10, 50);
                    DataTypeGUI.this.formatDialog(DataTypeGUI.this.infoD, DataTypeGUI.this.text);
                    infoDialogs.put(DataTypeGUI.this.infoD, DataTypeGUI.this.text);
                }
                catch (Exception c) {
                    return;
                }
            }
            DataTypeGUI.this.infoD.setTitle("Description for - " + DataTypeGUI.this.getName());
            DataTypeGUI.this.text.setText(DataTypeGUI.this.getName() + "\n" + DataTypeGUI.this.getDescription());
            DataTypeGUI.this.text.setCaretPosition(0);
            DataTypeGUI.this.infoD.setVisible(true);
            DataTypeGUI.this.myToolServices.sendEmNotification(GuiTestEventTypes.INFORMATION_WINDOW_UPDATED, "The information window has been updated", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
        }
    }
}

